/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.clustering.optics;

import ca.pfv.spmf.algorithms.clustering.optics.AlgoOPTICS;
import ca.pfv.spmf.algorithms.clustering.optics.DoubleArrayOPTICS;
import ca.pfv.spmf.patterns.cluster.Cluster;
import ca.pfv.spmf.patterns.cluster.DoubleArray;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;

public class MainTestOPTICS_extractDBScan_saveToMemory {
    public static void main(String[] args) throws NumberFormatException, IOException {
        String input = MainTestOPTICS_extractDBScan_saveToMemory.fileToPath("inputDBScan.txt");
        int minPts = 2;
        double epsilon = 5.0;
        double epsilonPrime = 5.0;
        String separator = " ";
        AlgoOPTICS algo = new AlgoOPTICS();
        List<DoubleArrayOPTICS> clusterOrdering = algo.computerClusterOrdering(input, minPts, epsilon, separator);
        System.out.println("THE CLUSTER ORDERING:");
        System.out.println(" [data point] - reachability distance");
        for (DoubleArrayOPTICS arrayOP : clusterOrdering) {
            System.out.println(" " + Arrays.toString(arrayOP.data) + " -  " + arrayOP.reachabilityDistance);
        }
        List<Cluster> dbScanClusters = algo.extractDBScan(minPts, epsilonPrime);
        System.out.println("CLUSTER(S) FOUND:");
        int i = 0;
        for (Cluster cluster : dbScanClusters) {
            System.out.println("Cluster " + i++);
            for (DoubleArray dataPoint : cluster.getVectors()) {
                System.out.println("   " + dataPoint);
            }
        }
        algo.printStatistics();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestOPTICS_extractDBScan_saveToMemory.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

