/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.d2hup;

import ca.pfv.spmf.algorithms.ItemNameConverter;
import ca.pfv.spmf.algorithms.frequentpatterns.d2hup.Cell;
import ca.pfv.spmf.algorithms.frequentpatterns.d2hup.Pointer;
import ca.pfv.spmf.algorithms.frequentpatterns.d2hup.Row;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoD2HUP {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int huiCount = 0;
    int case1count = 0;
    int case2count = 0;
    BufferedWriter writer = null;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    boolean DEBUG = false;
    Cell[] cells;
    int minUtility = 0;
    private Map<Integer, Row> mapItemRow;
    ItemNameConverter nameConverter;

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        ArrayList<Row> rowList;
        int transactionCount;
        block31: {
            String thisLine;
            int itemOccurrencesCount;
            BufferedReader myInput;
            HashMap<Integer, Integer> mapItemToTWU;
            block29: {
                MemoryLogger.getInstance().reset();
                this.itemsetBuffer = new int[200];
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.minUtility = minUtility;
                mapItemToTWU = new HashMap<Integer, Integer>();
                this.case1count = 0;
                this.case2count = 0;
                myInput = null;
                itemOccurrencesCount = 0;
                transactionCount = 0;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = (Integer)mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                mapItemToTWU.put(item, twu);
                                ++itemOccurrencesCount;
                                ++i;
                            }
                            ++transactionCount;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            rowList = new ArrayList<Row>();
            this.mapItemRow = new HashMap<Integer, Row>();
            this.cells = new Cell[transactionCount + itemOccurrencesCount];
            for (Integer item : mapItemToTWU.keySet()) {
                int twu = (Integer)mapItemToTWU.get(item);
                if (twu < minUtility) continue;
                Row rowItem = new Row(item);
                rowItem.ltwu = twu;
                rowList.add(rowItem);
                this.mapItemRow.put(item, rowItem);
            }
            Collections.sort(rowList, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    int compare = (Integer)mapItemToTWU.get(o1.item) - (Integer)mapItemToTWU.get(o2.item);
                    return compare == 0 ? o1.item - o2.item : compare;
                }
            });
            this.nameConverter = new ItemNameConverter(rowList.size());
            for (Row row : rowList) {
                row.item = this.nameConverter.assignNewName(row.item);
            }
            this.cells[0] = null;
            int currentCellIndex = 0;
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        Cell cell;
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int remainingUtility = 0;
                        int transactionBegin = currentCellIndex;
                        int i = 0;
                        while (i < items.length) {
                            int item = Integer.parseInt(items[i]);
                            if ((Integer)mapItemToTWU.get(item) >= minUtility) {
                                cell = new Cell();
                                cell.utility = Integer.parseInt(utilityValues[i]);
                                cell.item = this.nameConverter.toNewName(item);
                                this.cells[currentCellIndex++] = cell;
                                remainingUtility += cell.utility;
                            }
                            ++i;
                        }
                        int transactionEnd = currentCellIndex - 1;
                        Arrays.sort(this.cells, transactionBegin, transactionEnd + 1, new Comparator<Cell>(){

                            @Override
                            public int compare(Cell o1, Cell o2) {
                                return o1.item - o2.item;
                            }
                        });
                        this.cells[currentCellIndex++] = null;
                        int i2 = transactionBegin;
                        while (i2 <= transactionEnd) {
                            cell = this.cells[i2];
                            Row row = this.mapItemRow.get(this.nameConverter.toOldName(cell.item));
                            ++row.support;
                            row.utility += cell.utility;
                            row.rutil += (remainingUtility -= cell.utility);
                            row.pointers.add(new Pointer(0, i2));
                            ++i2;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        if (this.DEBUG) {
            System.out.println("------ INITIAL CAUL -----");
            System.out.println("The cell list:");
            int i = 1;
            while (i < this.cells.length) {
                Cell cell = this.cells[i];
                if (cell == null) {
                    System.out.println("|");
                } else {
                    System.out.print(cell);
                }
                ++i;
            }
            System.out.println("The table:");
            for (Row row : rowList) {
                System.out.print(row);
                System.out.print("[the items:");
                for (Pointer pointer : row.pointers) {
                    System.out.print(String.valueOf(this.cells[pointer.pos].item) + " ");
                }
                System.out.println();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.d2hup(this.itemsetBuffer, 0, rowList, transactionCount, 0);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void d2hup(int[] prefix, int prefixLength, List<Row> rowList, int prefixSupport, int prefixUtility) throws IOException {
        if (this.DEBUG) {
            System.out.print(" prefix : ");
            int i = 0;
            while (i < prefixLength) {
                System.out.print(" " + prefix[i]);
                ++i;
            }
            System.out.println();
        }
        boolean allPromisingItemsHaveSameSupportAsPrefix = true;
        boolean allPromisingItemAreHighUtility = true;
        for (Row row : rowList) {
            if (row.utility >= this.minUtility) continue;
            allPromisingItemAreHighUtility = false;
            break;
        }
        for (Row row : rowList) {
            if (row.support == prefixSupport) continue;
            allPromisingItemsHaveSameSupportAsPrefix = false;
            break;
        }
        if (allPromisingItemsHaveSameSupportAsPrefix && allPromisingItemAreHighUtility) {
            long i = 1L;
            long max = 1 << rowList.size();
            while (i < max) {
                int newPrefixLength = prefixLength;
                int utility = prefixUtility;
                int j = 0;
                while (j < rowList.size()) {
                    int isSet = (int)i & 1 << j;
                    if (isSet > 0) {
                        this.itemsetBuffer[newPrefixLength++] = rowList.get((int)j).item;
                        utility += rowList.get((int)j).utility - prefixUtility;
                    }
                    ++j;
                }
                this.writeOut(prefix, newPrefixLength, utility);
                ++i;
            }
            ++this.case1count;
            return;
        }
        if (allPromisingItemsHaveSameSupportAsPrefix) {
            int delta = Integer.MAX_VALUE;
            for (Row row : rowList) {
                int n = row.utility - prefixUtility;
                if (n >= delta) continue;
                delta = n;
            }
            int sum = prefixUtility;
            for (Row row : rowList) {
                sum += row.utility - prefixUtility;
            }
            if (this.minUtility <= sum && sum < this.minUtility + delta) {
                ++this.case2count;
                int itemsetLength = prefixLength;
                for (Row row : rowList) {
                    prefix[itemsetLength++] = row.item;
                }
                this.writeOut(prefix, itemsetLength, sum);
                return;
            }
        }
        for (Row row : rowList) {
            if (row.utility >= this.minUtility) {
                this.writeOut(prefix, prefixLength, row.item, row.utility);
            }
            if (row.utility + row.rutil < this.minUtility) continue;
            ArrayList<Row> newRowList = new ArrayList<Row>();
            this.mapItemRow.clear();
            for (Pointer pointer : row.pointers) {
                int transactionBegin = pointer.pos;
                int newPrefixRowUtility = pointer.prefixUtility + this.cells[pointer.pos].utility;
                if (this.cells[++transactionBegin] == null) continue;
                int transactionEnd = -1;
                int rtwu = 0;
                int pos = transactionBegin;
                while (true) {
                    if (this.cells[pos] == null) break;
                    rtwu += this.cells[pos].utility;
                    ++pos;
                }
                transactionEnd = pos - 1;
                int remainingUtility = rtwu;
                int pos2 = transactionBegin;
                while (pos2 <= transactionEnd) {
                    Cell cell = this.cells[pos2];
                    Row rowItem = this.mapItemRow.get(cell.item);
                    if (rowItem == null) {
                        rowItem = new Row(cell.item);
                        this.mapItemRow.put(cell.item, rowItem);
                    }
                    ++rowItem.support;
                    rowItem.utility += newPrefixRowUtility + cell.utility;
                    rowItem.ltwu += rtwu;
                    Pointer newPointer = new Pointer(newPrefixRowUtility, pos2);
                    rowItem.pointers.add(newPointer);
                    rowItem.rutil += (remainingUtility -= cell.utility);
                    ++pos2;
                }
            }
            for (Map.Entry entry : this.mapItemRow.entrySet()) {
                Row currentRow = (Row)entry.getValue();
                if (row.utility + currentRow.ltwu < this.minUtility) continue;
                newRowList.add(currentRow);
            }
            Collections.sort(newRowList, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    return o1.item - o2.item;
                }
            });
            this.itemsetBuffer[prefixLength] = row.item;
            this.d2hup(this.itemsetBuffer, prefixLength + 1, newRowList, row.support, row.utility);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void writeOut(int[] prefix, int prefixLength, int item, int utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(this.nameConverter.toOldName(prefix[i]));
            buffer.append(' ');
            ++i;
        }
        buffer.append(this.nameConverter.toOldName(item));
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void writeOut(int[] prefix, int prefixLength, int utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(this.nameConverter.toOldName(prefix[i]));
            buffer.append(' ');
            ++i;
        }
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  D2HUP ALGORITHM v97- STATS =============");
        System.out.println(" Case1 count: " + this.case1count + " | Case2 count: " + this.case2count);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println("===================================================");
    }
}

