/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.defme;

import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids_bitset.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoDefMe {
    private int minsupRelative;
    private TransactionDatabase database;
    private long startTimestamp;
    private long endTime;
    protected Itemsets generators;
    BufferedWriter writer = null;
    private int itemsetCount;
    private Map<Integer, BitSetSupport> mapItemTIDS;
    final int BUFFERS_SIZE = 2000;
    private int[] itemsetBuffer = null;

    public Itemsets runAlgorithm(String output, TransactionDatabase database, double minsup) throws IOException {
        MemoryLogger.getInstance().reset();
        this.itemsetBuffer = new int[2000];
        if (output == null) {
            this.writer = null;
            this.generators = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.generators = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.itemsetCount = 0;
        this.database = database;
        this.startTimestamp = System.currentTimeMillis();
        this.minsupRelative = (int)Math.ceil(minsup * (double)database.size());
        this.mapItemTIDS = new HashMap<Integer, BitSetSupport>();
        int i = 0;
        while (i < database.size()) {
            for (Integer n : database.getTransactions().get(i)) {
                BitSetSupport tids = this.mapItemTIDS.get(n);
                if (tids == null) {
                    tids = new BitSetSupport();
                    this.mapItemTIDS.put(n, tids);
                }
                tids.bitset.set(i);
                ++tids.support;
            }
            ++i;
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        for (Map.Entry entry : this.mapItemTIDS.entrySet()) {
            BitSetSupport tidset = (BitSetSupport)entry.getValue();
            int support = tidset.support;
            int item = (Integer)entry.getKey();
            if (support < this.minsupRelative) continue;
            frequentItems.add(item);
        }
        Collections.sort(frequentItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return ((BitSetSupport)((AlgoDefMe)AlgoDefMe.this).mapItemTIDS.get((Object)arg0)).support - ((BitSetSupport)((AlgoDefMe)AlgoDefMe.this).mapItemTIDS.get((Object)arg1)).support;
            }
        });
        BitSet bitSet = new BitSet(database.size());
        bitSet.set(0, database.size());
        this.defme(this.itemsetBuffer, 0, bitSet, database.size(), frequentItems, 0, new BitSet[0]);
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        return this.generators;
    }

    private void defme(int[] itemsetX, int itemsetLength, BitSet tidsetX, int supportX, List<Integer> frequentItems, int posTail, BitSet[] critItemsetX) throws IOException {
        if (itemsetLength != 0) {
            BitSet[] bitSetArray = critItemsetX;
            int n = critItemsetX.length;
            int n2 = 0;
            while (n2 < n) {
                BitSet covStarXe = bitSetArray[n2];
                if (covStarXe.cardinality() == 0) {
                    return;
                }
                ++n2;
            }
        }
        this.save(itemsetX, itemsetLength, tidsetX, supportX);
        int i = posTail;
        while (i < frequentItems.size()) {
            Integer e = frequentItems.get(i);
            BitSetSupport tidsetE = this.mapItemTIDS.get(e);
            itemsetX[itemsetLength] = e;
            int newItemsetLength = itemsetLength + 1;
            BitSet tidsetXe = (BitSet)tidsetX.clone();
            tidsetXe.and(tidsetE.bitset);
            int supportXe = tidsetXe.cardinality();
            if (supportXe >= this.minsupRelative) {
                BitSet[] critItemsetY = new BitSet[newItemsetLength];
                BitSet critE = (BitSet)tidsetX.clone();
                critE.andNot(tidsetE.bitset);
                critItemsetY[critItemsetY.length - 1] = critE;
                int j = 0;
                while (j < itemsetLength) {
                    critItemsetY[j] = (BitSet)critItemsetX[j].clone();
                    critItemsetY[j].and(tidsetE.bitset);
                    ++j;
                }
                this.defme(itemsetX, newItemsetLength, tidsetXe, supportXe, frequentItems, i + 1, critItemsetY);
            }
            ++i;
        }
    }

    private void save(int[] prefix, int prefixLength, BitSet tidset, int support) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            int[] itemsetArray = new int[prefixLength];
            System.arraycopy(prefix, 0, itemsetArray, 0, prefixLength);
            Itemset itemset = new Itemset(itemsetArray);
            itemset.setTIDs(tidset, support);
            this.generators.addItemset(itemset, itemset.size());
        } else {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < prefixLength) {
                int item = prefix[i];
                buffer.append(item);
                buffer.append(" ");
                ++i;
            }
            buffer.append("#SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("=============  DefMe - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Generator itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    public Itemsets getItemsets() {
        return this.generators;
    }

    public class BitSetSupport {
        BitSet bitset = new BitSet();
        int support;
    }
}

