/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.eclat;

import ca.pfv.spmf.datastructures.triangularmatrix.TriangularMatrix;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoEclat {
    private int minsupRelative;
    protected TransactionDatabase database;
    protected long startTimestamp;
    protected long endTime;
    protected Itemsets frequentItemsets;
    BufferedWriter writer = null;
    protected int itemsetCount;
    private TriangularMatrix matrix;
    final int BUFFERS_SIZE = 2000;
    private int[] itemsetBuffer = null;

    public Itemsets runAlgorithm(String output, TransactionDatabase database, double minsupp, boolean useTriangularMatrixOptimization) throws IOException {
        MemoryLogger.getInstance().reset();
        this.itemsetBuffer = new int[2000];
        if (output == null) {
            this.writer = null;
            this.frequentItemsets = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.frequentItemsets = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.itemsetCount = 0;
        this.database = database;
        this.startTimestamp = System.currentTimeMillis();
        this.minsupRelative = (int)Math.ceil(minsupp * (double)database.size());
        final HashMap<Integer, Set<Integer>> mapItemCount = new HashMap<Integer, Set<Integer>>();
        int maxItemId = this.calculateSupportSingleItems(database, mapItemCount);
        if (useTriangularMatrixOptimization) {
            this.matrix = new TriangularMatrix(maxItemId + 1);
            for (List<Integer> itemset : database.getTransactions()) {
                Object[] array = itemset.toArray();
                int i = 0;
                while (i < itemset.size()) {
                    Integer itemI = (Integer)array[i];
                    int j = i + 1;
                    while (j < itemset.size()) {
                        Integer itemJ = (Integer)array[j];
                        this.matrix.incrementCount(itemI, itemJ);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            Set tidset = (Set)entry.getValue();
            int support = tidset.size();
            int item = (Integer)entry.getKey();
            if (support < this.minsupRelative) continue;
            frequentItems.add(item);
            this.saveSingleItem(item, tidset, tidset.size());
        }
        Collections.sort(frequentItems, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return ((Set)mapItemCount.get(arg0)).size() - ((Set)mapItemCount.get(arg1)).size();
            }
        });
        int i = 0;
        while (i < frequentItems.size()) {
            Integer itemI = (Integer)frequentItems.get(i);
            Set tidsetI = (Set)mapItemCount.get(itemI);
            int supportI = tidsetI.size();
            ArrayList<Integer> equivalenceClassIitems = new ArrayList<Integer>();
            ArrayList<Set<Integer>> equivalenceClassItidsets = new ArrayList<Set<Integer>>();
            int j = i + 1;
            while (j < frequentItems.size()) {
                int support;
                int itemJ = (Integer)frequentItems.get(j);
                if (!useTriangularMatrixOptimization || (support = this.matrix.getSupportForItems(itemI, itemJ)) >= this.minsupRelative) {
                    Set tidsetJ = (Set)mapItemCount.get(itemJ);
                    int supportJ = tidsetJ.size();
                    Set<Integer> tidsetIJ = this.performANDFirstTime(tidsetI, supportI, tidsetJ, supportJ);
                    if (useTriangularMatrixOptimization || this.calculateSupport(2, supportI, tidsetIJ) >= this.minsupRelative) {
                        equivalenceClassIitems.add(itemJ);
                        equivalenceClassItidsets.add(tidsetIJ);
                    }
                }
                ++j;
            }
            if (equivalenceClassIitems.size() > 0) {
                this.itemsetBuffer[0] = itemI;
                this.processEquivalenceClass(this.itemsetBuffer, 1, supportI, equivalenceClassIitems, equivalenceClassItidsets);
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        return this.frequentItemsets;
    }

    private int calculateSupportSingleItems(TransactionDatabase database, Map<Integer, Set<Integer>> mapItemCount) {
        int maxItemId = 0;
        int i = 0;
        while (i < database.size()) {
            for (Integer item : database.getTransactions().get(i)) {
                Set<Integer> set = mapItemCount.get(item);
                if (set == null) {
                    set = new HashSet<Integer>();
                    mapItemCount.put(item, set);
                    if (item > maxItemId) {
                        maxItemId = item;
                    }
                }
                set.add(i);
            }
            ++i;
        }
        return maxItemId;
    }

    private void processEquivalenceClass(int[] prefix, int prefixLength, int supportPrefix, List<Integer> equivalenceClassItems, List<Set<Integer>> equivalenceClassTidsets) throws IOException {
        int length = prefixLength + 1;
        if (equivalenceClassItems.size() == 1) {
            int itemI = equivalenceClassItems.get(0);
            Set<Integer> tidsetItemset = equivalenceClassTidsets.get(0);
            int support = this.calculateSupport(length, supportPrefix, tidsetItemset);
            this.save(prefix, prefixLength, itemI, tidsetItemset, support);
            return;
        }
        if (equivalenceClassItems.size() == 2) {
            int itemI = equivalenceClassItems.get(0);
            Set<Integer> tidsetI = equivalenceClassTidsets.get(0);
            int supportI = this.calculateSupport(length, supportPrefix, tidsetI);
            this.save(prefix, prefixLength, itemI, tidsetI, supportI);
            int itemJ = equivalenceClassItems.get(1);
            Set<Integer> tidsetJ = equivalenceClassTidsets.get(1);
            int supportJ = this.calculateSupport(length, supportPrefix, tidsetJ);
            this.save(prefix, prefixLength, itemJ, tidsetJ, supportJ);
            Set<Integer> tidsetIJ = this.performAND(tidsetI, tidsetI.size(), tidsetJ, tidsetJ.size());
            int supportIJ = this.calculateSupport(length, supportI, tidsetIJ);
            if (supportIJ >= this.minsupRelative) {
                int newPrefixLength = prefixLength + 1;
                prefix[prefixLength] = itemI;
                this.save(prefix, newPrefixLength, itemJ, tidsetIJ, supportIJ);
            }
            return;
        }
        int i = 0;
        while (i < equivalenceClassItems.size()) {
            int suffixI = equivalenceClassItems.get(i);
            Set<Integer> tidsetI = equivalenceClassTidsets.get(i);
            int supportI = this.calculateSupport(length, supportPrefix, tidsetI);
            this.save(prefix, prefixLength, suffixI, tidsetI, supportI);
            ArrayList<Integer> equivalenceClassISuffixItems = new ArrayList<Integer>();
            ArrayList<Set<Integer>> equivalenceITidsets = new ArrayList<Set<Integer>>();
            int j = i + 1;
            while (j < equivalenceClassItems.size()) {
                int supportJ;
                int suffixJ = equivalenceClassItems.get(j);
                Set<Integer> tidsetJ = equivalenceClassTidsets.get(j);
                Set<Integer> tidsetIJ = this.performAND(tidsetI, supportI, tidsetJ, supportJ = this.calculateSupport(length, supportPrefix, tidsetJ));
                int supportIJ = this.calculateSupport(length, supportI, tidsetIJ);
                if (supportIJ >= this.minsupRelative) {
                    equivalenceClassISuffixItems.add(suffixJ);
                    equivalenceITidsets.add(tidsetIJ);
                }
                ++j;
            }
            if (equivalenceClassISuffixItems.size() > 0) {
                prefix[prefixLength] = suffixI;
                int newPrefixLength = prefixLength + 1;
                this.processEquivalenceClass(prefix, newPrefixLength, supportI, equivalenceClassISuffixItems, equivalenceITidsets);
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    int calculateSupport(int lengthOfX, int supportPrefix, Set<Integer> tidsetI) {
        return tidsetI.size();
    }

    Set<Integer> performAND(Set<Integer> tidsetI, int supportI, Set<Integer> tidsetJ, int supportJ) {
        HashSet<Integer> tidsetIJ = new HashSet<Integer>();
        if (supportI > supportJ) {
            for (Integer tid : tidsetJ) {
                if (!tidsetI.contains(tid)) continue;
                tidsetIJ.add(tid);
            }
        } else {
            for (Integer tid : tidsetI) {
                if (!tidsetJ.contains(tid)) continue;
                tidsetIJ.add(tid);
            }
        }
        return tidsetIJ;
    }

    Set<Integer> performANDFirstTime(Set<Integer> tidsetI, int supportI, Set<Integer> tidsetJ, int supportJ) {
        return this.performAND(tidsetI, supportI, tidsetJ, supportJ);
    }

    private void save(int[] prefix, int prefixLength, int suffixItem, Set<Integer> tidset, int support) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            int[] itemsetArray = new int[prefixLength + 1];
            System.arraycopy(prefix, 0, itemsetArray, 0, prefixLength);
            itemsetArray[prefixLength] = suffixItem;
            Itemset itemset = new Itemset(itemsetArray);
            itemset.setAbsoluteSupport(support);
            this.frequentItemsets.addItemset(itemset, itemset.size());
        } else {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < prefixLength) {
                int item = prefix[i];
                buffer.append(item);
                buffer.append(" ");
                ++i;
            }
            buffer.append(suffixItem);
            buffer.append(" #SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    private void saveSingleItem(int item, Set<Integer> tidset, int support) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            Itemset itemset = new Itemset(new int[]{item});
            itemset.setAbsoluteSupport(support);
            this.frequentItemsets.addItemset(itemset, itemset.size());
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(item);
            buffer.append(" #SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("=============  ECLAT v0.96r18 - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    public Itemsets getItemsets() {
        return this.frequentItemsets;
    }
}

