/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.efim_closed;

import ca.pfv.spmf.algorithms.frequentpatterns.efim_closed.Itemset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Itemsets {
    private final List<List<Itemset>> levels = new ArrayList<List<Itemset>>();
    private int itemsetsCount = 0;
    private String name;

    public Itemsets(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public void printItemsets() {
        System.out.println(" ------- " + this.name + " -------");
        int patternCount = 0;
        int levelCount = 0;
        for (List<Itemset> level : this.levels) {
            System.out.println("  L" + levelCount + " ");
            for (Itemset itemset : level) {
                Arrays.sort(itemset.getItems());
                System.out.print("  pattern " + patternCount + ":  " + itemset.toString());
                System.out.print("Utility :  " + itemset.getUtility());
                ++patternCount;
                System.out.println(" ");
            }
            ++levelCount;
        }
        System.out.println(" --------------------------------");
    }

    public void addItemset(Itemset itemset, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(itemset);
        ++this.itemsetsCount;
    }

    public List<List<Itemset>> getLevels() {
        return this.levels;
    }

    public int getItemsetsCount() {
        return this.itemsetsCount;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void decreaseItemsetCount() {
        --this.itemsetsCount;
    }
}

