/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.estDec;

import ca.pfv.spmf.algorithms.frequentpatterns.estDec.estTree;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;

public class Algo_estDec {
    estTree tree;
    private long miningTime = 0L;
    double sumTransactionInsertionTime = 0.0;
    private double maxMemory = 0.0;

    public Algo_estDec(double mins, double minSigValue) {
        this.tree = new estTree(mins, minSigValue);
    }

    public void processTransactionFromFile(String input) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited = line.split(" ");
            int[] transaction = new int[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                transaction[i] = Integer.parseInt(lineSplited[i]);
                ++i;
            }
            this.processTransaction(transaction);
        }
        reader.close();
    }

    public void processTransactionFromFile(String input, int lineCount) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        int n = 0;
        while ((line = reader.readLine()) != null && n < lineCount) {
            String[] lineSplited = line.split(" ");
            int[] transaction = new int[lineSplited.length];
            int i = 0;
            while (i < lineSplited.length) {
                transaction[i] = Integer.parseInt(lineSplited[i]);
                ++i;
            }
            this.processTransaction(transaction);
            ++n;
        }
        reader.close();
    }

    public void performMining_saveResultToFile(String outputPath) throws IOException {
        long startMiningTimeStamp = System.currentTimeMillis();
        this.tree.patternMining_saveToFile(outputPath);
        this.miningTime = System.currentTimeMillis() - startMiningTimeStamp;
        System.gc();
        this.checkMemory();
    }

    public Hashtable<int[], Double> performMining_saveResultToMemory() throws IOException {
        long startMiningTimeStamp = System.currentTimeMillis();
        Hashtable<int[], Double> patterns = this.tree.patternMining_saveToMemory();
        this.checkMemory();
        this.miningTime = System.currentTimeMillis() - startMiningTimeStamp;
        return patterns;
    }

    public void processTransaction(int[] transaction) {
        double startCTimestamp = System.currentTimeMillis();
        this.tree.updateParams(transaction);
        this.tree.insertItemset(transaction);
        if (this.tree.getK() % 10000 == 0) {
            this.tree.forcePruning(this.tree.root);
        }
        this.sumTransactionInsertionTime += (double)System.currentTimeMillis() - startCTimestamp;
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void setDecayRate(double b, double h) {
        this.tree.setDecayRate(b, h);
    }

    public void printStats() {
        System.out.println("=============  ESTDEC - STATS =============");
        System.out.println(" Number of nodes : " + this.tree.nodeCount(this.tree.root));
        System.out.println(" Frequent itemsets count : " + this.tree.patternCount);
        System.out.println(" Maximum memory usage : " + this.maxMemory + " mb");
        System.out.println(" Number of transactions: " + this.tree.getK());
        System.out.println(" Total insertion time ~ " + this.sumTransactionInsertionTime + " ms");
        System.out.println(" Insertion time per transaction ~ " + this.sumTransactionInsertionTime / (double)this.tree.getK() + " ms");
        System.out.println(" Mining time ~ " + this.miningTime + " ms");
        System.out.println("===================================================");
    }
}

