/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.estDec;

import ca.pfv.spmf.algorithms.frequentpatterns.estDec.CPTreeNode;
import ca.pfv.spmf.algorithms.frequentpatterns.estDec.ParentNode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class CPTree {
    private double N = 0.0;
    private double d;
    private double delta;
    int patternCount = 0;
    Hashtable<int[], Double> patterns;
    private BufferedWriter writer;
    private double minsup;
    private double minsig;
    private double minmerg;
    CPTreeNode root;
    int[] itemsetBuffer = new int[500];

    CPTree(double decay, double mins, double minSigValue, double deltaValue, double minMergeValue) {
        this.minsup = mins;
        this.minsig = minSigValue;
        this.minmerg = minMergeValue;
        this.d = decay;
        this.delta = deltaValue;
        this.root = new CPTreeNode();
    }

    void setDecayRate(double b, double h) {
        this.d = Math.pow(b, -1.0 / h);
    }

    void updateParams() {
        this.N += 1.0;
    }

    void insertItemset(int[] transaction) {
        ArrayList<Integer> transaction2 = new ArrayList<Integer>();
        int[] nArray = transaction;
        int n = transaction.length;
        int n2 = 0;
        while (n2 < n) {
            int item = nArray[n2];
            CPTreeNode child = this.root.getChildWithID(item, -1);
            if (child == null) {
                this.root.children.add(new CPTreeNode(item, this.root, -1, 1.0));
            } else if (child.counter1 / this.N >= this.minsig) {
                transaction2.add(item);
            }
            ++n2;
        }
        int ind = 0;
        while (ind < transaction2.size()) {
            Integer item = (Integer)transaction2.get(ind);
            CPTreeNode child = this.root.getChildWithID(item, -1);
            if (child != null) {
                this.itemsetBuffer[0] = item;
                this.insert_n_itemsets(child, (short)0, transaction2, ind + 1, this.itemsetBuffer, 1);
            }
            ++ind;
        }
    }

    double getCountOfItemset(int[] itemset) {
        CPTreeNode currentNode = this.root.getChildWithID(itemset[0], -1);
        int ind = 1;
        short parentInd = 0;
        int l = 1;
        CPTreeNode parentNode = currentNode;
        while (ind < itemset.length) {
            short oldPInd = parentInd;
            if ((parentInd = currentNode.getInnerIndexWithID(itemset[ind], parentNode, parentInd)) != -1) {
                ++ind;
                ++l;
                continue;
            }
            if ((currentNode = currentNode.getChildWithID(itemset[ind], oldPInd)) != null) {
                parentNode = currentNode;
                parentInd = 0;
                l = 1;
                ++ind;
                continue;
            }
            return 0.0;
        }
        return currentNode.estimateMergeCount(l, currentNode.getLongestLevel());
    }

    double estimateCount(int[] itemset, int length) {
        double min = Double.MAX_VALUE;
        int[] itemset2 = new int[length - 1];
        int i = 0;
        while (i < length) {
            System.arraycopy(itemset, 0, itemset2, 0, i);
            System.arraycopy(itemset, i + 1, itemset2, i, length - i - 1);
            double c = this.getCountOfItemset(itemset2);
            if (c == 0.0) {
                return 0.0;
            }
            if (c < min) {
                min = c;
            }
            ++i;
        }
        return min;
    }

    public void insert_n_itemsets(CPTreeNode currentNode, short PI, List<Integer> transaction, int ind, int[] itemset, int length) {
        int item;
        if (ind >= transaction.size()) {
            return;
        }
        this.itemsetBuffer[length] = item = transaction.get(ind).intValue();
        short PI2 = currentNode.getInnerIndexWithID(item, currentNode, PI);
        if (PI2 != -1) {
            this.insert_n_itemsets(currentNode, PI2, transaction, ind + 1, itemset, length + 1);
        } else {
            double c;
            CPTreeNode child = currentNode.getChildWithID(item, PI);
            if (child != null) {
                this.insert_n_itemsets(child, (short)0, transaction, ind + 1, itemset, length + 1);
            } else if (currentNode.counter1 / this.N >= this.minsig && (c = this.estimateCount(this.itemsetBuffer, length + 1)) / this.N >= this.minsig) {
                child = new CPTreeNode(item, currentNode, PI, c);
                currentNode.children.add(child);
                if ((currentNode.counter1 - child.counter2) / this.N < this.delta && child.counter2 / this.N > this.minmerg) {
                    this.merge(currentNode, child);
                }
            }
        }
        this.insert_n_itemsets(currentNode, PI, transaction, ind + 1, itemset, length);
    }

    void forcePruning(CPTreeNode currentNode) {
        int i = 0;
        while (i < currentNode.children.size()) {
            CPTreeNode node = currentNode.children.get(i);
            if (node.counter1 / this.N < this.minsig && currentNode.itemIDList != null) {
                currentNode.children.remove(i--);
            } else {
                this.forcePruning(node);
            }
            ++i;
        }
    }

    void patternMining(CPTreeNode currentNode, int[] pattern) throws IOException {
        if (currentNode.itemIDList != null && currentNode.itemIDList.size() > 0) {
            ArrayList<int[]> itemsetList = new ArrayList<int[]>();
            int[] concatenation = new int[pattern.length + 1];
            System.arraycopy(pattern, 0, concatenation, 0, pattern.length);
            concatenation[pattern.length] = currentNode.itemIDList.get(0);
            itemsetList.add(concatenation);
            double s = currentNode.computeSupport(this.N, 1);
            if (s >= this.minsup) {
                ++this.patternCount;
                if (this.patterns == null) {
                    this.writeItemset(concatenation, s);
                } else {
                    this.patterns.put(concatenation, s);
                }
            }
            int i = 1;
            while (i < currentNode.itemIDList.size()) {
                short PIn = currentNode.parents.get((int)i).pInd;
                int[] patternPIn = (int[])itemsetList.get(PIn);
                int[] concatenation2 = new int[patternPIn.length + 1];
                System.arraycopy(patternPIn, 0, concatenation2, 0, patternPIn.length);
                concatenation2[patternPIn.length] = currentNode.itemIDList.get(i);
                itemsetList.add(concatenation2);
                s = currentNode.computeSupport(this.N, currentNode.getLevel(i));
                if (s >= this.minsup) {
                    ++this.patternCount;
                    if (this.patterns == null) {
                        this.writeItemset(concatenation2, s);
                    } else {
                        this.patterns.put(concatenation2, s);
                    }
                }
                ++i;
            }
            for (CPTreeNode node : currentNode.children) {
                this.patternMining(node, (int[])itemsetList.get(node.parents.get((int)0).pInd));
            }
        }
    }

    Hashtable<int[], Double> patternMining_saveToMemory() throws IOException {
        this.patterns = new Hashtable();
        this.patternCount = 0;
        for (CPTreeNode node : this.root.children) {
            this.patternMining(node, new int[0]);
        }
        return this.patterns;
    }

    void patternMining_saveToFile(String outputPath) throws IOException {
        this.patterns = null;
        this.writer = new BufferedWriter(new FileWriter(outputPath));
        this.patternCount = 0;
        for (CPTreeNode node : this.root.children) {
            this.patternMining(node, new int[0]);
        }
        this.writer.close();
    }

    void writeItemset(int[] itemset, double support) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int[] nArray = itemset;
        int n = itemset.length;
        int n2 = 0;
        while (n2 < n) {
            Integer item = nArray[n2];
            buffer.append(item);
            buffer.append(" ");
            ++n2;
        }
        buffer.append("#SUP: ");
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void merge(CPTreeNode mp, CPTreeNode m) {
        int l = mp.itemIDList.size();
        mp.itemIDList.addAll(m.itemIDList);
        mp.parents.add(m.parents.get(0));
        int j = 1;
        while (j < m.parents.size()) {
            mp.parents.add(new ParentNode(mp, (short)(l + m.parents.get((int)j).pInd)));
            ++j;
        }
        for (CPTreeNode mc : m.children) {
            ParentNode p = mc.parents.get(0);
            p.pNode = mp;
            p.pInd = (short)(l + p.pInd);
            mc.parents.set(0, p);
            mp.children.add(mc);
        }
        if (mp.counter2 > m.counter2) {
            mp.counter2 = m.counter2;
        }
        mp.children.remove(m);
    }

    public void split(CPTreeNode m) {
        int longestLevel = m.getLongestLevel();
        int j = 1;
        while (j < m.itemIDList.size()) {
            if (m.isLeafLevel(j).booleanValue()) {
                CPTreeNode m2 = new CPTreeNode();
                m2.itemIDList.add(m.itemIDList.get(j));
                m2.parents.add(m.parents.get(j));
                m.itemIDList.set(j, null);
                m2.counter2 = m2.counter1 = m.estimateMergeCount(m.getLevel(j), longestLevel);
                int k = m.children.size() - 1;
                while (k >= 0) {
                    CPTreeNode mc = m.children.get(k);
                    if (mc.parents.get((int)0).pInd == j) {
                        mc.parents.set(0, new ParentNode(m2, 0));
                        m.children.remove(mc);
                        m2.children.add(mc);
                    }
                    --k;
                }
                m.children.add(m2);
            }
            ++j;
        }
        int k = m.itemIDList.size() - 1;
        while (k >= 0) {
            if (m.itemIDList.get(k) == null) {
                m.itemIDList.remove(k);
                m.parents.remove(k);
                int y = 1;
                while (y < m.parents.size()) {
                    ParentNode x = m.parents.get(y);
                    if (x.pInd > k) {
                        x.pInd = (short)(x.pInd - 1);
                        m.parents.set(y, x);
                    }
                    ++y;
                }
                for (CPTreeNode mx : m.children) {
                    ParentNode x = mx.parents.get(0);
                    if (x.pInd <= k) continue;
                    x.pInd = (short)(x.pInd - 1);
                    mx.parents.set(0, x);
                }
            }
            --k;
        }
        int newLongestLevel = m.getLongestLevel();
        m.counter2 = m.estimateMergeCount(newLongestLevel, longestLevel);
    }

    public void traverse(CPTreeNode m, CPTreeNode mp, int q, int[] transaction) {
        if (q != -1 && m.parents.get((int)0).pInd != q && m.parents.get((int)0).pNode != mp) {
            return;
        }
        if (Arrays.binarySearch(transaction, m.itemIDList.get(0)) < 0) {
            return;
        }
        m.update(this.d);
        if (m.counter1 / this.N < this.minsig) {
            mp.children.remove(m);
            return;
        }
        ArrayList<Integer> leafCommonItemInds = new ArrayList<Integer>();
        List<Integer> levelParents = new ArrayList<Integer>();
        int i = 1;
        if (m.isLeafLevel(0).booleanValue()) {
            leafCommonItemInds.add(0);
        } else {
            levelParents.add(0);
            while ((levelParents = this.FindLevelCommonItems(m, levelParents, leafCommonItemInds, transaction)).size() != 0) {
                ++i;
            }
        }
        if (i == m.getLongestLevel()) {
            m.counter2 = m.counter2 * this.d + 1.0;
        }
        if ((mp.counter1 - m.counter2) / this.N < this.delta && m.counter2 / this.N >= this.minmerg) {
            if (mp != this.root) {
                this.merge(mp, m);
            }
        } else if ((m.counter1 - m.counter2) / this.N > this.delta && m.counter2 / this.N >= this.minmerg && m.itemIDList.size() > 1) {
            this.split(m);
        }
        Iterator iterator = leafCommonItemInds.iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            int f = 0;
            while (f < m.children.size()) {
                CPTreeNode mc = m.children.get(f);
                this.traverse(mc, m, j, transaction);
                ++f;
            }
        }
    }

    List<Integer> FindLevelCommonItems(CPTreeNode m, List<Integer> levelParents, List<Integer> leafCommonItemInds, int[] transaction) {
        ArrayList<Integer> newParents = new ArrayList<Integer>();
        int k = levelParents.get(0) + 1;
        while (k < m.itemIDList.size()) {
            if (Arrays.binarySearch(transaction, m.itemIDList.get(k)) >= 0) {
                short pInd = m.parents.get((int)k).pInd;
                if (!levelParents.contains(pInd)) break;
                newParents.add(k);
                if (m.isLeafLevel(k).booleanValue()) {
                    leafCommonItemInds.add(k);
                }
            }
            ++k;
        }
        return newParents;
    }

    public String toString() {
        return this.root.toString("");
    }

    int nodeCount(CPTreeNode currentNode) {
        int s = 1;
        for (CPTreeNode child : currentNode.children) {
            s += this.nodeCount(child);
        }
        return s;
    }
}

