/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.CFINode;
import java.util.HashMap;
import java.util.Map;

public class CFITree {
    Map<Integer, CFINode> mapItemNodes = new HashMap<Integer, CFINode>();
    Map<Integer, CFINode> mapItemLastNode = new HashMap<Integer, CFINode>();
    CFINode root = new CFINode();
    CFINode lastAddedItemsetNode = null;

    private void fixNodeLinks(Integer item, CFINode newNode) {
        CFINode lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nodeLink = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        CFINode headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    public void addCFI(int[] itemset, int itemsetLength, int support) {
        CFINode currentNode = this.root;
        int i = 0;
        while (i < itemsetLength) {
            int item = itemset[i];
            CFINode child = currentNode.getChildWithID(item);
            if (child == null) {
                CFINode newNode = new CFINode();
                newNode.itemID = item;
                newNode.parent = currentNode;
                newNode.level = i + 1;
                newNode.counter = support;
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.fixNodeLinks(item, newNode);
            } else {
                child.counter = Math.max(support, child.counter);
                currentNode = child;
            }
            ++i;
        }
        this.lastAddedItemsetNode = currentNode;
    }

    public boolean passSubsetChecking(int[] headWithP, int headWithPLength, int headWithPSupport) {
        boolean isSubset;
        if (this.lastAddedItemsetNode != null && this.lastAddedItemsetNode.counter == headWithPSupport && (isSubset = this.issASubsetOfPrefixPath(headWithP, headWithPLength, this.lastAddedItemsetNode))) {
            return false;
        }
        Integer firstITem = headWithP[headWithP.length - 1];
        CFINode node = this.mapItemNodes.get(firstITem);
        if (node == null) {
            return true;
        }
        do {
            boolean isSubset2;
            boolean bl = isSubset2 = node.counter == headWithPSupport && this.issASubsetOfPrefixPath(headWithP, headWithPLength, node);
            if (!isSubset2) continue;
            return false;
        } while ((node = node.nodeLink) != null);
        return true;
    }

    private boolean issASubsetOfPrefixPath(int[] headWithP, int headWithPLength, CFINode node) {
        if (node.level >= headWithPLength) {
            CFINode nodeToCheck = node;
            int positionInItemset = headWithP.length - 1;
            int itemToLookFor = headWithP[positionInItemset];
            do {
                if (nodeToCheck.itemID != itemToLookFor) continue;
                if (--positionInItemset < 0) {
                    return true;
                }
                itemToLookFor = headWithP[positionInItemset];
            } while ((nodeToCheck = nodeToCheck.parent) != null);
        }
        return false;
    }

    public String toString() {
        return "M" + this.root.toString("");
    }

    public int calculateSupport(int[] itemset) {
        Integer firstITem = itemset[itemset.length - 1];
        CFINode node = this.mapItemNodes.get(firstITem);
        do {
            if (!this.issASubsetOfPrefixPath(itemset, itemset.length, node)) continue;
            return node.counter;
        } while ((node = node.nodeLink) != null);
        throw new Error("CFI-Tree: itemset not found. This should not happen");
    }
}

