/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hmine;

import ca.pfv.spmf.algorithms.ItemNameConverter;
import ca.pfv.spmf.algorithms.frequentpatterns.hmine.Row;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoHMine {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int patternCount = 0;
    BufferedWriter writer = null;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    boolean DEBUG = false;
    int[] cells;
    int minSupport = 0;
    private Map<Integer, Row> mapItemRow;
    ItemNameConverter nameConverter;

    public void runAlgorithm(String input, String output, double minSupport) throws IOException {
        ArrayList<Row> rowList;
        block31: {
            String thisLine;
            int transactionCount;
            int itemOccurrencesCount;
            BufferedReader myInput;
            HashMap<Object, Integer> mapItemToSupport;
            block29: {
                this.itemsetBuffer = new int[200];
                MemoryLogger.getInstance().reset();
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                mapItemToSupport = new HashMap<Object, Integer>();
                myInput = null;
                itemOccurrencesCount = 0;
                transactionCount = 0;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] items = thisLine.split(" ");
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer support = (Integer)mapItemToSupport.get(item);
                                support = support == null ? 1 : support + 1;
                                mapItemToSupport.put(item, support);
                                ++itemOccurrencesCount;
                                ++i;
                            }
                            ++transactionCount;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.minSupport = (int)Math.ceil(minSupport * (double)transactionCount);
            rowList = new ArrayList<Row>();
            this.mapItemRow = new HashMap<Integer, Row>();
            this.cells = new int[transactionCount + itemOccurrencesCount];
            for (Integer item : mapItemToSupport.keySet()) {
                int support = (Integer)mapItemToSupport.get(item);
                if (support < this.minSupport) continue;
                Row rowItem = new Row(item);
                rowItem.support = support;
                rowList.add(rowItem);
                this.mapItemRow.put(item, rowItem);
            }
            Collections.sort(rowList, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    int compare = (Integer)mapItemToSupport.get(o1.item) - (Integer)mapItemToSupport.get(o2.item);
                    return compare == 0 ? o1.item - o2.item : compare;
                }
            });
            this.nameConverter = new ItemNameConverter(rowList.size());
            for (Row row : rowList) {
                row.item = this.nameConverter.assignNewName(row.item);
            }
            this.cells[0] = -1;
            int currentCellIndex = 0;
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] items = thisLine.split(" ");
                        int transactionBegin = currentCellIndex;
                        int i = 0;
                        while (i < items.length) {
                            int item = Integer.parseInt(items[i]);
                            if ((Integer)mapItemToSupport.get(item) >= this.minSupport) {
                                this.cells[currentCellIndex++] = this.nameConverter.toNewName(item);
                            }
                            ++i;
                        }
                        int transactionEnd = currentCellIndex - 1;
                        Arrays.sort(this.cells, transactionBegin, transactionEnd + 1);
                        this.cells[currentCellIndex++] = -1;
                        int i2 = transactionBegin;
                        while (i2 <= transactionEnd) {
                            int item = this.cells[i2];
                            Row row = this.mapItemRow.get(this.nameConverter.toOldName(item));
                            row.pointers.add(i2);
                            ++i2;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        if (this.DEBUG) {
            System.out.println("------ INITIAL HStruct -----");
            System.out.println("The cell list:");
            int i = 1;
            while (i < this.cells.length) {
                int item = this.cells[i];
                if (item == -1) {
                    System.out.println("|");
                } else {
                    System.out.print(item);
                }
                ++i;
            }
            System.out.println("The table:");
            for (Row row : rowList) {
                System.out.print(row);
                System.out.print("[the items:");
                for (int pointer : row.pointers) {
                    System.out.print(String.valueOf(this.cells[pointer]) + " ");
                }
                System.out.println();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.hmine(this.itemsetBuffer, 0, rowList);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void hmine(int[] prefix, int prefixLength, List<Row> rowList) throws IOException {
        for (Row row : rowList) {
            ArrayList<Row> newRowList = new ArrayList<Row>();
            this.mapItemRow.clear();
            Iterator<Object> iterator = row.pointers.iterator();
            while (iterator.hasNext()) {
                int n;
                int transactionBegin = n = iterator.next().intValue();
                if (this.cells[++transactionBegin] == -1) continue;
                int transactionEnd = -1;
                int pos = transactionBegin;
                while (true) {
                    if (this.cells[pos] == -1) break;
                    ++pos;
                }
                transactionEnd = pos - 1;
                pos = transactionBegin;
                while (pos <= transactionEnd) {
                    int item = this.cells[pos];
                    Row rowItem = this.mapItemRow.get(item);
                    if (rowItem == null) {
                        rowItem = new Row(item);
                        this.mapItemRow.put(item, rowItem);
                    }
                    ++rowItem.support;
                    rowItem.pointers.add(pos);
                    ++pos;
                }
            }
            for (Map.Entry entry : this.mapItemRow.entrySet()) {
                Row currentRow = (Row)entry.getValue();
                if (currentRow.support < this.minSupport) continue;
                newRowList.add(currentRow);
            }
            this.writeOut(this.itemsetBuffer, prefixLength, row.item, row.support);
            if (newRowList.size() == 0) continue;
            Collections.sort(newRowList, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    return o1.item - o2.item;
                }
            });
            this.itemsetBuffer[prefixLength] = row.item;
            this.hmine(this.itemsetBuffer, prefixLength + 1, newRowList);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void writeOut(int[] prefix, int prefixLength, int item, int support) throws IOException {
        ++this.patternCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(this.nameConverter.toOldName(prefix[i]));
            buffer.append(' ');
            ++i;
        }
        buffer.append(this.nameConverter.toOldName(item));
        buffer.append(" #SUP: ");
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  HMine ALGORITHM v96r18- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Frequent itemsets count : " + this.patternCount);
        System.out.println("===================================================");
    }
}

