/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.BitSetSupport;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListFCHM;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFCHM
implements Serializable {
    private static final long serialVersionUID = 1513172536452900775L;
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Long> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, TwuSupportPair>> mapSMAP;
    boolean DEBUG = false;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    private double minBond;
    boolean ENABLE_LA_PRUNE = true;
    boolean ENABLE_SLA_PRUNE = true;
    private long candidateEliminatedByLAPrune = 0L;
    private long candidateEliminatedBySLAPrune = 0L;
    private boolean ENABLE_FHM_PRUNING = true;
    private boolean ENABLE_BOND_PAIR_PRUNING = true;
    private long candidateEliminatedByBondPruning = 0L;
    private long candidateEliminatedByFHMPruning = 0L;

    public void runAlgorithm(String input, String output, int minUtility, double minBond) throws IOException {
        ArrayList<UtilityListFCHM> listOfUtilityListFCHMs;
        block27: {
            String thisLine;
            int tid;
            BufferedReader myInput;
            block25: {
                MemoryLogger.getInstance().reset();
                this.candidateEliminatedByBondPruning = 0L;
                this.candidateEliminatedByFHMPruning = 0L;
                this.itemsetBuffer = new int[200];
                this.mapSMAP = new HashMap<Integer, Map<Integer, TwuSupportPair>>();
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Long>();
                this.minBond = minBond;
                myInput = null;
                tid = 0;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Long twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? (long)transactionUtility : twu + (long)transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            listOfUtilityListFCHMs = new ArrayList<UtilityListFCHM>();
            HashMap<Integer, UtilityListFCHM> mapItemToUtilityListFCHM = new HashMap<Integer, UtilityListFCHM>();
            for (Integer item : this.mapItemToTWU.keySet()) {
                if (this.mapItemToTWU.get(item) < (long)minUtility) continue;
                UtilityListFCHM uList = new UtilityListFCHM(item, new BitSetSupport());
                mapItemToUtilityListFCHM.put(item, uList);
                listOfUtilityListFCHMs.add(uList);
            }
            Collections.sort(listOfUtilityListFCHMs, new Comparator<UtilityListFCHM>(){

                @Override
                public int compare(UtilityListFCHM o1, UtilityListFCHM o2) {
                    return AlgoFCHM.this.compareItems(o1.item, o2.item);
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        Pair pair;
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int remainingUtility = 0;
                        long newTWU = 0L;
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (mapItemToUtilityListFCHM.get(pair.item) != null) {
                                revisedTransaction.add(pair);
                                remainingUtility += pair.utility;
                                newTWU += (long)pair.utility;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoFCHM.this.compareItems(o1.item, o2.item);
                            }
                        });
                        i = 0;
                        while (i < revisedTransaction.size()) {
                            pair = (Pair)revisedTransaction.get(i);
                            UtilityListFCHM UtilityListFCHMOfItem = (UtilityListFCHM)mapItemToUtilityListFCHM.get(pair.item);
                            UtilityListFCHMOfItem.bitsetDisjunctiveTIDs.bitset.set(tid);
                            ++UtilityListFCHMOfItem.bitsetDisjunctiveTIDs.support;
                            Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                            UtilityListFCHMOfItem.addElement(element);
                            Map<Integer, TwuSupportPair> mapFMAPItem = this.mapSMAP.get(pair.item);
                            if (mapFMAPItem == null) {
                                mapFMAPItem = new HashMap<Integer, TwuSupportPair>();
                                this.mapSMAP.put(pair.item, mapFMAPItem);
                            }
                            int j = i + 1;
                            while (j < revisedTransaction.size()) {
                                Pair pairAfter = (Pair)revisedTransaction.get(j);
                                TwuSupportPair twuSupportPair = mapFMAPItem.get(pairAfter.item);
                                if (twuSupportPair == null) {
                                    twuSupportPair = new TwuSupportPair();
                                    mapFMAPItem.put(pairAfter.item, twuSupportPair);
                                }
                                twuSupportPair.twu += newTWU;
                                ++twuSupportPair.support;
                                ++j;
                            }
                            ++i;
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.fchm(this.itemsetBuffer, 0, null, listOfUtilityListFCHMs, minUtility);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = (int)(this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2));
        return compare == 0 ? item1 - item2 : compare;
    }

    /*
     * Unable to fully structure code
     */
    private void fchm(int[] prefix, int prefixLength, UtilityListFCHM pUL, List<UtilityListFCHM> ULs, int minUtility) throws IOException {
        i = 0;
        while (i < ULs.size()) {
            block6: {
                X = ULs.get(i);
                if (X.sumIutils >= (long)minUtility) {
                    this.writeOut(prefix, prefixLength, X.item, X.sumIutils, X.getBond());
                }
                if (X.sumIutils + X.sumRutils < (long)minUtility) break block6;
                exULs = new ArrayList<UtilityListFCHM>();
                j = i + 1;
                while (j < ULs.size()) {
                    block8: {
                        block7: {
                            Y = ULs.get(j);
                            mapTWUF = this.mapSMAP.get(X.item);
                            if (mapTWUF == null || (twuF = mapTWUF.get(Y.item)) == null) ** GOTO lbl-1000
                            if (!this.ENABLE_FHM_PRUNING || twuF.twu >= (long)minUtility) break block7;
                            ++this.candidateEliminatedByFHMPruning;
                            break block8;
                        }
                        if (!this.ENABLE_BOND_PAIR_PRUNING) ** GOTO lbl-1000
                        conditionY = (double)twuF.support / (double)Y.bitsetDisjunctiveTIDs.support < this.minBond;
                        v0 = conditionX = (double)twuF.support / (double)X.bitsetDisjunctiveTIDs.support < this.minBond;
                        if (conditionX || conditionY) {
                            ++this.candidateEliminatedByBondPruning;
                        } else lbl-1000:
                        // 3 sources

                        {
                            ++this.candidateCount;
                            temp = this.construct(pUL, X, Y, minUtility);
                            if (temp != null && temp.getBond() >= this.minBond) {
                                exULs.add(temp);
                            }
                        }
                    }
                    ++j;
                }
                this.itemsetBuffer[prefixLength] = X.item;
                this.fchm(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility);
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityListFCHM construct(UtilityListFCHM P, UtilityListFCHM px, UtilityListFCHM py, int minUtility) {
        BitSetSupport bitsetPX = px.bitsetDisjunctiveTIDs;
        BitSetSupport bitsetPY = py.bitsetDisjunctiveTIDs;
        BitSetSupport bitsetPXY = this.performOR(bitsetPX, bitsetPY);
        double maxdisjunctivesupport = bitsetPXY.support;
        double pxsupport = px.elements.size();
        int minSup = (int)Math.ceil(maxdisjunctivesupport * this.minBond);
        UtilityListFCHM pxyUL = new UtilityListFCHM(py.item, bitsetPXY);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (this.ENABLE_LA_PRUNE && (totalUtility -= (long)(ex.iutils + ex.rutils)) < (long)minUtility) {
                    ++this.candidateEliminatedByLAPrune;
                    return null;
                }
                if (!this.ENABLE_SLA_PRUNE || !((pxsupport -= 1.0) < (double)minSup)) continue;
                ++this.candidateEliminatedBySLAPrune;
                return null;
            }
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityListFCHM ulist, int tid) {
        List list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (((Element)list.get((int)middle)).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (((Element)list.get((int)middle)).tid > tid) {
                last = middle - 1;
                continue;
            }
            return (Element)list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long utility, double bond) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        buffer.append(" #BOND: ");
        buffer.append(bond);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    BitSetSupport performOR(BitSetSupport tidsetI, BitSetSupport tidsetJ) {
        BitSetSupport bitsetSupportIJ = new BitSetSupport();
        bitsetSupportIJ.bitset = (BitSet)tidsetI.bitset.clone();
        bitsetSupportIJ.bitset.or(tidsetJ.bitset);
        bitsetSupportIJ.support = bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    public void printStats() throws IOException {
        System.out.println("=============  FCHM ALGORITHM v0.96r18 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Correlated High-utility itemset count : " + this.huiCount);
        System.out.println("   Candidate count : " + this.candidateCount);
        System.out.println("   Candidate eliminated by bond pruning: " + this.candidateEliminatedByBondPruning);
        System.out.println("   Candidate eliminated by FHM pruning: " + this.candidateEliminatedByFHMPruning);
        System.out.println("   List constructions stopped by SLAPrune: " + this.candidateEliminatedBySLAPrune);
        System.out.println("   List constructions stopped by LAPrune: " + this.candidateEliminatedByLAPrune);
        if (this.DEBUG) {
            for (Map.Entry<Integer, Map<Integer, TwuSupportPair>> entry : this.mapSMAP.entrySet()) {
                System.out.println("Item: " + entry.getKey());
                for (Map.Entry<Integer, TwuSupportPair> entry2 : entry.getValue().entrySet()) {
                    System.out.println(" (Item: " + entry2.getKey() + " twu: " + entry2.getValue().twu + " sup: " + entry2.getValue().support);
                }
            }
        }
        if (this.DEBUG) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapSMAP);
            for (Map.Entry<Integer, Map<Integer, TwuSupportPair>> entry : this.mapSMAP.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, TwuSupportPair> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("CMAP size " + maxMemory + " MB");
            System.out.println("PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    public long getTotalTime() {
        return this.endTimestamp - this.startTimestamp;
    }

    public int getPatternCount() {
        return this.huiCount;
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }

    class TwuSupportPair
    implements Serializable {
        private static final long serialVersionUID = -131200309501702633L;
        int support = 0;
        long twu = 0L;

        TwuSupportPair() {
        }
    }
}

