/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.PairItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityList;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListWithCriticalObjects;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoGHUIMINER {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public long ghuiCount = 0L;
    public long candidateCount = 0L;
    public long candidateAvoidedbyFHM = 0L;
    public long closureRetrievals = 0L;
    public long generatorChecks = 0L;
    public long partiallyAvoidedOrAvoidedGeneratorChecks = 0L;
    Map<Integer, Integer> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Integer>> mapFMAP;
    private int transactionCount = 0;
    boolean debug = false;
    private Map<Integer, UtilityListWithCriticalObjects> mapItemToUtilityList;
    private List<UtilityListWithCriticalObjects> listOfUtilityLists;
    boolean emptySetIsGHUIs = false;
    int minUtility = 0;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    boolean enableLAPrune = true;
    List<List<Itemset>> closedItemsetsBySize = null;

    public Itemset getClosure(int[] itemsetX, int prefixLength, int support) {
        ++this.closureRetrievals;
        int i = prefixLength;
        while (i < this.closedItemsetsBySize.size()) {
            List<Itemset> list = this.closedItemsetsBySize.get(i);
            if (list != null) {
                for (Itemset itemsetInList : list) {
                    if (support < itemsetInList.support) break;
                    if (support != itemsetInList.support || !ArraysAlgos.includedIn(itemsetX, prefixLength, itemsetInList.itemset)) continue;
                    return itemsetInList;
                }
            }
            ++i;
        }
        return null;
    }

    public boolean isSubsetOfACHUI(int[] itemsetX, int prefixLength, int support, boolean strictSubsetCheck) {
        int minSize = strictSubsetCheck ? prefixLength + 1 : prefixLength;
        int i = this.closedItemsetsBySize.size() - 1;
        while (i >= minSize) {
            List<Itemset> list = this.closedItemsetsBySize.get(i);
            if (list != null) {
                for (Itemset itemsetInList : list) {
                    if (support < itemsetInList.support) break;
                    if (!ArraysAlgos.includedIn(itemsetX, prefixLength, itemsetInList.itemset)) continue;
                    return true;
                }
            }
            --i;
        }
        return false;
    }

    private void sortClosedItemsets() {
        for (List<Itemset> itemsetsBySize : this.closedItemsetsBySize) {
            Collections.sort(itemsetsBySize, new Comparator<Itemset>(){

                @Override
                public int compare(Itemset o1, Itemset o2) {
                    return o1.support - o2.support;
                }
            });
        }
    }

    private void sortItemsInAllCHUIsByTWU() {
        for (List<Itemset> itemsetsBySize : this.closedItemsetsBySize) {
            for (Itemset itemset : itemsetsBySize) {
                if (itemset.support == this.transactionCount) {
                    this.emptySetIsGHUIs = true;
                }
                this.insertionSort(itemset.itemset);
            }
        }
    }

    public void insertionSort(int[] a) {
        int j = 1;
        while (j < a.length) {
            int key = a[j];
            int i = j - 1;
            while (i >= 0 && this.compareItems(a[i], key) > 0) {
                a[i + 1] = a[i];
                --i;
            }
            a[i + 1] = key;
            ++j;
        }
    }

    public void runAlgorithm(String input, String output, int minUtility, List<List<Itemset>> closedItemsets, Set<Integer> itemsInClosedItemsets) throws IOException {
        long totalUtility;
        block35: {
            String thisLine;
            BufferedReader myInput;
            block33: {
                this.closureRetrievals = 0L;
                this.itemsetBuffer = new int[200];
                this.mapFMAP = new HashMap<Integer, Map<Integer, Integer>>();
                this.minUtility = minUtility;
                this.startTimestamp = System.currentTimeMillis();
                MemoryLogger.getInstance().reset();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                totalUtility = 0L;
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                if (itemsInClosedItemsets.contains(item)) {
                                    Integer twu = this.mapItemToTWU.get(item);
                                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                                    this.mapItemToTWU.put(item, twu);
                                }
                                ++i;
                            }
                            ++this.transactionCount;
                            totalUtility += (long)transactionUtility;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.listOfUtilityLists = new ArrayList<UtilityListWithCriticalObjects>();
            this.mapItemToUtilityList = new HashMap<Integer, UtilityListWithCriticalObjects>();
            for (Integer item : this.mapItemToTWU.keySet()) {
                if (this.mapItemToTWU.get(item) < minUtility) continue;
                UtilityListWithCriticalObjects uList = new UtilityListWithCriticalObjects(item);
                this.mapItemToUtilityList.put(item, uList);
                this.listOfUtilityLists.add(uList);
            }
            Collections.sort(this.listOfUtilityLists, new Comparator<UtilityListWithCriticalObjects>(){

                @Override
                public int compare(UtilityListWithCriticalObjects o1, UtilityListWithCriticalObjects o2) {
                    return AlgoGHUIMINER.this.compareItems(o1.item, o2.item);
                }
            });
            this.closedItemsetsBySize = closedItemsets;
            this.sortClosedItemsets();
            this.sortItemsInAllCHUIsByTWU();
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        PairItemUtility pair;
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int transactionUtility = Integer.parseInt(split[1]);
                        int newTU = 0;
                        ArrayList<PairItemUtility> revisedTransaction = new ArrayList<PairItemUtility>();
                        int i = 0;
                        while (i < items.length) {
                            pair = new PairItemUtility();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            Integer utility = this.mapItemToTWU.get(pair.item);
                            if (utility != null && this.mapItemToTWU.get(pair.item) >= minUtility) {
                                revisedTransaction.add(pair);
                                newTU += pair.utility;
                            } else {
                                transactionUtility -= pair.utility;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<PairItemUtility>(){

                            @Override
                            public int compare(PairItemUtility o1, PairItemUtility o2) {
                                return AlgoGHUIMINER.this.compareItems(o1.item, o2.item);
                            }
                        });
                        i = 0;
                        while (i < revisedTransaction.size()) {
                            pair = (PairItemUtility)revisedTransaction.get(i);
                            int remainingUtility = transactionUtility - pair.utility;
                            UtilityListWithCriticalObjects utilityListOfItem = this.mapItemToUtilityList.get(pair.item);
                            Element element = new Element(tid, pair.utility, remainingUtility);
                            utilityListOfItem.addElement(element);
                            Map<Integer, Integer> mapFMAPItem = this.mapFMAP.get(pair.item);
                            if (mapFMAPItem == null) {
                                mapFMAPItem = new HashMap<Integer, Integer>();
                                this.mapFMAP.put(pair.item, mapFMAPItem);
                            }
                            int j = i + 1;
                            while (j < revisedTransaction.size()) {
                                PairItemUtility pairAfter = (PairItemUtility)revisedTransaction.get(j);
                                Integer twuSum = mapFMAPItem.get(pairAfter.item);
                                if (twuSum == null) {
                                    mapFMAPItem.put(pairAfter.item, newTU);
                                } else {
                                    mapFMAPItem.put(pairAfter.item, twuSum + newTU);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block35;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        BitSet tidsetEmptySet = new BitSet(this.transactionCount);
        tidsetEmptySet.set(1, this.transactionCount);
        UtilityListWithCriticalObjects emptyUL = new UtilityListWithCriticalObjects(null);
        emptyUL.tidset = tidsetEmptySet;
        emptyUL.crit = new BitSet[0];
        int[] emptySet = new int[]{};
        Iterator<UtilityListWithCriticalObjects> iter = this.listOfUtilityLists.iterator();
        while (iter.hasNext()) {
            UtilityListWithCriticalObjects ul = iter.next();
            int[] itemset = new int[]{ul.item};
            int support = ul.elements.size();
            this.checkIfGeneratorSingleItem(emptyUL, ul);
            if (ul.crit == null || ul.sumIutils + ul.sumRutils < (long)minUtility) {
                iter.remove();
                continue;
            }
            if (ul.sumIutils >= (long)minUtility) {
                this.writeOut(emptySet, 0, ul.item, ul.sumIutils, ul.elements.size());
                if (this.isSubsetOfACHUI(itemset, 1, support, true)) continue;
                iter.remove();
                continue;
            }
            if (this.getClosure(itemset, 1, support) == null) continue;
            this.writeOut(emptySet, 0, ul.item, ul.sumIutils, ul.elements.size());
        }
        if (this.closedItemsetsBySize.size() > 0) {
            if (this.emptySetIsGHUIs) {
                this.writeOutEmptySet(totalUtility);
            }
            this.ghuiMinerE(this.itemsetBuffer, 0, emptyUL, this.listOfUtilityLists);
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void ghuiMinerE(int[] prefixP, int prefixLength, UtilityListWithCriticalObjects p_UL, List<UtilityListWithCriticalObjects> extensionsULs) throws IOException {
        MemoryLogger.getInstance().checkMemory();
        int i = 0;
        while (i < extensionsULs.size()) {
            UtilityListWithCriticalObjects pX_UL = extensionsULs.get(i);
            if (pX_UL.sumIutils + pX_UL.sumRutils >= (long)this.minUtility) {
                this.itemsetBuffer[prefixLength] = pX_UL.item;
                ArrayList<UtilityListWithCriticalObjects> extensionsOfPX = new ArrayList<UtilityListWithCriticalObjects>();
                int j = i + 1;
                while (j < extensionsULs.size()) {
                    UtilityListWithCriticalObjects pY_UL = extensionsULs.get(j);
                    boolean shouldPrune = this.checkEUCPStrategy(this.minUtility, pX_UL.item, pY_UL.item);
                    if (!shouldPrune) {
                        UtilityListWithCriticalObjects pXYUL;
                        ++this.candidateCount;
                        UtilityListWithCriticalObjects utilityListWithCriticalObjects = pXYUL = p_UL.item == null ? this.construct(pX_UL, pY_UL, this.minUtility) : this.construct(pX_UL, pY_UL, this.minUtility);
                        if (pXYUL != null && !pXYUL.elements.isEmpty()) {
                            if (pXYUL.elements.size() == pX_UL.elements.size() || pXYUL.elements.size() == pY_UL.elements.size()) {
                                ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
                            } else {
                                boolean isGenerator;
                                this.itemsetBuffer[prefixLength + 1] = pY_UL.item;
                                if (this.isSubsetOfACHUI(this.itemsetBuffer, prefixLength + 2, pXYUL.elements.size(), false) && pXYUL.sumIutils + pXYUL.sumRutils >= (long)this.minUtility && (isGenerator = this.checkIfGenerator(pX_UL, pXYUL, prefixLength + 1))) {
                                    if (pXYUL.sumIutils >= (long)this.minUtility) {
                                        this.writeOut(this.itemsetBuffer, prefixLength + 1, pXYUL.item, pXYUL.sumIutils, pXYUL.elements.size());
                                    } else if (this.getClosure(this.itemsetBuffer, prefixLength + 2, pXYUL.elements.size()) != null) {
                                        this.writeOut(this.itemsetBuffer, prefixLength + 1, pXYUL.item, pXYUL.sumIutils, pXYUL.elements.size());
                                    }
                                    extensionsOfPX.add(pXYUL);
                                }
                            }
                        }
                    }
                    ++j;
                }
                if (extensionsOfPX.size() > 1) {
                    this.ghuiMinerE(this.itemsetBuffer, prefixLength + 1, pX_UL, extensionsOfPX);
                }
            }
            ++i;
        }
    }

    private boolean checkEUCPStrategy(int minUtility, int itemX, int itemY) {
        Integer twuF;
        Map<Integer, Integer> mapTWUF = this.mapFMAP.get(itemX);
        if (mapTWUF != null && ((twuF = mapTWUF.get(itemY)) == null || twuF < minUtility)) {
            ++this.candidateAvoidedbyFHM;
            return true;
        }
        return false;
    }

    public boolean contains(int[] list, int integer) {
        int[] nArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            int item = nArray[n2];
            if (item == integer) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean checkIfGenerator(UtilityListWithCriticalObjects p_UL, UtilityListWithCriticalObjects pX_UL, int prefixSize) {
        ++this.generatorChecks;
        BitSet tidsetE = this.mapItemToUtilityList.get((Object)pX_UL.item).tidset;
        pX_UL.crit = new BitSet[prefixSize + 1];
        BitSet critE = (BitSet)p_UL.tidset.clone();
        critE.andNot(tidsetE);
        pX_UL.crit[pX_UL.crit.length - 1] = critE;
        if (critE.cardinality() == 0) {
            ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
            return false;
        }
        int j = 0;
        while (j < prefixSize) {
            pX_UL.crit[j] = (BitSet)p_UL.crit[j].clone();
            pX_UL.crit[j].and(tidsetE);
            int cardinality = pX_UL.crit[j].cardinality();
            if (cardinality == 0) {
                if (j < prefixSize - 1) {
                    ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
                }
                return false;
            }
            ++j;
        }
        return true;
    }

    private void checkIfGeneratorSingleItem(UtilityListWithCriticalObjects emptySet_UL, UtilityListWithCriticalObjects X_UL) {
        if (this.transactionCount == X_UL.elements.size()) {
            ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
            return;
        }
        ++this.generatorChecks;
        BitSet tidsetE = this.mapItemToUtilityList.get((Object)X_UL.item).tidset;
        BitSet crit = (BitSet)emptySet_UL.tidset.clone();
        crit.andNot(tidsetE);
        X_UL.crit = new BitSet[]{crit};
    }

    private UtilityListWithCriticalObjects construct(UtilityListWithCriticalObjects px, UtilityListWithCriticalObjects py, int minUtility) {
        UtilityListWithCriticalObjects pxyUL = new UtilityListWithCriticalObjects(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey != null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ex.rutils - ey.iutils);
                pxyUL.addElement(eXY);
                continue;
            }
            if (!this.enableLAPrune || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
            return null;
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOutEmptySet(long totalUtility) throws IOException {
        ++this.ghuiCount;
        this.writer.write("#SUP: " + this.transactionCount + " #UTIL: " + totalUtility);
        this.writer.newLine();
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long sumIutils, int support) throws IOException {
        ++this.ghuiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(item);
        buffer.append(" #SUP: ");
        buffer.append(support);
        buffer.append(" #UTIL: ");
        buffer.append(sumIutils);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  GHUI-MINER - SPMF 0.97e - STATS =============");
        System.out.println("   Candidate count : " + this.candidateCount + "     (avoided by FHM : " + this.candidateAvoidedbyFHM + ")\n" + "   Closure retrievals : " + this.closureRetrievals + " \n" + "   Genenerator checks: " + this.generatorChecks + "   (partially avoided : " + this.partiallyAvoidedOrAvoidedGeneratorChecks + ")");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" GHUI count : " + this.ghuiCount);
        System.out.println("===================================================");
    }
}

