/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoMinFHM {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Integer>> mapFMAP;
    boolean debug = false;
    boolean ENABLE_LA_PRUNE = true;
    List<List<Itemset>> listItemsetsBySize = null;

    public boolean isSubsumingAFoundItemset(int[] itemset) {
        if (itemset.length == 2) {
            return false;
        }
        int i = 0;
        while (i < itemset.length && i < this.listItemsetsBySize.size()) {
            List<Itemset> list = this.listItemsetsBySize.get(i);
            if (list.size() > 0) {
                for (Itemset itemsetInList : list) {
                    if (!ArraysAlgos.includedIn(itemsetInList.itemset, itemset)) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void registerItemsetAndRemoveLarger(int[] itemset, long utility, int support) {
        if (itemset.length == 2) {
            this.mapFMAP.get(itemset[0]).put(itemset[1], 0);
        }
        if (itemset.length >= this.listItemsetsBySize.size()) {
            int i = this.listItemsetsBySize.size();
            while (i <= itemset.length) {
                this.listItemsetsBySize.add(new ArrayList());
                ++i;
            }
        }
        List<Itemset> listToAdd = this.listItemsetsBySize.get(itemset.length);
        listToAdd.add(new Itemset(itemset, utility, support));
        int i = itemset.length + 1;
        while (i < this.listItemsetsBySize.size()) {
            List<Itemset> list = this.listItemsetsBySize.get(i);
            if (list.size() > 0) {
                Iterator<Itemset> iter = list.iterator();
                while (iter.hasNext()) {
                    Itemset itemset2 = iter.next();
                    if (!ArraysAlgos.includedIn(itemset, itemset2.itemset)) continue;
                    iter.remove();
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        ArrayList<UtilityList> listOfUtilityLists;
        HashMap<Integer, Integer> mapItemToUtility;
        block31: {
            String thisLine;
            BufferedReader myInput;
            block29: {
                MemoryLogger.getInstance().reset();
                this.mapFMAP = new HashMap<Integer, Map<Integer, Integer>>();
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                mapItemToUtility = new HashMap<Integer, Integer>();
                this.listItemsetsBySize = new ArrayList<List<Itemset>>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int n = Integer.parseInt(split[1]);
                            String[] utilityValues = split[2].split(" ");
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? n : twu + n;
                                this.mapItemToTWU.put(item, twu);
                                Integer utility = Integer.parseInt(utilityValues[i]);
                                Integer totalUtilityOfItem = (Integer)mapItemToUtility.get(item);
                                totalUtilityOfItem = totalUtilityOfItem == null ? utility : utility + totalUtilityOfItem;
                                mapItemToUtility.put(item, totalUtilityOfItem);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            listOfUtilityLists = new ArrayList<UtilityList>();
            HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
            for (Integer n : this.mapItemToTWU.keySet()) {
                if (this.mapItemToTWU.get(n) < minUtility || (Integer)mapItemToUtility.get(n) >= minUtility) continue;
                UtilityList uList = new UtilityList(n);
                mapItemToUtilityList.put(n, uList);
                listOfUtilityLists.add(uList);
            }
            Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

                @Override
                public int compare(UtilityList o1, UtilityList o2) {
                    return AlgoMinFHM.this.compareItems(o1.item, o2.item);
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    boolean bl = false;
                    while ((thisLine = myInput.readLine()) != null) {
                        void var9_13;
                        Pair pair;
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int remainingUtility = 0;
                        int newTWU = 0;
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= minUtility && (Integer)mapItemToUtility.get(pair.item) < minUtility) {
                                revisedTransaction.add(pair);
                                remainingUtility += pair.utility;
                                newTWU += pair.utility;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoMinFHM.this.compareItems(o1.item, o2.item);
                            }
                        });
                        i = 0;
                        while (i < revisedTransaction.size()) {
                            pair = (Pair)revisedTransaction.get(i);
                            UtilityList utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                            Element element = new Element((int)var9_13, pair.utility, remainingUtility -= pair.utility);
                            utilityListOfItem.addElement(element);
                            Map<Integer, Integer> mapFMAPItem = this.mapFMAP.get(pair.item);
                            if (mapFMAPItem == null) {
                                mapFMAPItem = new HashMap<Integer, Integer>();
                                this.mapFMAP.put(pair.item, mapFMAPItem);
                            }
                            int j = i + 1;
                            while (j < revisedTransaction.size()) {
                                Pair pairAfter = (Pair)revisedTransaction.get(j);
                                Integer twuSum = mapFMAPItem.get(pairAfter.item);
                                if (twuSum == null) {
                                    mapFMAPItem.put(pairAfter.item, newTWU);
                                } else {
                                    mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        ++var9_13;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        for (Map.Entry entry : mapItemToUtility.entrySet()) {
            if ((Integer)entry.getValue() < minUtility) continue;
            this.writeOutItemsetSize1((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        this.minfhm(new int[0], null, listOfUtilityLists, minUtility);
        for (List list : this.listItemsetsBySize) {
            for (Itemset itemset : list) {
                this.writeOut(itemset);
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void minfhm(int[] prefix, UtilityList pUL, List<UtilityList> ULs, int minUtility) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            UtilityList X = ULs.get(i);
            if (X.sumIutils + X.sumRutils >= (long)minUtility) {
                int[] newPrefix = ArraysAlgos.appendIntegerToArray(prefix, X.item);
                ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
                int j = i + 1;
                while (j < ULs.size()) {
                    Integer twuF;
                    UtilityList Y = ULs.get(j);
                    Map<Integer, Integer> mapTWUF = this.mapFMAP.get(X.item);
                    if (mapTWUF == null || (twuF = mapTWUF.get(Y.item)) != null && twuF >= minUtility) {
                        ++this.candidateCount;
                        UtilityList pXY = this.construct(pUL, X, Y, minUtility);
                        if (pXY != null) {
                            int[] itemset = ArraysAlgos.appendIntegerToArray(newPrefix, Y.item);
                            if (pXY.sumIutils >= (long)minUtility && !this.isSubsumingAFoundItemset(itemset)) {
                                this.registerItemsetAndRemoveLarger(itemset, pXY.sumIutils, pXY.elements.size());
                            } else if (this.isSubsumingAFoundItemset(itemset)) {
                                exULs.add(pXY);
                            }
                        }
                    }
                    ++j;
                }
                if (exULs.size() > 1) {
                    this.minfhm(newPrefix, X, exULs, minUtility);
                }
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py, int minUtility) {
        UtilityList pxyUL = new UtilityList(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.ENABLE_LA_PRUNE || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
                return null;
            }
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(Itemset itemset) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < itemset.itemset.length) {
            buffer.append(itemset.itemset[i]);
            if (i != itemset.itemset.length - 1) {
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(" #UTIL: ");
        buffer.append(itemset.utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void writeOutItemsetSize1(int item, int utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  MinFHM ALGORITHM - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" MinHUIs count : " + this.huiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        if (this.debug) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapFMAP);
            for (Map.Entry<Integer, Map<Integer, Integer>> entry : this.mapFMAP.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Integer> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("CMAP size " + maxMemory + " MB");
            System.out.println("PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

