/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.pfpm;

import ca.pfv.spmf.algorithms.frequentpatterns.pfpm.MemoryLogger;
import ca.pfv.spmf.algorithms.frequentpatterns.pfpm.TIDList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoPFPM {
    private static final boolean ENABLE_LA_PRUNE = false;
    public int phuiCount = 0;
    public int candidateCount = 0;
    static Map<Integer, ItemInfo> mapItemToItemInfo;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Long>> mapESCS = null;
    boolean ENABLE_ESCP = true;
    boolean DEBUG = false;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    final int TRANSACTION_BUFFERS_SIZE = 1000;
    private int[] transactionBuffer = null;
    protected int databaseSize = 0;
    int minPeriodicity;
    int maxPeriodicity;
    int minAveragePeriodicity;
    int maxAveragePeriodicity;
    protected double supportPruningThreshold = 0.0;
    public double totalExecutionTime = 0.0;
    public double maximumMemoryUsage = 0.0;

    public void runAlgorithm(String input, String output, int minPeriodicity, int maxPeriodicity, int minAveragePeriodicity, int maxAveragePeriodicity) throws IOException {
        HashMap<Integer, TIDList> mapItemToUtilityList;
        ArrayList<TIDList> listOfUtilityLists;
        long startTimestamp;
        block37: {
            long sumOfTransactionLength;
            String thisLine;
            BufferedReader myInput;
            block35: {
                MemoryLogger.getInstance().reset();
                startTimestamp = 0L;
                this.maxPeriodicity = maxPeriodicity;
                this.minPeriodicity = minPeriodicity;
                this.minAveragePeriodicity = minAveragePeriodicity;
                this.maxAveragePeriodicity = maxAveragePeriodicity;
                this.itemsetBuffer = new int[200];
                if (this.ENABLE_ESCP) {
                    this.mapESCS = new HashMap<Integer, Map<Integer, Long>>();
                }
                startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                mapItemToItemInfo = new HashMap<Integer, ItemInfo>();
                myInput = null;
                this.databaseSize = 0;
                thisLine = null;
                sumOfTransactionLength = 0L;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            ++this.databaseSize;
                            String[] items = thisLine.split(" ");
                            sumOfTransactionLength += (long)items.length;
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                ItemInfo itemInfo = mapItemToItemInfo.get(item);
                                if (itemInfo == null) {
                                    itemInfo = new ItemInfo();
                                    mapItemToItemInfo.put(item, itemInfo);
                                }
                                ++itemInfo.support;
                                int periodicity = this.databaseSize - itemInfo.lastSeenTransaction;
                                if (itemInfo.largestPeriodicity < periodicity) {
                                    itemInfo.largestPeriodicity = periodicity;
                                }
                                itemInfo.lastSeenTransaction = this.databaseSize;
                                if (itemInfo.support != 1 && periodicity < itemInfo.smallestPeriodicity) {
                                    itemInfo.smallestPeriodicity = periodicity;
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.supportPruningThreshold = (double)this.databaseSize / (double)maxAveragePeriodicity - 1.0;
            for (Map.Entry<Integer, ItemInfo> entry : mapItemToItemInfo.entrySet()) {
                ItemInfo itemInfo = entry.getValue();
                int periodicity = this.databaseSize - itemInfo.lastSeenTransaction;
                if (itemInfo.largestPeriodicity < periodicity) {
                    itemInfo.largestPeriodicity = periodicity;
                }
                if (!this.DEBUG) continue;
                System.out.println(" item : " + entry.getKey() + "\tavgPer: " + (double)this.databaseSize / (double)(itemInfo.support + 1) + "\tminPer: " + itemInfo.smallestPeriodicity + "\tmaxPer: " + itemInfo.largestPeriodicity + "\tsup.: " + itemInfo.support);
            }
            if (this.DEBUG) {
                System.out.println("Number of transactions : " + this.databaseSize);
                System.out.println("Average transaction length : " + (double)sumOfTransactionLength / (double)this.databaseSize);
                System.out.println("Number of items : " + mapItemToItemInfo.size());
                System.out.println("Average pruning threshold  (|D| / maxAvg $) - 1): " + this.supportPruningThreshold);
            }
            listOfUtilityLists = new ArrayList<TIDList>();
            mapItemToUtilityList = new HashMap<Integer, TIDList>();
            for (Map.Entry<Integer, ItemInfo> entry : mapItemToItemInfo.entrySet()) {
                ItemInfo itemInfo = entry.getValue();
                if (!((double)itemInfo.support >= this.supportPruningThreshold) || itemInfo.largestPeriodicity > maxPeriodicity) continue;
                int item = entry.getKey();
                TIDList uList = new TIDList(item);
                mapItemToUtilityList.put(item, uList);
                listOfUtilityLists.add(uList);
                uList.largestPeriodicity = itemInfo.largestPeriodicity;
                uList.smallestPeriodicity = itemInfo.smallestPeriodicity;
            }
            Collections.sort(listOfUtilityLists, new Comparator<TIDList>(){

                @Override
                public int compare(TIDList o1, TIDList o2) {
                    return AlgoPFPM.compareItems(o1.item, o2.item);
                }
            });
            try {
                try {
                    this.transactionBuffer = new int[1000];
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        int item;
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] items = thisLine.split(" ");
                        int sizeNewTransaction = 0;
                        int i = 0;
                        while (i < items.length) {
                            item = Integer.parseInt(items[i]);
                            ItemInfo itemInfo = mapItemToItemInfo.get(item);
                            if ((double)itemInfo.support >= this.supportPruningThreshold && itemInfo.largestPeriodicity <= maxPeriodicity) {
                                this.transactionBuffer[sizeNewTransaction++] = Integer.parseInt(items[i]);
                            }
                            ++i;
                        }
                        if (this.ENABLE_ESCP) {
                            AlgoPFPM.insertionSort(this.transactionBuffer, sizeNewTransaction);
                        }
                        i = 0;
                        while (i < sizeNewTransaction) {
                            item = this.transactionBuffer[i];
                            TIDList utilityListOfItem = (TIDList)mapItemToUtilityList.get(item);
                            utilityListOfItem.addElement(tid);
                            if (this.ENABLE_ESCP) {
                                Map<Integer, Long> mapESItem = this.mapESCS.get(item);
                                if (mapESItem == null) {
                                    mapESItem = new HashMap<Integer, Long>();
                                    this.mapESCS.put(item, mapESItem);
                                }
                                int j = i + 1;
                                while (j < sizeNewTransaction) {
                                    int item2 = this.transactionBuffer[j];
                                    Long support = mapESItem.get(item2);
                                    if (support == null) {
                                        mapESItem.put(item2, 1L);
                                    } else {
                                        mapESItem.put(item2, support + 1L);
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        ++tid;
                    }
                    this.transactionBuffer = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    this.transactionBuffer = null;
                    break block37;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                this.transactionBuffer = null;
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
            this.transactionBuffer = null;
        }
        mapItemToItemInfo = null;
        mapItemToUtilityList = null;
        MemoryLogger.getInstance().checkMemory();
        this.fpp(this.itemsetBuffer, 0, null, listOfUtilityLists);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.totalExecutionTime = System.currentTimeMillis() - startTimestamp;
        this.maximumMemoryUsage = MemoryLogger.getInstance().getMaxMemory();
    }

    public static void insertionSort(int[] a, int sizeNewTransaction) {
        int j = 1;
        while (j < sizeNewTransaction) {
            int key = a[j];
            int i = j - 1;
            while (i >= 0 && AlgoPFPM.compareItems(a[i], key) > 0) {
                a[i + 1] = a[i];
                --i;
            }
            a[i + 1] = key;
            ++j;
        }
    }

    private static int compareItems(int item1, int item2) {
        int compare = AlgoPFPM.mapItemToItemInfo.get((Object)Integer.valueOf((int)item1)).support - AlgoPFPM.mapItemToItemInfo.get((Object)Integer.valueOf((int)item2)).support;
        return compare == 0 ? item1 - item2 : compare;
    }

    private void fpp(int[] prefix, int prefixLength, TIDList pUL, List<TIDList> ULs) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            TIDList X = ULs.get(i);
            double averagePeriodicity = (double)this.databaseSize / ((double)X.getSupport() + 1.0);
            if (averagePeriodicity <= (double)this.maxAveragePeriodicity && averagePeriodicity >= (double)this.minAveragePeriodicity && X.smallestPeriodicity >= this.minPeriodicity && X.largestPeriodicity <= this.maxPeriodicity) {
                this.writeOut(prefix, prefixLength, X, averagePeriodicity);
            }
            ArrayList<TIDList> exULs = new ArrayList<TIDList>();
            int j = i + 1;
            while (j < ULs.size()) {
                Long supportF;
                Map<Integer, Long> mapSUPF;
                TIDList Y = ULs.get(j);
                if (!this.ENABLE_ESCP || (mapSUPF = this.mapESCS.get(X.item)) == null || (supportF = mapSUPF.get(Y.item)) != null && !((double)supportF.longValue() < this.supportPruningThreshold)) {
                    ++this.candidateCount;
                    TIDList temp = this.construct(prefixLength == 0, X, Y);
                    if (temp != null) {
                        exULs.add(temp);
                    }
                }
                ++j;
            }
            this.itemsetBuffer[prefixLength] = X.item;
            this.fpp(this.itemsetBuffer, prefixLength + 1, X, exULs);
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private TIDList construct(boolean firstTime, TIDList px, TIDList py) {
        TIDList pxyUL = new TIDList(py.item);
        int lastTid = -1;
        long totalSupport = px.getSupport();
        for (Integer ex : px.elements) {
            int periodicity;
            Integer ey = this.findElementWithTID(py, ex);
            if (ey == null) continue;
            if (firstTime) {
                periodicity = ex - lastTid;
                if (periodicity > this.maxPeriodicity) {
                    return null;
                }
                if (periodicity >= pxyUL.largestPeriodicity) {
                    pxyUL.largestPeriodicity = periodicity;
                }
                lastTid = ex;
                if (pxyUL.elements.size() > 0 && periodicity < pxyUL.smallestPeriodicity) {
                    pxyUL.smallestPeriodicity = periodicity;
                }
                pxyUL.addElement(ex);
                continue;
            }
            periodicity = ex - lastTid;
            if (periodicity > this.maxPeriodicity) {
                return null;
            }
            if (periodicity >= pxyUL.largestPeriodicity) {
                pxyUL.largestPeriodicity = periodicity;
            }
            lastTid = ex;
            if (pxyUL.elements.size() > 0 && periodicity < pxyUL.smallestPeriodicity) {
                pxyUL.smallestPeriodicity = periodicity;
            }
            pxyUL.addElement(ex);
        }
        int periodicity = this.databaseSize - 1 - lastTid;
        if (periodicity > this.maxPeriodicity) {
            return null;
        }
        if (periodicity >= pxyUL.largestPeriodicity) {
            pxyUL.largestPeriodicity = periodicity;
        }
        if ((double)pxyUL.getSupport() < this.supportPruningThreshold) {
            return null;
        }
        return pxyUL;
    }

    private Integer findElementWithTID(TIDList ulist, int tid) {
        List<Integer> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get(middle) < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get(middle) > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, TIDList utilityList, double averagePeriodicity) throws IOException {
        ++this.phuiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(utilityList.item);
        buffer.append(" #SUP: ");
        buffer.append(utilityList.getSupport());
        buffer.append(" #MINPER: ");
        buffer.append(utilityList.smallestPeriodicity);
        buffer.append(" #MAXPER: ");
        buffer.append(utilityList.largestPeriodicity);
        buffer.append(" #AVGPER: ");
        buffer.append(averagePeriodicity);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        if (this.DEBUG && this.ENABLE_ESCP) {
            System.out.println("===== CONTENT OF ESCS =====");
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapESCS.entrySet()) {
                System.out.print("Item:" + entry.getKey() + " -- ");
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    System.out.print(entry2.getKey() + " (" + entry2.getValue() + ")  ");
                }
                System.out.println();
            }
        }
        String optimizationESCP = this.ENABLE_ESCP ? " ESCP: true " : " ESCP: false ";
        System.out.println("=============  PFPM ALGORITHM v0.99g" + optimizationESCP + "=====");
        System.out.println(" Database size: " + this.databaseSize + " transactions");
        System.out.println(" Time : " + this.totalExecutionTime + " ms");
        System.out.println(" Memory ~ " + this.maximumMemoryUsage + " MB");
        System.out.println(" Periodic Itemsets count : " + this.phuiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        System.out.println(" Gamma (support prunning threshold):" + this.supportPruningThreshold);
        if (this.DEBUG && this.ENABLE_ESCP) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapESCS);
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapESCS.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("ESCS size " + maxMemory + " MB    PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    public void setEnableESCP(boolean enable) {
        this.ENABLE_ESCP = enable;
    }

    class ItemInfo {
        int support = 0;
        int largestPeriodicity = 0;
        int smallestPeriodicity = Integer.MAX_VALUE;
        int lastSeenTransaction = 0;

        ItemInfo() {
        }
    }
}

