/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.skymine;

import ca.pfv.spmf.algorithms.frequentpatterns.skymine.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.ItemSummary;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.ItemsetUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.NodeList;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.ParetoSet;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.UPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.UPTree;
import ca.pfv.spmf.algorithms.frequentpatterns.skymine.UtilitySupport;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class AlgoSkyMine {
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    private Map<Integer, Long> mapItemToTWU;
    public static Map<Integer, Long> mapItemUtility;
    private Map<Integer, Long> mapMinimumItemUtility;
    private Map<Integer, Long> mapMaximumItemUtility;
    static ArrayList<Integer> headerlist;
    private static HashMap<Integer, ItemSummary> itemDetail;
    UtilitySupport[][] itempairsUtilityMatrix = null;
    int number_items = 0;
    int[][] countArray = null;
    long numberInsertedPatterns = 0L;
    long numberVerifiedPatterns = 0L;
    long numberOfSkylineItemsets = 0L;
    ParetoSet candidateSet;
    ParetoSet resultSet;
    private List<Itemset> phuis;
    private BufferedWriter writer = null;

    public void runAlgorithm(String transactionFile, String utilityTableFile, String outputFilePath, boolean usePreInsertingSingleAndPairs, boolean useRaisingUMinByNodeUtilities) throws IOException {
        Item element;
        String thisLine;
        BufferedReader myInput;
        block46: {
            block44: {
                MemoryLogger.getInstance().reset();
                this.startTimestamp = System.currentTimeMillis();
                this.candidateSet = new ParetoSet();
                this.resultSet = new ParetoSet();
                this.mapMinimumItemUtility = new HashMap<Integer, Long>();
                this.mapMaximumItemUtility = new HashMap<Integer, Long>();
                this.mapItemToTWU = new HashMap<Integer, Long>();
                mapItemUtility = new HashMap<Integer, Long>();
                headerlist = new ArrayList();
                itemDetail = new HashMap();
                this.phuis = new ArrayList<Itemset>();
                if (outputFilePath != null) {
                    this.writer = new BufferedWriter(new FileWriter(outputFilePath));
                }
                myInput = null;
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(utilityTableFile))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        StringTokenizer dataLine = new StringTokenizer(thisLine);
                        int item = Integer.parseInt(dataLine.nextToken());
                        long internalUtility = Long.parseLong(dataLine.nextToken());
                        ++this.number_items;
                        mapItemUtility.put(item, internalUtility);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.countArray = new int[this.number_items][2];
                this.itempairsUtilityMatrix = new UtilitySupport[this.number_items + 1][this.number_items + 1];
                int i = 0;
                while (i <= this.number_items) {
                    int j = i + 1;
                    while (j <= this.number_items) {
                        this.itempairsUtilityMatrix[i][j] = new UtilitySupport(0, 0L);
                        ++j;
                    }
                    ++i;
                }
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(transactionFile))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            StringTokenizer dataLine = new StringTokenizer(thisLine);
                            int numberOfTokens = dataLine.countTokens();
                            if (numberOfTokens == 0) break;
                            long transactionUtility = 0L;
                            ArrayList<String> items = new ArrayList<String>();
                            ArrayList<Short> quantityValues = new ArrayList<Short>();
                            int tokenCounter = 0;
                            while (tokenCounter < numberOfTokens) {
                                String[] temp = dataLine.nextToken().split(":");
                                items.add(temp[0]);
                                Integer item = (int)new Integer(temp[0]);
                                Short quantity = (short)new Short(temp[1]);
                                quantityValues.add(quantity);
                                Long minItemUtil = this.mapMinimumItemUtility.get(item);
                                Long maxItemUtil = this.mapMaximumItemUtility.get(item);
                                long utility = (long)quantity.shortValue() * mapItemUtility.get(item);
                                transactionUtility += utility;
                                if (minItemUtil == null || minItemUtil >= utility) {
                                    this.mapMinimumItemUtility.put(item, utility);
                                }
                                if (maxItemUtil == null || maxItemUtil < utility) {
                                    this.mapMaximumItemUtility.put(item, utility);
                                }
                                if (!itemDetail.containsKey(item)) {
                                    ItemSummary summary = new ItemSummary(item);
                                    itemDetail.put(item, summary);
                                }
                                itemDetail.get(item).incrementSupp();
                                itemDetail.get(item).updateTotalFrequency(quantity.shortValue());
                                itemDetail.get(item).updateMinFrequency(quantity);
                                itemDetail.get(item).updateMaxFrequency(quantity);
                                ++tokenCounter;
                            }
                            for (String itlocal : items) {
                                Integer it = Integer.parseInt(itlocal);
                                Long twu = this.mapItemToTWU.get(it);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                this.mapItemToTWU.put(it, twu);
                            }
                            this.UpdatePairsUtility(items, quantityValues);
                        }
                        this.orderCountArray(this.countArray);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            if (usePreInsertingSingleAndPairs) {
                this.updateParetoSingleDoubleItems();
            }
            try {
                try {
                    UPTree tree = new UPTree();
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(transactionFile))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        StringTokenizer dataLine = new StringTokenizer(thisLine);
                        int numberOfTokens = dataLine.countTokens();
                        if (numberOfTokens == 0) break;
                        ArrayList<String> items = new ArrayList<String>();
                        ArrayList<Short> quantityValues = new ArrayList<Short>();
                        ArrayList<Long> utilityValues = new ArrayList<Long>();
                        int tokenCounter = 0;
                        while (tokenCounter < numberOfTokens) {
                            String[] temp = dataLine.nextToken().split(":");
                            items.add(temp[0]);
                            Integer number = Integer.parseInt(temp[0]);
                            Short quantity = Short.parseShort(temp[1]);
                            long temp_util = (long)quantity.shortValue() * mapItemUtility.get(number);
                            utilityValues.add(temp_util);
                            quantityValues.add(quantity);
                            ++tokenCounter;
                        }
                        long remainingUtility = 0L;
                        ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                        int i = 0;
                        while (i < items.size()) {
                            int itm = Integer.parseInt((String)items.get(i));
                            long utility = (Long)utilityValues.get(i);
                            short quan = (Short)quantityValues.get(i);
                            if (this.mapItemToTWU.get(itm) >= this.candidateSet.getUtility(AlgoSkyMine.itemDetail.get((Object)Integer.valueOf((int)itm)).support)) {
                                element = new Item(itm, utility, quan);
                                revisedTransaction.add(element);
                                remainingUtility += utility;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Item>(){

                            @Override
                            public int compare(Item o1, Item o2) {
                                return AlgoSkyMine.this.compareItemsDesc(o1.itemName, o2.itemName, AlgoSkyMine.this.mapItemToTWU);
                            }
                        });
                        tree.addTransaction(revisedTransaction, remainingUtility);
                    }
                    tree.createHeaderList(this.mapItemToTWU);
                    if (useRaisingUMinByNodeUtilities) {
                        this.generateTreeItemSets(tree.root, new int[0]);
                    }
                    this.upgrowth_plus(tree, new int[0], null);
                    this.endTimestamp = System.currentTimeMillis();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block46;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        int j = this.candidateSet.utilities.size() - 1;
        while (j >= 1) {
            ArrayList<int[]> itemsets = this.candidateSet.getUtilities().get(j).getItemSets();
            int i = 0;
            while (i < itemsets.size()) {
                int[] items_i = itemsets.get(i);
                if (items_i.length > 0) {
                    ++this.numberVerifiedPatterns;
                    int[] sorted_itemset = new int[items_i.length];
                    System.arraycopy(items_i, 0, sorted_itemset, 0, items_i.length);
                    Arrays.sort(sorted_itemset);
                    Itemset new_itemset = new Itemset(sorted_itemset);
                    this.phuis.add(new_itemset);
                }
                ++i;
            }
            --j;
        }
        MemoryLogger.getInstance().checkMemory();
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(transactionFile))));
            block23: while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                StringTokenizer dataLine = new StringTokenizer(thisLine);
                int numberOfTokens = dataLine.countTokens();
                if (numberOfTokens != 0) {
                    ArrayList<String> items = new ArrayList<String>();
                    ArrayList<Long> utilityValues = new ArrayList<Long>();
                    int tokenCounter = 0;
                    while (tokenCounter < numberOfTokens) {
                        String[] temp = dataLine.nextToken().split(":");
                        items.add(temp[0]);
                        Integer number = Integer.parseInt(temp[0]);
                        Short quantity = Short.parseShort(temp[1]);
                        long temp_util = (long)quantity.shortValue() * mapItemUtility.get(number);
                        utilityValues.add(temp_util);
                        ++tokenCounter;
                    }
                    ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                    int i = 0;
                    while (i < items.size()) {
                        int item = Integer.parseInt((String)items.get(i));
                        long utility = (Long)utilityValues.get(i);
                        element = new Item(item, utility);
                        revisedTransaction.add(element);
                        ++i;
                    }
                    Collections.sort(revisedTransaction, new Comparator<Item>(){

                        @Override
                        public int compare(Item o1, Item o2) {
                            return o1.itemName - o2.itemName;
                        }
                    });
                    for (Itemset itemset : this.phuis) {
                        if (itemset.size() > revisedTransaction.size()) continue block23;
                        this.updateExactUtility(revisedTransaction, itemset);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Itemset itemset : this.phuis) {
            this.resultSet.insert(itemset.itemset, itemset.getExactUtility(), itemset.getExactUtility(), itemset.support);
        }
        MemoryLogger.getInstance().checkMemory();
        this.saveResultToFile();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
        this.phuis.clear();
        this.mapMinimumItemUtility = null;
        this.mapMinimumItemUtility = null;
        this.mapMaximumItemUtility = null;
    }

    public void generateTreeItemSets(UPNode root, int[] prefix) {
        if (root != null) {
            List<UPNode> children = root.childs;
            int i = 0;
            while (i < children.size()) {
                this.getBFSItemsets(children.get(i), prefix, prefix);
                ++i;
            }
        }
    }

    public void getBFSItemsets(UPNode root, int[] items, int[] prefix) {
        long utilityL = 0L;
        if (root != null) {
            int[] itemset = this.realloc1(items, root.itemID);
            if (prefix.length > 0) {
                utilityL = this.getLowUtilityValue(itemset, root.count);
            }
            ++this.numberInsertedPatterns;
            this.candidateSet.insert(itemset, utilityL, root.nodeUtility, root.count);
            if (root.childs != null) {
                List<UPNode> children = root.childs;
                int i = 0;
                while (i < children.size()) {
                    this.getBFSItemsets(children.get(i), itemset, prefix);
                    ++i;
                }
            }
        }
    }

    public void updateParetoSingleDoubleItems() {
        int i = 0;
        while (i < this.number_items) {
            int j = i + 1;
            while (j < this.number_items) {
                int[] items = new int[]{i, j};
                ++this.numberInsertedPatterns;
                this.candidateSet.insert(items, this.itempairsUtilityMatrix[i][j].utility, this.itempairsUtilityMatrix[i][j].utility, this.itempairsUtilityMatrix[i][j].support);
                ++j;
            }
            ++i;
        }
        for (int item : itemDetail.keySet()) {
            int[] itemsArray = new int[]{item};
            long utility = itemDetail.get(item).getTotalFreq() * mapItemUtility.get(item);
            ++this.numberInsertedPatterns;
            this.candidateSet.insert(itemsArray, utility, utility, itemDetail.get(item).getSupport());
        }
    }

    protected int[] realloc1(int[] oldItemSet, int newElement) {
        if (oldItemSet == null) {
            int[] newItemSet = new int[]{newElement};
            return newItemSet;
        }
        int oldItemSetLength = oldItemSet.length;
        int[] newItemSet = new int[oldItemSetLength + 1];
        int index = 0;
        while (index < oldItemSetLength) {
            newItemSet[index] = oldItemSet[index];
            ++index;
        }
        newItemSet[index] = newElement;
        return newItemSet;
    }

    public int[] getPruneItems(HashMap<Integer, ItemSummary> items, ParetoSet ps) {
        ArrayList<Integer> pruneItems = new ArrayList<Integer>();
        for (Integer item1 : items.keySet()) {
            if (this.mapItemToTWU.get(item1) > ps.getUtility(items.get((Object)item1).support)) continue;
            pruneItems.add(item1);
        }
        int[] temp = new int[pruneItems.size()];
        int i = 0;
        while (i < pruneItems.size()) {
            temp[i] = (Integer)pruneItems.get(i);
            ++i;
        }
        return temp;
    }

    private void orderCountArray(int[][] countArray) {
        boolean isOrdered;
        do {
            isOrdered = true;
            int index = 1;
            while (index < countArray.length - 1) {
                if (countArray[index][1] >= countArray[index + 1][1]) {
                    ++index;
                    continue;
                }
                isOrdered = false;
                int attribute = countArray[index][0];
                int quantity = countArray[index][1];
                countArray[index][0] = countArray[index + 1][0];
                countArray[index][1] = countArray[index + 1][1];
                countArray[index + 1][0] = attribute;
                countArray[index + 1][1] = quantity;
                ++index;
            }
        } while (!isOrdered);
    }

    public void UpdatePairsUtility(ArrayList<String> items, ArrayList<Short> quantity) {
        int i = 0;
        while (i < items.size()) {
            int j = i + 1;
            while (j < items.size()) {
                try {
                    this.itempairsUtilityMatrix[Integer.parseInt((String)items.get((int)i))][Integer.parseInt((String)items.get((int)j))].utility += (long)quantity.get(i).shortValue() * mapItemUtility.get(Integer.parseInt(items.get(i))) + (long)quantity.get(j).shortValue() * mapItemUtility.get(Integer.parseInt(items.get(j)));
                }
                catch (Exception e) {
                    System.out.println("caught");
                    throw e;
                }
                ++this.itempairsUtilityMatrix[Integer.parseInt((String)items.get((int)i))][Integer.parseInt((String)items.get((int)j))].support;
                ++j;
            }
            ++i;
        }
    }

    public void updateExactUtility(List<Item> transaction, Itemset itemset) {
        long utility = 0L;
        int i = 0;
        while (i < itemset.size()) {
            block4: {
                Integer itemI = itemset.get(i);
                int j = 0;
                while (j < transaction.size()) {
                    Item itemJ = transaction.get(j);
                    if (itemJ.itemName == itemI) {
                        utility += transaction.get((int)j).utility;
                        break block4;
                    }
                    if (itemJ.itemName > itemI) {
                        return;
                    }
                    ++j;
                }
                return;
            }
            ++i;
        }
        itemset.increaseUtility(utility);
        ++itemset.support;
    }

    private int compareItemsDesc(int item1, int item2, Map<Integer, Long> mapItemEstimatedUtility) {
        int compare = (int)(mapItemEstimatedUtility.get(item2) - mapItemEstimatedUtility.get(item1));
        return compare == 0 ? item1 - item2 : compare;
    }

    protected int[] realloc2(int[] oldItemSet, int newElement) {
        if (oldItemSet == null) {
            int[] newItemSet = new int[]{newElement};
            return newItemSet;
        }
        int oldItemSetLength = oldItemSet.length;
        int[] newItemSet = new int[oldItemSetLength + 1];
        newItemSet[0] = newElement;
        int index = 0;
        while (index < oldItemSetLength) {
            newItemSet[index + 1] = oldItemSet[index];
            ++index;
        }
        return newItemSet;
    }

    private void upgrowth_plus_inner(UPTree pass_tree, int[] pass_prefix, int pass_item, NodeList nList) throws IOException {
        int[] newPrefix = new int[pass_prefix.length + 1];
        System.arraycopy(pass_prefix, 0, newPrefix, 0, pass_prefix.length);
        newPrefix[pass_prefix.length] = pass_item;
        UPNode pathCPB = pass_tree.mapItemNodes.get(pass_item);
        int supp = 0;
        int pathCPBUtility = 0;
        while (pathCPB != null) {
            pathCPBUtility = (int)((long)pathCPBUtility + pathCPB.nodeUtility);
            supp += pathCPB.count;
            pathCPB = pathCPB.nodeLink;
        }
        NodeList node = new NodeList(pass_item);
        node.addNode(nList);
        if ((long)pathCPBUtility > this.candidateSet.getUtility(supp)) {
            long highCodeUtility = this.getNodeHighUtilityValue(node, supp);
            long lowCodeUtility = this.getNodeLowUtilityValue(node, supp);
            if (highCodeUtility > (long)pathCPBUtility) {
                highCodeUtility = pathCPBUtility;
            }
            if (highCodeUtility > this.candidateSet.getUtility(supp)) {
                ++this.numberInsertedPatterns;
                this.candidateSet.insert(newPrefix, lowCodeUtility, highCodeUtility, supp);
            }
            UPTree localTree = this.createLocalTree(pass_tree, pass_item);
            if (localTree.headerList.size() > 0) {
                this.upgrowth_plus(localTree, newPrefix, node);
            }
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public long getHighUtilityValue(int[] itemset, int support) {
        long utility = 0L;
        int i = 0;
        i = 0;
        while (i < itemset.length) {
            int item = itemset[i];
            ItemSummary iDetail = itemDetail.get(item);
            long itemUtility = mapItemUtility.get(item);
            utility += Math.min((long)iDetail.totalFrequency * itemUtility - (long)((iDetail.support - support) * iDetail.minFrequency) * itemUtility, (long)(support * iDetail.maxFrequency) * itemUtility);
            ++i;
        }
        return utility;
    }

    public long getNodeHighUtilityValue(NodeList nList, int support) {
        long utility = 0L;
        NodeList tempHead = nList;
        while (tempHead != null) {
            utility += this.getHighUtilityValue(tempHead.getItemName(), support);
            tempHead = tempHead.getNextNode();
        }
        return utility;
    }

    public long getNodeLowUtilityValue(NodeList nList, int support) {
        long utility = 0L;
        NodeList tempHead = nList;
        while (tempHead != null) {
            utility += this.getLowUtilityValue(tempHead.getItemName(), support);
            tempHead = tempHead.getNextNode();
        }
        return utility;
    }

    public long getHighUtilityValue(int itemName, int support) {
        long utility = 0L;
        long itemUtility = mapItemUtility.get(itemName);
        ItemSummary iDetail = itemDetail.get(itemName);
        utility = Math.min((long)iDetail.totalFrequency * itemUtility - (long)((iDetail.support - support) * iDetail.minFrequency) * itemUtility, (long)support * this.mapMaximumItemUtility.get(itemName));
        return utility;
    }

    public long getLowUtilityValue(int itemName, int support) {
        long utility = 0L;
        long itemUtility = mapItemUtility.get(itemName);
        ItemSummary iDetail = itemDetail.get(itemName);
        utility = Math.max((long)iDetail.totalFrequency * itemUtility - (long)((iDetail.support - support) * iDetail.maxFrequency) * itemUtility, (long)support * this.mapMinimumItemUtility.get(itemName));
        return utility;
    }

    public long getLowUtilityValue(int[] itemset, int support) {
        long utility = 0L;
        int i = 0;
        i = 0;
        while (i < itemset.length) {
            int item = itemset[i];
            ItemSummary iDetail = itemDetail.get(item);
            long itemUtility = mapItemUtility.get(item);
            utility += Math.max((long)iDetail.totalFrequency * itemUtility - (long)((iDetail.support - support) * iDetail.maxFrequency) * itemUtility, (long)(support * iDetail.minFrequency) * itemUtility);
            ++i;
        }
        return utility;
    }

    private void upgrowth_plus(UPTree tree, int[] prefix, NodeList node) throws IOException {
        int i = tree.headerList.size() - 1;
        while (i >= 0) {
            Integer item = tree.headerList.get(i);
            this.upgrowth_plus_inner(tree, prefix, item, node);
            --i;
        }
    }

    private UPTree createLocalTree(UPTree tree, Integer item) {
        ArrayList prefixPaths = new ArrayList();
        UPNode path = tree.mapItemNodes.get(item);
        final HashMap<Integer, Long> itemPathUtility = new HashMap<Integer, Long>();
        while (path != null) {
            long nodeutility = path.nodeUtility;
            if (path.parent.itemID != -1) {
                ArrayList<UPNode> prefixPath = new ArrayList<UPNode>();
                prefixPath.add(path);
                UPNode parentnode = path.parent;
                while (parentnode.itemID != -1) {
                    prefixPath.add(parentnode);
                    Long pu = (Long)itemPathUtility.get(parentnode.itemID);
                    pu = pu == null ? nodeutility : pu + nodeutility;
                    itemPathUtility.put(parentnode.itemID, pu);
                    parentnode = parentnode.parent;
                }
                prefixPaths.add(prefixPath);
            }
            path = path.nodeLink;
        }
        UPTree localTree = new UPTree();
        for (List list : prefixPaths) {
            int pathCount = ((UPNode)list.get((int)0)).count;
            long pathUtility = ((UPNode)list.get((int)0)).nodeUtility;
            ArrayList<UPNode> localPath = new ArrayList<UPNode>();
            int j = 1;
            while (j < list.size()) {
                long itemValue = 0L;
                UPNode node = (UPNode)list.get(j);
                if ((Long)itemPathUtility.get(node.itemID) >= this.candidateSet.getUtility(AlgoSkyMine.itemDetail.get((Object)Integer.valueOf((int)node.itemID)).support)) {
                    localPath.add(node);
                } else {
                    Long minItemUtility = 0L;
                    minItemUtility = (long)node.min_node_quantity * mapItemUtility.get(node.itemID);
                    itemValue = minItemUtility * (long)pathCount;
                }
                pathUtility -= itemValue;
                ++j;
            }
            Collections.sort(localPath, new Comparator<UPNode>(){

                @Override
                public int compare(UPNode o1, UPNode o2) {
                    return AlgoSkyMine.this.compareItemsDesc(o1.itemID, o2.itemID, itemPathUtility);
                }
            });
            int supp = pathCount;
            try {
                localTree.addLocalTransaction(localPath, pathUtility, this.mapMinimumItemUtility, supp);
            }
            catch (Exception e) {
                System.out.println("Exception in adding path to local tree");
                System.out.println("pathUtility: " + pathUtility + " supp: " + supp + " mapMinimumItemUtility: " + this.mapMinimumItemUtility.get((short)1));
                e.printStackTrace();
                System.out.println(((Object)localPath).toString());
                throw e;
            }
        }
        localTree.createHeaderList(this.mapItemToTWU);
        int i = 0;
        while (i < localTree.headerList.size()) {
            int n = localTree.headerList.get(i);
            headerlist.add(n);
            ++i;
        }
        return localTree;
    }

    public void printStats() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("=============  SkyMine ALGORITHM - STATS =============\n");
        buffer.append("Total time: " + (this.endTimestamp - this.startTimestamp) + " ms \n");
        buffer.append("Memory: " + MemoryLogger.getInstance().getMaxMemory() + " MB \n");
        buffer.append("Number of inserted patterns in candidate set: " + this.numberInsertedPatterns + "\n");
        buffer.append("Number of patterns to be verified: " + this.numberVerifiedPatterns + "\n");
        buffer.append("Number of skyline patterns: " + this.numberOfSkylineItemsets + "\n");
        buffer.append("===================================================\n\n \n");
        System.out.println(buffer.toString());
    }

    private void saveResultToFile() throws IOException {
        StringBuilder buffer = new StringBuilder();
        boolean shouldInsertNewLineBeforeNextItemset = false;
        int j = this.resultSet.utilities.size() - 1;
        while (j >= 1) {
            ArrayList<ItemsetUtility> itemsets = this.resultSet.getUtilities().get(j).getItemSetsWithUtilities();
            int i = 0;
            while (i < itemsets.size()) {
                if (shouldInsertNewLineBeforeNextItemset) {
                    shouldInsertNewLineBeforeNextItemset = false;
                    buffer.append(System.lineSeparator());
                }
                ItemsetUtility itemsetUtility = itemsets.get(i);
                int[] itemsItemsetI = itemsetUtility.itemset;
                long utility = itemsetUtility.utility;
                int k = 0;
                while (k < itemsItemsetI.length) {
                    buffer.append(itemsItemsetI[k]);
                    buffer.append(" ");
                    ++k;
                }
                buffer.append("#UTIL: " + utility);
                shouldInsertNewLineBeforeNextItemset = true;
                ++this.numberOfSkylineItemsets;
                ++i;
            }
            --j;
        }
        this.writer.write(buffer.toString());
    }
}

