/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.skymine;

import ca.pfv.spmf.algorithms.frequentpatterns.skymine.ItemsetUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class UtilityInterval {
    ArrayList<Interval> intervalSet = new ArrayList();
    private long currentMaxMin = 0L;

    public void insertUtilityInt(long xL, long yH, int[] itemset) {
        if (this.currentMaxMin < yH) {
            Interval inV = new Interval(xL, yH, itemset);
            if (!this.filterUtilityIntervals(xL, itemset)) {
                this.intervalSet.add(inV);
            }
        }
        if (xL > this.currentMaxMin) {
            this.currentMaxMin = xL;
        }
    }

    public long getUtilityValue() {
        if (this.intervalSet.size() > 0) {
            return this.currentMaxMin;
        }
        return 0L;
    }

    private boolean filterUtilityIntervals(long xL, int[] itemset) {
        boolean itemsubsetflag = false;
        int i = this.intervalSet.size() - 1;
        while (i >= 0) {
            if (this.isSuperItemSet(this.intervalSet.get((int)i).itemset, itemset)) {
                itemsubsetflag = true;
            }
            if (this.intervalSet.get(i).getHigh() < xL || this.isSuperItemSet(itemset, this.intervalSet.get((int)i).itemset)) {
                this.intervalSet.remove(i);
            }
            --i;
        }
        return itemsubsetflag;
    }

    private boolean isSuperItemSet(int[] itemsetR, int[] itemsetOther) {
        if (itemsetR == null && itemsetOther == null) {
            return false;
        }
        if (itemsetOther == null) {
            return true;
        }
        if (itemsetR == null) {
            return false;
        }
        HashSet<Integer> referenceSet = new HashSet<Integer>();
        int i = 0;
        while (i < itemsetR.length) {
            referenceSet.add(itemsetR[i]);
            ++i;
        }
        HashSet<Integer> otherSet = new HashSet<Integer>();
        int i2 = 0;
        while (i2 < itemsetOther.length) {
            otherSet.add(itemsetOther[i2]);
            ++i2;
        }
        if (referenceSet.containsAll(otherSet) && otherSet.containsAll(referenceSet)) {
            return false;
        }
        return referenceSet.containsAll(otherSet);
    }

    public ArrayList<int[]> getItemSets() {
        ArrayList<int[]> resultSet = new ArrayList<int[]>();
        int i = 0;
        while (i < this.intervalSet.size()) {
            Interval intervalI = this.intervalSet.get(i);
            int[] itemsetArray = intervalI.getItemset();
            if (itemsetArray != null) {
                Arrays.sort(itemsetArray);
                resultSet.add(itemsetArray);
            }
            ++i;
        }
        return resultSet;
    }

    public ArrayList<ItemsetUtility> getItemSetsWithUtilities() {
        ArrayList<ItemsetUtility> resultSet = new ArrayList<ItemsetUtility>();
        int i = 0;
        while (i < this.intervalSet.size()) {
            Interval intervalI = this.intervalSet.get(i);
            int[] itemsetArray = intervalI.getItemset();
            if (itemsetArray != null) {
                Arrays.sort(itemsetArray);
                ItemsetUtility itemsetUtility = new ItemsetUtility();
                itemsetUtility.itemset = itemsetArray;
                itemsetUtility.utility = intervalI.getHigh();
                resultSet.add(itemsetUtility);
            }
            ++i;
        }
        return resultSet;
    }

    public String toString(int[] reconversionArray) {
        String result = "";
        int i = 0;
        while (i < this.intervalSet.size()) {
            if (this.intervalSet.get((int)i).itemset != null) {
                result = String.valueOf(result) + " (" + this.intervalSet.get(i).getLow() + "," + this.intervalSet.get(i).getHigh() + ":" + Arrays.toString(this.convert(this.intervalSet.get((int)i).itemset, reconversionArray)) + ")";
            }
            ++i;
        }
        return result;
    }

    private int[] convert(int[] items, int[] reconversionArray) {
        if (reconversionArray == null) {
            return items;
        }
        if (items == null) {
            return null;
        }
        int[] newItemSet = new int[items.length];
        int index = 0;
        while (index < newItemSet.length) {
            newItemSet[index] = reconversionArray[items[index]];
            ++index;
        }
        return newItemSet;
    }

    private class Interval
    implements Comparable<Interval> {
        long low;
        long high;
        int[] itemset;

        Interval(long xL, long xH, int[] items) {
            this.low = xL;
            this.high = xH;
            this.itemset = items;
        }

        public int[] getItemset() {
            return this.itemset;
        }

        public long getLow() {
            return this.low;
        }

        public long getHigh() {
            return this.high;
        }

        @Override
        public int compareTo(Interval other) {
            return (int)(other.getLow() - this.getLow());
        }
    }
}

