/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.tshoun;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;

public class MainDatasetUtilityGenerator {
    public static void main(String[] arg) throws IOException, InterruptedException {
        boolean includeItemsHavingNegativeProfit = true;
        int numberOfPeriods = 5;
        String dataset = "retail";
        String input = "C:\\Datasets\\" + dataset + ".txt";
        String output = includeItemsHavingNegativeProfit ? "C:\\Datasets\\periods\\" + dataset + "_p" + numberOfPeriods + "_negative.txt" : "C:\\Datasets\\periods\\" + dataset + "_p" + numberOfPeriods + ".txt";
        MainDatasetUtilityGenerator.generateDataset(includeItemsHavingNegativeProfit, numberOfPeriods, input, output);
    }

    private static void generateDataset(boolean includeItemsHavingNegativeProfit, int numberOfPeriods, String input, String output) throws IOException, FileNotFoundException {
        String[] split;
        String thisLine;
        HashSet<Integer> items = new HashSet<Integer>();
        long avglength = 0L;
        long tidcount = 0L;
        Random randomGenerator = new Random(System.currentTimeMillis());
        HashMap<Integer, Integer> externalUtilities = new HashMap<Integer, Integer>();
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        BufferedReader myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
        while ((thisLine = myInput.readLine()) != null) {
            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
            split = thisLine.split(" ");
            ++tidcount;
            avglength += (long)split.length;
            int i = 0;
            while (i < split.length) {
                Integer item = Integer.parseInt(split[i]);
                items.add(item);
                if (!externalUtilities.containsKey(item)) {
                    double rand = Math.abs(randomGenerator.nextGaussian()) / 3.0 * 10.0;
                    int extUtility = (int)rand + 1;
                    if (includeItemsHavingNegativeProfit && randomGenerator.nextBoolean()) {
                        extUtility = 0 - extUtility;
                    }
                    externalUtilities.put(item, extUtility);
                }
                ++i;
            }
        }
        myInput.close();
        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
        while ((thisLine = myInput.readLine()) != null) {
            int extutility;
            Integer item;
            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
            split = thisLine.split(" ");
            ArrayList<Integer> quantities = new ArrayList<Integer>();
            int TU = 0;
            int i = 0;
            while (i < split.length) {
                item = Integer.parseInt(split[i]);
                int quantity = randomGenerator.nextInt(10) + 1;
                quantities.add(quantity);
                extutility = (Integer)externalUtilities.get(item);
                if (extutility > 0) {
                    TU += extutility * quantity;
                }
                ++i;
            }
            i = 0;
            while (i < split.length) {
                item = Integer.parseInt(split[i]);
                writer.write("" + item);
                if (i != split.length - 1) {
                    writer.write(" ");
                }
                ++i;
            }
            writer.write(":");
            writer.write("" + TU);
            writer.write(":");
            i = 0;
            while (i < split.length) {
                item = Integer.parseInt(split[i]);
                Integer q = (Integer)quantities.get(i);
                extutility = (Integer)externalUtilities.get(item);
                writer.write("" + q * extutility);
                if (i != split.length - 1) {
                    writer.write(" ");
                }
                ++i;
            }
            int period = randomGenerator.nextInt(numberOfPeriods);
            writer.write(":" + period);
            writer.newLine();
        }
        writer.close();
        System.out.println("item count " + items.size());
        System.out.println("transacion count " + tidcount);
        System.out.println("transacion avg length " + (double)avglength / (double)tidcount);
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainDatasetUtilityGenerator.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

