/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.two_phase;

import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemsetTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemsetsTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.TransactionTP;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.UtilityTransactionDatabaseTP;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AlgoHUINIVMine {
    private ItemsetsTP highUtilityItemsets = null;
    protected UtilityTransactionDatabaseTP database;
    int minUtility;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    private int candidatesCount;
    Set<Integer> negativeItems = new HashSet<Integer>();

    public ItemsetsTP runAlgorithm(UtilityTransactionDatabaseTP database, int minUtility) {
        int candidateCount;
        this.database = database;
        this.minUtility = minUtility;
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.highUtilityItemsets = new ItemsetsTP("HIGH UTILITY ITEMSETS");
        this.candidatesCount = 0;
        ArrayList<ItemsetTP> candidatesSize1 = new ArrayList<ItemsetTP>();
        HashMap<Integer, HashSet<Integer>> mapItemTidsets = new HashMap<Integer, HashSet<Integer>>();
        HashMap<Integer, Integer> mapItemTWU = new HashMap<Integer, Integer>();
        int maxItem = Integer.MIN_VALUE;
        int i = 0;
        while (i < database.size()) {
            TransactionTP transaction = database.getTransactions().get(i);
            int j = 0;
            while (j < transaction.getItems().size()) {
                HashSet<Integer> tidset;
                ItemUtility itemUtilityObj = transaction.getItems().get(j);
                int item = itemUtilityObj.item;
                int itemUtility = itemUtilityObj.utility;
                if (itemUtility < 0) {
                    this.negativeItems.add(item);
                }
                if (item > maxItem) {
                    maxItem = item;
                }
                if ((tidset = (HashSet<Integer>)mapItemTidsets.get(item)) == null) {
                    tidset = new HashSet<Integer>();
                    mapItemTidsets.put(item, tidset);
                }
                tidset.add(i);
                Integer sumUtility = (Integer)mapItemTWU.get(item);
                if (sumUtility == null) {
                    sumUtility = 0;
                }
                sumUtility = sumUtility + transaction.getTransactionUtility();
                mapItemTWU.put(item, sumUtility);
                ++j;
            }
            ++i;
        }
        for (TransactionTP transaction : database.getTransactions()) {
            Collections.sort(transaction.getItems(), new Comparator<ItemUtility>(){

                @Override
                public int compare(ItemUtility o1, ItemUtility o2) {
                    return o1.item - o2.item;
                }
            });
        }
        int item = 0;
        while (item <= maxItem) {
            Integer estimatedUtility = (Integer)mapItemTWU.get(item);
            if (estimatedUtility != null && estimatedUtility >= minUtility) {
                ItemsetTP itemset = new ItemsetTP();
                itemset.addItem(item);
                itemset.setTIDset((Set)mapItemTidsets.get(item));
                candidatesSize1.add(itemset);
                this.highUtilityItemsets.addItemset(itemset, itemset.size());
            }
            ++item;
        }
        List<ItemsetTP> currentLevel = candidatesSize1;
        do {
            candidateCount = this.highUtilityItemsets.getItemsetsCount();
            currentLevel = this.generateCandidateSizeK(currentLevel, this.highUtilityItemsets);
        } while (candidateCount != this.highUtilityItemsets.getItemsetsCount());
        MemoryLogger.getInstance().checkMemory();
        this.candidatesCount = this.highUtilityItemsets.getItemsetsCount();
        for (List<ItemsetTP> level : this.highUtilityItemsets.getLevels()) {
            Iterator<ItemsetTP> iterItemset = level.iterator();
            while (iterItemset.hasNext()) {
                ItemsetTP candidate = iterItemset.next();
                if (this.onlyContainsNegativeItems(candidate.getItems())) {
                    iterItemset.remove();
                    this.highUtilityItemsets.decreaseCount();
                    continue;
                }
                for (TransactionTP transaction : database.getTransactions()) {
                    int transactionUtility = 0;
                    int matchesCount = 0;
                    int i2 = 0;
                    while (i2 < transaction.size()) {
                        if (candidate.getItems().contains(transaction.get((int)i2).item)) {
                            transactionUtility += transaction.getItemsUtilities().get((int)i2).utility;
                            ++matchesCount;
                        }
                        ++i2;
                    }
                    if (matchesCount != candidate.size()) continue;
                    candidate.incrementUtility(transactionUtility);
                }
                if (candidate.getUtility() >= minUtility) continue;
                iterItemset.remove();
                this.highUtilityItemsets.decreaseCount();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return this.highUtilityItemsets;
    }

    private boolean onlyContainsNegativeItems(List<Integer> items) {
        for (Integer item : items) {
            if (this.negativeItems.contains(item)) continue;
            return false;
        }
        return true;
    }

    protected List<ItemsetTP> generateCandidateSizeK(List<ItemsetTP> levelK_1, ItemsetsTP candidatesHTWUI) {
        int i = 0;
        while (i < levelK_1.size()) {
            ItemsetTP itemset1 = levelK_1.get(i);
            int j = i + 1;
            block1: while (j < levelK_1.size()) {
                block11: {
                    ItemsetTP itemset2 = levelK_1.get(j);
                    int k = 0;
                    while (k < itemset1.size()) {
                        if (k == itemset1.size() - 1) {
                            if (itemset1.getItems().get(k) >= itemset2.get(k)) {
                                break block1;
                            }
                        } else {
                            if (itemset1.getItems().get(k) >= itemset2.get(k)) {
                                if (itemset1.getItems().get(k) > itemset2.get(k)) break block1;
                            }
                            break block11;
                        }
                        ++k;
                    }
                    Integer missing = itemset2.get(itemset2.size() - 1);
                    HashSet<Integer> tidset = new HashSet<Integer>();
                    for (Integer val1 : itemset1.getTIDset()) {
                        if (!itemset2.getTIDset().contains(val1)) continue;
                        tidset.add(val1);
                    }
                    int twu = 0;
                    for (Integer tid : tidset) {
                        twu += this.database.getTransactions().get(tid).getTransactionUtility();
                    }
                    if (twu >= this.minUtility) {
                        ItemsetTP candidate = new ItemsetTP();
                        int k2 = 0;
                        while (k2 < itemset1.size()) {
                            candidate.addItem(itemset1.get(k2));
                            ++k2;
                        }
                        candidate.addItem(missing);
                        candidate.setTIDset(tidset);
                        candidatesHTWUI.addItemset(candidate, candidate.size());
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidatesHTWUI.getLevels().get(candidatesHTWUI.getLevels().size() - 1);
    }

    public void printStats() {
        System.out.println("=============  HUINIV-MINE ALGORITHM - STATS =============");
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Candidates count : " + this.candidatesCount);
        System.out.println(" High-utility itemsets count : " + this.highUtilityItemsets.getItemsetsCount());
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

