/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.two_phase;

import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.TransactionTP;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UtilityTransactionDatabaseTP {
    private final Set<Integer> allItems = new HashSet<Integer>();
    private final List<TransactionTP> transactions = new ArrayList<TransactionTP>();

    public void loadFile(String path) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(path));
                myInput = new BufferedReader(new InputStreamReader(fin));
                while ((thisLine = myInput.readLine()) != null) {
                    if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                    this.processTransaction(thisLine.split(":"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    private void processTransaction(String[] line) {
        int transactionUtility = Integer.parseInt(line[1]);
        String[] items = line[0].split(" ");
        String[] utilities = line[2].split(" ");
        ArrayList<ItemUtility> itemUtilityObjects = new ArrayList<ItemUtility>();
        int i = 0;
        while (i < items.length) {
            itemUtilityObjects.add(new ItemUtility(Integer.parseInt(items[i]), Integer.parseInt(utilities[i])));
            ++i;
        }
        this.transactions.add(new TransactionTP(itemUtilityObjects, transactionUtility));
    }

    public void printDatabase() {
        System.out.println("===================  Database ===================");
        int count = 0;
        for (TransactionTP itemset : this.transactions) {
            System.out.print("0" + count + ":  ");
            itemset.print();
            System.out.println("");
            ++count;
        }
    }

    public int size() {
        return this.transactions.size();
    }

    public List<TransactionTP> getTransactions() {
        return this.transactions;
    }

    public Set<Integer> getAllItems() {
        return this.allItems;
    }
}

