/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup;

import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.UPNodePlus;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.UPTreePlus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoUPGrowthPlus {
    private double maxMemory = 0.0;
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    private int huiCount = 0;
    private int phuisCount;
    private Map<Integer, Integer> mapMinimumItemUtility;
    private BufferedWriter writer = null;
    private List<Itemset> phuis = new ArrayList<Itemset>();
    private final boolean DEBUG = false;

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String[] items;
        String[] split;
        String thisLine;
        BufferedReader myInput;
        HashMap<Integer, Integer> mapItemToTWU;
        block30: {
            block28: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                mapItemToTWU = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = (Integer)mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.mapMinimumItemUtility = new HashMap<Integer, Integer>();
            try {
                try {
                    UPTreePlus tree = new UPTreePlus();
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split2 = thisLine.split(":");
                        String[] items2 = split2[0].split(" ");
                        String[] utilityValues = split2[2].split(" ");
                        int remainingUtility = 0;
                        ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                        int i = 0;
                        while (i < items2.length) {
                            int itm = Integer.parseInt(items2[i]);
                            int utility = Integer.parseInt(utilityValues[i]);
                            if ((Integer)mapItemToTWU.get(itm) >= minUtility) {
                                Item element = new Item(itm, utility);
                                revisedTransaction.add(element);
                                remainingUtility += utility;
                                Integer minItemUtil = this.mapMinimumItemUtility.get(itm);
                                if (minItemUtil == null || minItemUtil >= utility) {
                                    this.mapMinimumItemUtility.put(itm, utility);
                                }
                                element = null;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Item>(){

                            @Override
                            public int compare(Item o1, Item o2) {
                                return AlgoUPGrowthPlus.this.compareItemsDesc(o1.name, o2.name, mapItemToTWU);
                            }
                        });
                        tree.addTransaction(revisedTransaction, remainingUtility);
                    }
                    tree.createHeaderList(mapItemToTWU);
                    this.checkMemory();
                    this.upgrowthPlus(tree, minUtility, new int[0]);
                    this.checkMemory();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.phuisCount = this.phuis.size();
        Collections.sort(this.phuis, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset arg0, Itemset arg1) {
                return arg0.size() - arg1.size();
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            block14: while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                int i = 0;
                while (i < items.length) {
                    int item = Integer.parseInt(items[i]);
                    int utility = Integer.parseInt(utilityValues[i]);
                    Item element = new Item(item, utility);
                    if ((Integer)mapItemToTWU.get(item) >= minUtility) {
                        revisedTransaction.add(element);
                    }
                    ++i;
                }
                Collections.sort(revisedTransaction, new Comparator<Item>(){

                    @Override
                    public int compare(Item o1, Item o2) {
                        return o1.name - o2.name;
                    }
                });
                for (Itemset itemset : this.phuis) {
                    if (itemset.size() > revisedTransaction.size()) continue block14;
                    this.updateExactUtility(revisedTransaction, itemset);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Itemset itemset : this.phuis) {
            if (itemset.getExactUtility() < minUtility) continue;
            this.writeOut(itemset);
        }
        this.checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        this.phuis.clear();
        this.mapMinimumItemUtility = null;
        this.writer.close();
    }

    private int compareItemsDesc(int item1, int item2, Map<Integer, Integer> mapItemEstimatedUtility) {
        int compare = mapItemEstimatedUtility.get(item2) - mapItemEstimatedUtility.get(item1);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void upgrowthPlus(UPTreePlus tree, int minUtility, int[] prefix) throws IOException {
        int i = tree.headerList.size() - 1;
        while (i >= 0) {
            Integer item = tree.headerList.get(i);
            UPTreePlus localTree = this.createLocalTree(minUtility, tree, item);
            UPNodePlus pathCPB = tree.mapItemNodes.get(item);
            int pathCPBUtility = 0;
            while (pathCPB != null) {
                pathCPBUtility += pathCPB.nodeUtility;
                pathCPB = pathCPB.nodeLink;
            }
            if (pathCPBUtility >= minUtility) {
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = item;
                this.savePHUI(newPrefix);
                if (localTree.headerList.size() > 0) {
                    this.upgrowthPlus(localTree, minUtility, newPrefix);
                }
            }
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private UPTreePlus createLocalTree(int minUtility, UPTreePlus tree, Integer item) {
        ArrayList prefixPaths = new ArrayList();
        UPNodePlus path = tree.mapItemNodes.get(item);
        final HashMap<Integer, Integer> itemPathUtility = new HashMap<Integer, Integer>();
        while (path != null) {
            int nodeutility = path.nodeUtility;
            if (path.parent.itemID != -1) {
                void var9_10;
                ArrayList<Object> prefixPath = new ArrayList<Object>();
                prefixPath.add(path);
                UPNodePlus uPNodePlus = path.parent;
                while (var9_10.itemID != -1) {
                    prefixPath.add(var9_10);
                    Integer pu = (Integer)itemPathUtility.get(var9_10.itemID);
                    pu = pu == null ? nodeutility : pu + nodeutility;
                    itemPathUtility.put(var9_10.itemID, pu);
                    UPNodePlus uPNodePlus2 = var9_10.parent;
                }
                prefixPaths.add(prefixPath);
            }
            path = path.nodeLink;
        }
        UPTreePlus localTree = new UPTreePlus();
        HashMap<Integer, Integer> mapMiniNodeUtility = new HashMap<Integer, Integer>();
        for (List list : prefixPaths) {
            int j = 1;
            while (j < list.size()) {
                UPNodePlus node = (UPNodePlus)list.get(j);
                if ((Integer)itemPathUtility.get(node.itemID) >= minUtility) {
                    Integer util = (Integer)mapMiniNodeUtility.get(node.itemID);
                    if (util == null) {
                        mapMiniNodeUtility.put(node.itemID, node.minimalNodeUtility);
                    } else if (node.minimalNodeUtility < util) {
                        mapMiniNodeUtility.put(node.itemID, node.minimalNodeUtility);
                    }
                }
                ++j;
            }
        }
        for (List list : prefixPaths) {
            int pathCount = ((UPNodePlus)list.get((int)0)).count;
            int pathUtility = ((UPNodePlus)list.get((int)0)).nodeUtility;
            ArrayList<Integer> localPath = new ArrayList<Integer>();
            int j = 1;
            while (j < list.size()) {
                int itemValue = 0;
                UPNodePlus node = (UPNodePlus)list.get(j);
                if ((Integer)itemPathUtility.get(node.itemID) >= minUtility) {
                    localPath.add(node.itemID);
                } else {
                    itemValue = node.minimalNodeUtility * pathCount;
                }
                pathUtility -= itemValue;
                ++j;
            }
            Collections.sort(localPath, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return AlgoUPGrowthPlus.this.compareItemsDesc(o1, o2, itemPathUtility);
                }
            });
            localTree.addLocalTransaction(localPath, pathUtility, mapMiniNodeUtility, pathCount);
        }
        localTree.createHeaderList(itemPathUtility);
        return localTree;
    }

    private void savePHUI(int[] itemset) {
        Itemset itemsetObj = new Itemset(itemset);
        Arrays.sort(itemset);
        this.phuis.add(itemsetObj);
    }

    public void updateExactUtility(List<Item> transaction, Itemset itemset) {
        int utility = 0;
        int i = 0;
        while (i < itemset.size()) {
            block4: {
                Integer itemI = itemset.get(i);
                int j = 0;
                while (j < transaction.size()) {
                    Item itemJ = transaction.get(j);
                    if (itemJ.name == itemI) {
                        utility += transaction.get((int)j).utility;
                        break block4;
                    }
                    if (itemJ.name > itemI) {
                        return;
                    }
                    ++j;
                }
                return;
            }
            ++i;
        }
        itemset.increaseUtility(utility);
    }

    private void writeOut(Itemset HUI) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < HUI.size()) {
            buffer.append(HUI.get(i));
            buffer.append(' ');
            ++i;
        }
        buffer.append("#UTIL: ");
        buffer.append(HUI.getExactUtility());
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  UP-GROWTH+ ALGORITHM v96r17 - STATS =============");
        System.out.println(" PHUIs (candidates) count: " + this.phuisCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" HUIs count : " + this.huiCount);
        System.out.println("===================================================");
    }
}

