/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.zart;

import ca.pfv.spmf.algorithms.frequentpatterns.zart.TCTableCandidate;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.TFTableFrequent;
import ca.pfv.spmf.algorithms.frequentpatterns.zart.TZTableClosed;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AlgoZart {
    long startTimestamp;
    long endTimestamp;
    private int minsupRelative = 0;
    private TransactionDatabase context = null;
    private TZTableClosed tableClosed = null;
    private TFTableFrequent tableFrequent = null;
    private TCTableCandidate tableCandidate = null;
    private List<Itemset> frequentGeneratorsFG = null;

    public TZTableClosed runAlgorithm(TransactionDatabase database, double minsupp) {
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.context = database;
        this.frequentGeneratorsFG = new ArrayList<Itemset>();
        this.tableClosed = new TZTableClosed();
        this.tableFrequent = new TFTableFrequent();
        this.tableCandidate = new TCTableCandidate();
        this.minsupRelative = (int)Math.ceil(minsupp * (double)database.size());
        HashMap<Integer, Integer> mapItemSupport = new HashMap<Integer, Integer>();
        for (List<Integer> transaction : database.getTransactions()) {
            for (Integer item : transaction) {
                Integer count = (Integer)mapItemSupport.get(item);
                if (count == null) {
                    mapItemSupport.put(item, 1);
                    continue;
                }
                count = count + 1;
                mapItemSupport.put(item, count);
            }
        }
        for (List<Integer> transaction : database.getTransactions()) {
            Iterator<Integer> it = transaction.iterator();
            while (it.hasNext()) {
                Integer n = it.next();
                if ((Integer)mapItemSupport.get(n) >= this.minsupRelative) continue;
                it.remove();
            }
        }
        this.tableCandidate.levels.add(new ArrayList());
        for (Integer item : mapItemSupport.keySet()) {
            Itemset itemset = new Itemset(item);
            itemset.setAbsoluteSupport((Integer)mapItemSupport.get(item));
            if ((Integer)mapItemSupport.get(item) < this.minsupRelative) continue;
            this.tableFrequent.addFrequentItemset(itemset);
            this.tableCandidate.levels.get(0).add(itemset);
        }
        if (this.tableFrequent.levels.size() != 0) {
            boolean fullCollumn = false;
            for (Itemset l : this.tableFrequent.getLevelForZart(0)) {
                this.tableFrequent.mapClosed.put(l, true);
                if (l.getAbsoluteSupport() == database.getTransactions().size()) {
                    this.tableFrequent.mapKey.put(l, false);
                    fullCollumn = true;
                    continue;
                }
                this.tableFrequent.mapKey.put(l, true);
            }
            Itemset emptyset = new Itemset(new int[0]);
            if (fullCollumn) {
                this.frequentGeneratorsFG.add(emptyset);
            } else {
                this.tableFrequent.addFrequentItemset(emptyset);
                this.tableFrequent.mapClosed.put(emptyset, true);
                this.tableFrequent.mapPredSupp.put(emptyset, database.size());
                this.tableClosed.addClosedItemset(emptyset);
                this.tableClosed.mapGenerators.put(emptyset, new ArrayList());
                emptyset.setAbsoluteSupport(database.size());
            }
            int i = 1;
            while (true) {
                this.zartGen(i);
                if (this.tableCandidate.levels.get(i).size() == 0) break;
                if (this.tableCandidate.thereisARowKeyValueIsTrue(i)) {
                    for (List list : database.getTransactions()) {
                        for (Itemset s : this.subset(this.tableCandidate.levels.get(i), list)) {
                            if (!this.tableCandidate.mapKey.get(s).booleanValue()) continue;
                            s.increaseTransactionCount();
                        }
                    }
                }
                for (Itemset itemset : this.tableCandidate.levels.get(i)) {
                    if (itemset.getAbsoluteSupport() < this.minsupRelative) continue;
                    if (this.tableCandidate.mapKey.get(itemset).booleanValue() && itemset.getAbsoluteSupport() == this.tableCandidate.mapPredSupp.get(itemset).intValue()) {
                        this.tableCandidate.mapKey.put(itemset, false);
                    }
                    this.tableFrequent.addFrequentItemset(itemset);
                    this.tableFrequent.mapKey.put(itemset, this.tableCandidate.mapKey.get(itemset));
                    this.tableFrequent.mapPredSupp.put(itemset, this.tableCandidate.mapPredSupp.get(itemset));
                }
                for (Itemset itemset : this.tableFrequent.getLevelForZart(i)) {
                    this.tableFrequent.mapClosed.put(itemset, true);
                    for (Itemset s : this.subset(this.tableFrequent.getLevelForZart(i - 1), itemset)) {
                        if (s.getAbsoluteSupport() != itemset.getAbsoluteSupport()) continue;
                        this.tableFrequent.mapClosed.put(s, false);
                    }
                }
                this.tableClosed.levels.add(new ArrayList());
                for (Itemset itemset : this.tableFrequent.getLevelForZart(i - 1)) {
                    if (!this.tableFrequent.mapClosed.get(itemset).booleanValue()) continue;
                    this.tableClosed.getLevelForZart(i - 1).add(itemset);
                }
                this.findGenerators(this.tableClosed.getLevelForZart(i - 1), i);
                MemoryLogger.getInstance().checkMemory();
                ++i;
            }
            this.tableClosed.levels.add(new ArrayList());
            for (Itemset itemset : this.tableFrequent.getLevelForZart(i - 1)) {
                this.tableClosed.getLevelForZart(i - 1).add(itemset);
            }
            this.findGenerators(this.tableClosed.getLevelForZart(i - 1), i);
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return this.tableClosed;
    }

    private void findGenerators(List<Itemset> zi, int i) {
        for (Itemset z : zi) {
            List<Itemset> s = this.subset(this.frequentGeneratorsFG, z);
            this.tableClosed.mapGenerators.put(z, s);
            this.frequentGeneratorsFG.removeAll(s);
        }
        for (Itemset l : this.tableFrequent.getLevelForZart(i - 1)) {
            if (!this.tableFrequent.mapKey.get(l).booleanValue() || this.tableFrequent.mapClosed.get(l).booleanValue()) continue;
            this.frequentGeneratorsFG.add(l);
        }
    }

    private List<Itemset> subset(List<Itemset> s, Itemset l) {
        ArrayList<Itemset> retour = new ArrayList<Itemset>();
        for (Itemset itemsetS : s) {
            boolean allIncluded = true;
            int i = 0;
            while (i < itemsetS.size()) {
                if (!l.contains(itemsetS.get(i))) {
                    allIncluded = false;
                }
                ++i;
            }
            if (!allIncluded) continue;
            retour.add(itemsetS);
        }
        return retour;
    }

    private List<Itemset> subset(List<Itemset> s, List<Integer> l) {
        ArrayList<Itemset> subset = new ArrayList<Itemset>();
        for (Itemset itemsetS : s) {
            boolean allIncluded = true;
            int i = 0;
            while (i < itemsetS.size()) {
                if (!l.contains(itemsetS.get(i))) {
                    allIncluded = false;
                }
                ++i;
            }
            if (!allIncluded) continue;
            subset.add(itemsetS);
        }
        return subset;
    }

    private void zartGen(int i) {
        this.prepareCandidateSizeI(i);
        for (Itemset c : new ArrayList(this.tableCandidate.levels.get(i))) {
            this.tableCandidate.mapKey.put(c, true);
            this.tableCandidate.mapPredSupp.put(c, this.context.getTransactions().size() + 1);
            int j = 0;
            while (j < c.size()) {
                Itemset s = c.cloneItemSetMinusOneItem(c.get(j));
                boolean found = false;
                for (Itemset itemset2 : this.tableFrequent.getLevelForZart(i - 1)) {
                    if (!itemset2.isEqualTo(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.tableCandidate.levels.get(i).remove(c);
                } else {
                    Itemset occurenceS = this.getPreviousOccurenceOfItemset(s, this.tableCandidate.levels.get(i - 1));
                    if (occurenceS.getAbsoluteSupport() < this.tableCandidate.mapPredSupp.get(c)) {
                        this.tableCandidate.mapPredSupp.put(c, occurenceS.getAbsoluteSupport());
                    } else {
                        this.tableCandidate.mapPredSupp.put(c, this.tableCandidate.mapPredSupp.get(c));
                    }
                    if (!this.tableFrequent.mapKey.get(occurenceS).booleanValue()) {
                        this.tableCandidate.mapKey.put(c, false);
                    }
                }
                ++j;
            }
            if (this.tableCandidate.mapKey.get(c).booleanValue()) continue;
            c.setAbsoluteSupport(this.tableCandidate.mapPredSupp.get(c));
        }
    }

    private Itemset getPreviousOccurenceOfItemset(Itemset itemset, List<Itemset> list) {
        for (Itemset itemset2 : list) {
            if (!itemset2.isEqualTo(itemset)) continue;
            return itemset2;
        }
        return null;
    }

    protected void prepareCandidateSizeI(int size) {
        this.tableCandidate.levels.add(new ArrayList());
        for (Itemset itemset1 : this.tableFrequent.getLevelForZart(size - 1)) {
            for (Itemset itemset2 : this.tableFrequent.getLevelForZart(size - 1)) {
                Integer missing = itemset2.allTheSameExceptLastItem(itemset1);
                if (missing == null) continue;
                int[] union = new int[itemset1.size() + 1];
                System.arraycopy(itemset2.itemset, 0, union, 0, itemset2.size());
                union[itemset2.size()] = missing;
                this.tableCandidate.levels.get(size).add(new Itemset(union));
            }
        }
    }

    public TFTableFrequent getTableFrequent() {
        return this.tableFrequent;
    }

    public void printStatistics() {
        System.out.println("========== ZART - STATS ============");
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("=====================================");
    }

    public void saveResultsToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        writer.write("======= List of closed itemsets and their generators ============");
        writer.newLine();
        int i = 0;
        while (i < this.tableClosed.levels.size()) {
            for (Itemset closed : this.tableClosed.levels.get(i)) {
                writer.write(" CLOSED : \n   " + closed.toString() + " #SUP: " + closed.getAbsoluteSupport());
                writer.newLine();
                writer.write("   GENERATOR(S) :");
                writer.newLine();
                List<Itemset> generators = this.tableClosed.mapGenerators.get(closed);
                if (generators.size() == 0) {
                    writer.write("    " + closed.toString());
                    writer.newLine();
                    continue;
                }
                for (Itemset generator : generators) {
                    writer.write("     " + generator.toString());
                    writer.newLine();
                }
            }
            ++i;
        }
        writer.write("======= List of frequent itemsets ============");
        writer.newLine();
        i = 0;
        while (i < this.tableFrequent.levels.size()) {
            for (Itemset itemset : this.tableFrequent.levels.get(i)) {
                writer.write(" ITEMSET : " + itemset.toString() + " #SUP: " + itemset.getAbsoluteSupport());
                writer.newLine();
            }
            ++i;
        }
        writer.close();
    }
}

