/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Sequence {
    private List<Item> items;
    private int id;

    public Sequence(int id) {
        this.id = id;
        this.items = new ArrayList<Item>();
    }

    public Sequence(Sequence aSequence) {
        this.id = aSequence.id;
        this.items = new ArrayList<Item>();
        for (Item item : aSequence.getItems()) {
            this.items.add(new Item(item.val));
        }
    }

    public Sequence(int id, List<Item> items) {
        this.id = id;
        this.items = items != null ? items : new ArrayList();
    }

    public int getId() {
        return this.id;
    }

    public List<Item> getItems() {
        return this.items;
    }

    private void setItems(List<Item> newItems) {
        this.items = newItems;
    }

    public Item get(int index) {
        return this.items.get(index);
    }

    public int size() {
        return this.items.size();
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public Sequence getLastItems(int length, int offset) {
        Sequence truncatedSequence = new Sequence(0);
        int size = this.size() - offset;
        if (this.items.isEmpty()) {
            return null;
        }
        if (length > size) {
            ArrayList<Item> truncatedList = new ArrayList<Item>(this.items.subList(0, size));
            truncatedSequence.setItems(truncatedList);
        } else {
            ArrayList<Item> truncatedList = new ArrayList<Item>(this.items.subList(size - length, size));
            truncatedSequence.setItems(truncatedList);
        }
        return truncatedSequence;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuffer r = new StringBuffer("");
        for (Item it : this.items) {
            r.append('(');
            String string = it.toString();
            r.append(string);
            r.append(") ");
        }
        return r.append("    ").toString();
    }

    public void setID(int newid) {
        this.id = newid;
    }

    public Sequence clone() {
        Sequence copy = new Sequence(this.id);
        for (Item item : this.items) {
            copy.items.add(item.clone());
        }
        return copy;
    }

    public boolean equals(Object obj) {
        Sequence other = (Sequence)obj;
        return this.equals(other);
    }

    public boolean equals(Sequence other) {
        if (this.id != other.id || this.items.size() != other.items.size()) {
            return false;
        }
        int i = 0;
        while (i < this.items.size()) {
            if (!this.items.get(i).equals(other.items.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + this.items.hashCode();
        return result;
    }

    public static void main(String ... args) {
        Sequence a = new Sequence(-1);
        a.addItem(new Item(1));
        a.addItem(new Item(2));
        a.addItem(new Item(3));
        Sequence b = new Sequence(-1);
        b.addItem(new Item(1));
        b.addItem(new Item(2));
        b.addItem(new Item(3));
        Sequence c = b.clone();
        System.out.println(a.hashCode());
        System.out.println(b.hashCode());
        System.out.println(c.hashCode());
        HashSet<Sequence> seen = new HashSet<Sequence>();
        seen.add(b);
        if (seen.contains(a)) {
            System.out.println("Seen a");
        }
        if (seen.contains(b)) {
            System.out.println("Seen b (obviously)");
        }
        if (seen.contains(c)) {
            System.out.println("Seen c");
        }
        if (b.equals(a)) {
            System.out.println("a == b");
        }
        if (b.equals(c)) {
            System.out.println("b == c");
        }
    }
}

