/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.profile.Profile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SequenceDatabase {
    private List<Sequence> sequences = new ArrayList<Sequence>();

    public void setSequences(List<Sequence> newSequences) {
        this.sequences = new ArrayList<Sequence>(newSequences);
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public int size() {
        return this.sequences.size();
    }

    public void clear() {
        this.sequences.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFileCustomFormat(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader reader = null;){
            try {
                reader = new BufferedReader(new FileReader(filepath));
                int count = 0;
                block5: while (true) {
                    String line = reader.readLine();
                    if (line == null) return;
                    if (count >= maxCount) {
                        return;
                    }
                    String[] split = line.split(" ");
                    if (split.length < minSize || split.length > maxSize) continue;
                    Sequence sequence = new Sequence(-1);
                    String[] stringArray = split;
                    int n = split.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            this.sequences.add(sequence);
                            ++count;
                            continue block5;
                        }
                        String value = stringArray[n2];
                        Item item = new Item(Integer.valueOf(value));
                        sequence.addItem(item);
                        ++n2;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (reader == null) return;
                reader.close();
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFileBMSFormat(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                FileInputStream fin = new FileInputStream(new File(filepath));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int lastId = 0;
                int count = 0;
                Sequence sequence = null;
                while (true) {
                    String thisLine = myInput.readLine();
                    if (thisLine == null) return;
                    if (count >= maxCount) {
                        return;
                    }
                    String[] split = thisLine.split(" ");
                    int id = Integer.parseInt(split[0]);
                    int val = Integer.parseInt(split[1]);
                    if (lastId != id) {
                        if (lastId != 0 && sequence.size() >= minSize && sequence.size() <= maxSize) {
                            this.sequences.add(sequence);
                            ++count;
                        }
                        sequence = new Sequence(id);
                        lastId = id;
                    }
                    Item item = new Item(val);
                    sequence.addItem(item);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput == null) return;
                myInput.close();
                return;
            }
        }
    }

    public void loadFileFIFAFormat(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(filepath));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int i = 0;
                while ((thisLine = myInput.readLine()) != null) {
                    String[] split = thisLine.split(" ");
                    if (maxCount == i) {
                        break;
                    }
                    if (split.length < minSize || split.length > maxSize) continue;
                    Sequence sequence = new Sequence(-1);
                    HashSet<Integer> alreadySeen = new HashSet<Integer>();
                    int lastValue = -1;
                    String[] stringArray = split;
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block17: {
                            int intVal;
                            block18: {
                                block16: {
                                    String value = stringArray[n2];
                                    intVal = Integer.valueOf(value);
                                    if (Profile.paramInt("removeDuplicatesMethod") != 2) break block16;
                                    if (alreadySeen.contains(intVal)) break block17;
                                    alreadySeen.add(intVal);
                                    break block18;
                                }
                                if (Profile.paramInt("removeDuplicatesMethod") != 1) break block18;
                                if (lastValue == intVal) break block17;
                                lastValue = intVal;
                            }
                            Item item = new Item(intVal);
                            sequence.addItem(item);
                        }
                        ++n2;
                    }
                    ++i;
                    this.sequences.add(sequence);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    public void loadFileMsnbsFormat(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(filepath));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int i = 0;
                while ((thisLine = myInput.readLine()) != null) {
                    HashSet<Integer> alreadySeen = new HashSet<Integer>();
                    String[] split = thisLine.trim().split(" ");
                    if (maxCount == i) {
                        break;
                    }
                    Sequence sequence = new Sequence(-1);
                    int lastValue = 0;
                    String[] stringArray = split;
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block17: {
                            int value;
                            block18: {
                                block16: {
                                    String val = stringArray[n2];
                                    value = Integer.valueOf(val);
                                    if (Profile.paramInt("removeDuplicatesMethod") != 2) break block16;
                                    if (alreadySeen.contains(value)) break block17;
                                    alreadySeen.add(value);
                                    break block18;
                                }
                                if (Profile.paramInt("removeDuplicatesMethod") != 1) break block18;
                                if (lastValue == value) break block17;
                                lastValue = value;
                            }
                            sequence.addItem(new Item(value));
                        }
                        ++n2;
                    }
                    if (sequence.size() < minSize || sequence.size() > maxSize) continue;
                    this.sequences.add(sequence);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    public void loadFileLargeTextFormatAsCharacter(String filepath, int maxCount, int minSize, int maxSize) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(filepath));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int i = 0;
                while ((thisLine = myInput.readLine()) != null) {
                    if (maxCount == i) {
                        break;
                    }
                    if (thisLine.length() < minSize || thisLine.length() > maxSize) continue;
                    Sequence sequence = new Sequence(-1);
                    int k = 0;
                    while (k < thisLine.length()) {
                        char value = thisLine.charAt(k);
                        sequence.addItem(new Item(Integer.valueOf(value)));
                        ++k;
                    }
                    ++i;
                    this.sequences.add(sequence);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    public void loadFileLargeTextFormatAsWords(String filepath, int maxCount, int minSize, int maxSize, boolean doNotAllowSentenceToContinueOnNextLine) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(filepath));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int seqCount = 0;
                int lastWordID = 1;
                HashMap<String, Integer> mapWordToID = new HashMap<String, Integer>();
                Sequence sequence = new Sequence(-1);
                while ((thisLine = myInput.readLine()) != null) {
                    if (maxCount == seqCount) {
                        break;
                    }
                    StringBuffer modifiedLine = new StringBuffer(thisLine.length());
                    int i = 0;
                    while (i < thisLine.length()) {
                        char currentChar = thisLine.charAt(i);
                        if (Character.isLetter(currentChar) || currentChar == '.' || currentChar == '?' || currentChar == ':' || currentChar == ' ') {
                            modifiedLine.append(currentChar);
                        }
                        ++i;
                    }
                    String[] split = modifiedLine.toString().split(" ");
                    int i2 = 0;
                    while (i2 < split.length) {
                        Integer itemID;
                        boolean containsPunctuation;
                        String token = split[i2];
                        boolean bl = containsPunctuation = token.contains(".") || token.contains("?") || token.contains(":");
                        if (containsPunctuation) {
                            ++seqCount;
                            if (containsPunctuation || i2 == split.length - 1 && doNotAllowSentenceToContinueOnNextLine) {
                                token = token.substring(0, token.length() - 1);
                            }
                            if ((itemID = (Integer)mapWordToID.get(token)) == null) {
                                itemID = lastWordID++;
                                mapWordToID.put(token, itemID);
                            }
                            sequence.addItem(new Item(itemID));
                            if (sequence.size() >= minSize && sequence.size() <= maxSize) {
                                this.sequences.add(sequence);
                            }
                            sequence = new Sequence(-1);
                        } else {
                            itemID = (Integer)mapWordToID.get(token);
                            if (itemID == null) {
                                itemID = lastWordID++;
                                mapWordToID.put(token, itemID);
                            }
                            sequence.addItem(new Item(itemID));
                        }
                        ++i2;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    public void loadFileSignLanguage(String fileToPath, int maxCount, int minsize, int maxsize) {
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(fileToPath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            String oldUtterance = "-1";
            Sequence sequence = null;
            int count = 0;
            HashSet<Integer> alreadySeen = new HashSet<Integer>();
            int id = 0;
            int lastValue = -1;
            while ((thisLine = myInput.readLine()) != null) {
                block11: {
                    if (thisLine.length() < 1 || thisLine.charAt(0) == '#') break block11;
                    String[] tokens = thisLine.split(" ");
                    String currentUtterance = tokens[0];
                    if (!currentUtterance.equals(oldUtterance)) {
                        if (sequence != null && sequence.size() >= minsize && sequence.size() <= maxsize) {
                            this.sequences.add(sequence);
                            ++count;
                        }
                        sequence = new Sequence(id++);
                        alreadySeen = new HashSet();
                        oldUtterance = currentUtterance;
                    }
                    int j = 1;
                    while (j < tokens.length) {
                        block12: {
                            int character;
                            block14: {
                                block13: {
                                    character = Integer.parseInt(tokens[j]);
                                    if (character == -11 || character == -12) break block12;
                                    if (Profile.paramInt("removeDuplicatesMethod") != 2) break block13;
                                    if (alreadySeen.contains(character)) break block12;
                                    alreadySeen.add(character);
                                    break block14;
                                }
                                if (Profile.paramInt("removeDuplicatesMethod") != 1) break block14;
                                if (lastValue == character) break block12;
                                lastValue = character;
                            }
                            sequence.getItems().add(new Item(character));
                        }
                        ++j;
                    }
                }
                if (maxCount == count) break;
            }
            if (sequence.size() >= minsize && sequence.size() <= maxsize) {
                this.sequences.add(sequence);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFileSPMFFormat(String path, int maxCount, int minSize, int maxSize) {
        BufferedReader myInput = null;
        try {
            String thisLine;
            int count = 0;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null && count < maxCount) {
                Sequence sequence = new Sequence(this.sequences.size());
                String[] stringArray = thisLine.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String entier = stringArray[n2];
                    if (!entier.equals("-1")) {
                        if (entier.equals("-2")) {
                            if (sequence.size() >= minSize && sequence.size() <= maxSize) {
                                this.sequences.add(sequence);
                                ++count;
                            }
                        } else {
                            int val = Integer.parseInt(entier);
                            sequence.getItems().add(new Item(val));
                        }
                    }
                    ++n2;
                }
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSnakeDataset(String filepath, int nbLine, int minSize, int maxSize) {
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(filepath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.length() < 50) continue;
                Sequence sequence = new Sequence(this.sequences.size());
                int i = 0;
                while (i < thisLine.length()) {
                    int character = thisLine.toCharArray()[i] - 65;
                    sequence.addItem(new Item(character));
                    ++i;
                }
                if (sequence.size() >= minSize && sequence.size() <= maxSize) {
                    this.sequences.add(sequence);
                }
                this.sequences.add(sequence);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

