/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.SequenceDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SequenceStatsGenerator {
    public static void prinStats(SequenceDatabase database, String name) throws IOException {
        System.out.println("---" + name + "---");
        System.out.println("Number of sequences : \t" + database.size());
        int maxItem = 0;
        HashSet<Integer> items = new HashSet<Integer>();
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        ArrayList<Integer> differentitems = new ArrayList<Integer>();
        ArrayList<Integer> appearXtimesbySequence = new ArrayList<Integer>();
        for (Sequence sequence : database.getSequences()) {
            sizes.add(sequence.size());
            HashMap<Integer, Integer> mapIntegers = new HashMap<Integer, Integer>();
            for (Item item : sequence.getItems()) {
                Integer count = (Integer)mapIntegers.get(item.val);
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                mapIntegers.put(item.val, count);
                items.add(item.val);
                if (item.val <= maxItem) continue;
                maxItem = item.val;
            }
            differentitems.add(mapIntegers.entrySet().size());
            for (Map.Entry entry : mapIntegers.entrySet()) {
                appearXtimesbySequence.add((Integer)entry.getValue());
            }
        }
        System.out.println("Number of distinct items: \t" + items.size());
        System.out.println("Largest item id: \t" + maxItem);
        System.out.println("Itemsets per sequence: \t" + SequenceStatsGenerator.calculateMean(sizes));
        System.out.println("Distinct item per sequence: \t" + SequenceStatsGenerator.calculateMean(differentitems));
        System.out.println("Occurences for each item: \t" + SequenceStatsGenerator.calculateMean(appearXtimesbySequence));
        System.out.println("Size of the dataset in MB: \t" + ((double)database.size() * 4.0 + (double)database.size() * SequenceStatsGenerator.calculateMean(sizes) * 4.0 / 1000000.0));
        System.out.println();
    }

    private static double calculateMean(List<Integer> list) {
        double sum = 0.0;
        for (Integer val : list) {
            sum += (double)val.intValue();
        }
        return sum / (double)list.size();
    }

    private static double calculateStdDeviation(List<Integer> list) {
        double deviation = 0.0;
        double mean = SequenceStatsGenerator.calculateMean(list);
        for (Integer val : list) {
            deviation += Math.pow(mean - (double)val.intValue(), 2.0);
        }
        return Math.sqrt(deviation / (double)list.size());
    }

    private static double calculateMeanD(List<Double> list) {
        double sum = 0.0;
        for (Double val : list) {
            sum += val.doubleValue();
        }
        return sum / (double)list.size();
    }

    private static double calculateStdDeviationD(List<Double> list) {
        double deviation = 0.0;
        double mean = SequenceStatsGenerator.calculateMeanD(list);
        for (Double val : list) {
            deviation += Math.pow(mean - val, 2.0);
        }
        return Math.sqrt(deviation / (double)list.size());
    }

    private static double calculateVariance(List<Integer> list) {
        double deviation = 0.0;
        double mean = SequenceStatsGenerator.calculateMean(list);
        for (Integer val : list) {
            deviation += Math.pow(mean - (double)val.intValue(), 2.0);
        }
        return Math.pow(Math.sqrt(deviation / (double)list.size()), 2.0);
    }

    private static int calculateMinValue(List<Integer> list) {
        int min = Integer.MIN_VALUE;
        for (Integer val : list) {
            if (val > min) continue;
            min = val;
        }
        return min;
    }

    private static int calculateMaxValue(List<Integer> list) {
        int max = 0;
        for (Integer val : list) {
            if (val < max) continue;
            max = val;
        }
        return max;
    }
}

