/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Encoder {
    protected List<List<Item>> Dict = new ArrayList<List<Item>>();
    protected HashMap<List<Item>, Integer> InvDict = new HashMap();

    public int addEntry(List<Item> entry) {
        Integer id = this.getId(entry);
        if (id == null) {
            this.Dict.add(entry);
            id = this.Dict.size() - 1;
            this.InvDict.put(entry, id);
        }
        return id;
    }

    public List<Item> getEntry(int id) {
        return this.Dict.get(id);
    }

    public Integer getId(List<Item> entry) {
        Integer id = this.InvDict.get(entry);
        return id;
    }

    public Integer getIdorAdd(List<Item> entry) {
        return this.addEntry(entry);
    }

    public Sequence encode(Sequence seq) {
        if (seq == null || seq.getItems().size() == 0) {
            return seq;
        }
        Sequence encoded = new Sequence(seq.getId());
        int seqSize = seq.getItems().size();
        int i = 0;
        while (i < seqSize) {
            LinkedList<Item> candidate = new LinkedList<Item>(seq.getItems().subList(i, seqSize));
            Integer idFound = null;
            while (idFound == null && candidate.size() > 0) {
                idFound = this.getId(candidate);
                if (idFound != null) {
                    encoded.addItem(new Item(idFound));
                    i += candidate.size() - 1;
                    continue;
                }
                if (candidate.size() == 1) {
                    idFound = this.addEntry(candidate);
                    encoded.addItem(new Item(idFound));
                    continue;
                }
                candidate.removeLast();
            }
            ++i;
        }
        return encoded;
    }

    public Sequence decode(Sequence seq) {
        if (seq == null || seq.getItems().size() == 0) {
            return seq;
        }
        Sequence decoded = new Sequence(seq.getId());
        for (Item encodedItem : seq.getItems()) {
            List<Item> itemset = this.getEntry(encodedItem.val);
            if (itemset != null) {
                for (Item decodedItem : itemset) {
                    decoded.addItem(decodedItem);
                }
                continue;
            }
            System.err.println("Could not find item: " + encodedItem.val);
        }
        return decoded;
    }

    public static void main(String ... args) {
        Encoder en = new Encoder();
        LinkedList<Item> p1 = new LinkedList<Item>();
        p1.add(new Item(42));
        p1.add(new Item(43));
        LinkedList<Item> p2 = new LinkedList<Item>();
        p2.add(new Item(42));
        LinkedList<Item> p3 = new LinkedList<Item>();
        p3.add(new Item(42));
        p3.add(new Item(43));
        p3.add(new Item(44));
        Sequence seq1 = new Sequence(-1);
        seq1.addItem(new Item(42));
        seq1.addItem(new Item(43));
        seq1.addItem(new Item(44));
        seq1.addItem(new Item(45));
        en.addEntry(p1);
        en.addEntry(p2);
        en.addEntry(p3);
        Sequence encoded = en.encode(seq1);
        System.out.println(seq1);
        System.out.println(encoded);
        System.out.println(en.decode(encoded));
    }
}

