/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.Bitvector;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.FIF;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FIFPrefixSpan
implements FIF {
    public List<List<Item>> results;

    @Override
    public List<List<Item>> findFrequentItemsets(List<Sequence> seqs, int minLength, int maxlength, int minSup) {
        this.results = new ArrayList<List<Item>>();
        LinkedList toProcess = new LinkedList();
        Projection projection = new Projection();
        projection.initialize(seqs);
        HashMap<Item, Integer> oneItemCandidates = projection.initialize(seqs);
        for (Map.Entry<Item, Integer> entry : oneItemCandidates.entrySet()) {
            if (entry.getValue() < minSup) continue;
            ArrayList<Item> candidate = new ArrayList<Item>();
            candidate.add(entry.getKey());
            toProcess.add(candidate);
            this.results.add(candidate);
        }
        List itemset = null;
        while ((itemset = (List)toProcess.poll()) != null) {
            HashMap<Item, Integer> itemCandidates = projection.projectAndSelect(itemset);
            for (Map.Entry<Item, Integer> item : itemCandidates.entrySet()) {
                if (item.getValue() < minSup) continue;
                ArrayList<Item> candidate = new ArrayList<Item>(itemset);
                candidate.add(item.getKey());
                toProcess.add(candidate);
                this.results.add(candidate);
            }
        }
        return this.results;
    }

    public List<Item> select(HashMap<Item, Integer> frequencies, int minSup) {
        ArrayList<Item> frequents = new ArrayList<Item>();
        for (Map.Entry<Item, Integer> pair : frequencies.entrySet()) {
            if (pair.getValue() < minSup) continue;
            frequents.add(pair.getKey());
        }
        return frequents;
    }

    public static void main(String ... args) {
        ArrayList<Sequence> training = new ArrayList<Sequence>();
        Sequence seq1 = new Sequence(-1);
        seq1.addItem(new Item(1));
        seq1.addItem(new Item(2));
        seq1.addItem(new Item(3));
        seq1.addItem(new Item(4));
        training.add(seq1);
        Sequence seq2 = new Sequence(-1);
        seq2.addItem(new Item(1));
        seq2.addItem(new Item(2));
        seq2.addItem(new Item(3));
        seq2.addItem(new Item(4));
        training.add(seq2);
        Sequence seq3 = new Sequence(-1);
        seq3.addItem(new Item(1));
        seq3.addItem(new Item(2));
        seq3.addItem(new Item(3));
        seq3.addItem(new Item(4));
        training.add(seq3);
        Sequence seq4 = new Sequence(-1);
        seq4.addItem(new Item(0));
        seq4.addItem(new Item(1));
        seq4.addItem(new Item(2));
        seq4.addItem(new Item(4));
        training.add(seq4);
        FIFPrefixSpan finder = new FIFPrefixSpan();
        Projection proj = finder.new Projection();
        List<List<Item>> frequentItemsets = finder.findFrequentItemsets(training, 1, 5, 2);
        System.out.println(frequentItemsets);
    }

    @Override
    public HashMap<Item, Integer> getItemFrequencies(List<Sequence> seqs) {
        return null;
    }

    public class Projection {
        private List<Sequence> seqs;
        private Map<Integer, Bitvector> II = new HashMap<Integer, Bitvector>();

        public HashMap<Item, Integer> initialize(List<Sequence> sequences) {
            this.seqs = sequences;
            HashMap<Item, Integer> frequencies = new HashMap<Item, Integer>();
            int id = 0;
            for (Sequence seq : sequences) {
                for (Item item : seq.getItems()) {
                    Bitvector vector = this.II.get(item.val);
                    if (vector == null) {
                        vector = new Bitvector();
                    }
                    vector.setBit(id);
                    this.II.put(item.val, vector);
                    Integer support = frequencies.get(item);
                    if (support == null) {
                        support = 0;
                    }
                    frequencies.put(item, support + 1);
                }
                ++id;
            }
            return frequencies;
        }

        public HashMap<Item, Integer> projectAndSelect(List<Item> prefix) {
            Bitvector intersection = null;
            for (Item item : prefix) {
                if (intersection != null) {
                    intersection.and(this.II.get(item.val));
                    continue;
                }
                intersection = (Bitvector)this.II.get(item.val).clone();
            }
            HashMap<Item, Integer> frequencies = new HashMap<Item, Integer>();
            int id = intersection.nextSetBit(0);
            while (id >= 0) {
                Sequence seq = this.seqs.get(id);
                Item item = this.getSuffix(seq, prefix);
                if (item != null) {
                    Integer support = frequencies.get(item);
                    if (support == null) {
                        support = 0;
                    }
                    frequencies.put(item, support + 1);
                }
                id = intersection.nextSetBit(id + 1);
            }
            return frequencies;
        }

        protected Item getSuffix(Sequence seq, List<Item> prefix) {
            if (prefix.size() == 0) {
                return seq.get(0);
            }
            int offsetPrefix = 0;
            int offsetSeq = 0;
            while (offsetSeq < seq.size()) {
                if (seq.get(offsetSeq).equals(prefix.get(offsetPrefix)) && ++offsetPrefix >= prefix.size()) {
                    if (offsetSeq >= seq.size() - 1) {
                        return null;
                    }
                    return seq.get(offsetSeq + 1);
                }
                ++offsetSeq;
            }
            return null;
        }
    }
}

