/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPattern;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoFEAT {
    long startTime;
    long endTime;
    public int minsuppRelative;
    private List<SequentialPattern> generators = null;
    private int maximumPatternLength = Integer.MAX_VALUE;
    public int prefixPrunedCount = 0;
    boolean DEBUG_MODE = false;
    List<PseudoSequence> initialDatabase = null;
    boolean performPruning = true;
    boolean showSequenceIdentifiers = false;

    public List<SequentialPattern> runAlgorithm(SequenceDatabase database, double minsupPercent) throws IOException {
        this.minsuppRelative = (int)Math.ceil(minsupPercent * (double)database.size());
        if (this.minsuppRelative == 0) {
            this.minsuppRelative = 1;
        }
        if (this.DEBUG_MODE) {
            System.out.println(" %%%%%%%%%%  DEBUG MODE %%%%%%%%%%");
            System.out.println("minsup = " + this.minsuppRelative);
        }
        this.startTime = System.currentTimeMillis();
        this.feat(database);
        this.endTime = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            for (SequentialPattern pat1 : this.generators) {
                if (pat1.size() > 0 && pat1.getAbsoluteSupport() == database.size()) {
                    System.out.println("NOT A GENERATOR !!!!!!!!!  " + pat1 + "    sup: " + pat1.getAbsoluteSupport() + " because of empty set");
                }
                for (SequentialPattern pat2 : this.generators) {
                    if (pat1 == pat2 || pat1.getAbsoluteSupport() != pat2.getAbsoluteSupport() || !this.strictlyContains(pat1, pat2)) continue;
                    System.out.println("NOT A GENERATOR !!!!!!!!!  " + pat1 + " " + pat2 + "   sup: " + pat1.getAbsoluteSupport());
                    System.out.println(String.valueOf(pat1.getAbsoluteSupport()) + " " + pat2.getAbsoluteSupport());
                }
            }
            for (SequentialPattern pattern : this.generators) {
                System.out.println(pattern + " #SUP: " + pattern.getAbsoluteSupport());
            }
        }
        return this.generators;
    }

    public List<SequentialPattern> runAlgorithm(SequenceDatabase database, int minsup) throws IOException {
        if (this.DEBUG_MODE) {
            System.out.println(" %%%%%%%%%%  DEBUG MODE %%%%%%%%%%");
        }
        MemoryLogger.getInstance().reset();
        this.minsuppRelative = minsup;
        this.startTime = System.currentTimeMillis();
        this.feat(database);
        this.endTime = System.currentTimeMillis();
        return this.generators;
    }

    public long getPatternCount() {
        return this.generators.size();
    }

    boolean strictlyContains(SequentialPattern pattern1, SequentialPattern pattern2) {
        int i = 0;
        int j = 0;
        do {
            if (pattern1.get(j).containsAll(pattern2.get(i)) && ++i == pattern2.size()) {
                return true;
            }
            if (++j < pattern1.size()) continue;
            return false;
        } while (pattern1.size() - j >= pattern2.size() - i);
        return false;
    }

    private void feat(SequenceDatabase database) throws IOException {
        this.generators = new ArrayList<SequentialPattern>();
        Map<Integer, Set<Integer>> mapSequenceID = this.findSequencesContainingItems(database);
        this.initialDatabase = new ArrayList<PseudoSequence>();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsuppRelative);
            if (optimizedSequence.size() == 0) continue;
            this.initialDatabase.add(new PseudoSequence(optimizedSequence, 0, 0));
        }
        for (Map.Entry entry : mapSequenceID.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsuppRelative) continue;
            Integer item = (Integer)entry.getKey();
            SequentialPattern prefix = new SequentialPattern();
            prefix.addItemset(new Itemset(item));
            prefix.setSequenceIDs((Set)entry.getValue());
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabaseForSingleItem(item, this.initialDatabase, (Set)entry.getValue());
            boolean canPrune = false;
            boolean isGenerator = true;
            if (this.initialDatabase.size() == ((Set)entry.getValue()).size()) {
                canPrune = this.checkforwardPruningFor1ItemSequence(item, projectedDatabase);
                isGenerator = false;
            }
            if (isGenerator) {
                this.savePattern(prefix);
            }
            if (!(this.performPruning && canPrune || this.maximumPatternLength <= 1)) {
                this.featRecursion(prefix, projectedDatabase, 2);
                continue;
            }
            ++this.prefixPrunedCount;
        }
    }

    private boolean checkforwardPruningFor1ItemSequence(Integer item, List<PseudoSequence> projectedDatabase) {
        for (PseudoSequence seq : projectedDatabase) {
            Integer firstItem = seq.getOriginalSequence().get(0).get(0);
            if (firstItem.equals(item)) continue;
            return false;
        }
        return true;
    }

    private void savePattern(SequentialPattern prefix) throws IOException {
        this.generators.add(prefix);
    }

    private Map<Integer, Set<Integer>> findSequencesContainingItems(SequenceDatabase database) {
        HashMap<Integer, Set<Integer>> mapSequenceID = new HashMap<Integer, Set<Integer>>();
        for (Sequence sequence : database.getSequences()) {
            for (List<Integer> itemset : sequence.getItemsets()) {
                for (Integer item : itemset) {
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private List<PseudoSequence> buildProjectedDatabaseForSingleItem(Integer item, List<PseudoSequence> initialDatabase, Set<Integer> sidSet) {
        ArrayList<PseudoSequence> sequenceDatabase = new ArrayList<PseudoSequence>();
        for (PseudoSequence sequence : initialDatabase) {
            if (!sidSet.contains(sequence.getId())) continue;
            int i = 0;
            while (i < sequence.size()) {
                int index = sequence.indexOfBis(i, item);
                if (index != -1) {
                    if (index == sequence.getSizeOfItemsetAt(i) - 1) {
                        if (i != sequence.size() - 1) {
                            sequenceDatabase.add(new PseudoSequence(sequence, i + 1, 0));
                        }
                    } else {
                        sequenceDatabase.add(new PseudoSequence(sequence, i, index + 1));
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private PairSequences buildProjectedDatabase(Integer item, List<PseudoSequence> database, Set<Integer> sidset, boolean inPostFix) {
        PairSequences sequenceDatabase = new PairSequences();
        for (PseudoSequence sequence : database) {
            if (!sidset.contains(sequence.getId())) continue;
            int i = 0;
            while (i < sequence.size()) {
                int index;
                if (sequence.isPostfix(i) == inPostFix && (index = sequence.indexOfBis(i, item)) != -1) {
                    if (index == sequence.getSizeOfItemsetAt(i) - 1) {
                        if (i != sequence.size() - 1) {
                            sequenceDatabase.newSequences.add(new PseudoSequence(sequence, i + 1, 0));
                            sequenceDatabase.olderSequences.add(sequence);
                        }
                    } else {
                        sequenceDatabase.newSequences.add(new PseudoSequence(sequence, i, index + 1));
                        sequenceDatabase.olderSequences.add(sequence);
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private void featRecursion(SequentialPattern prefix, List<PseudoSequence> database, int k) throws IOException {
        Set<Pair> pairs = this.findAllFrequentPairs(database);
        for (Pair pair : pairs) {
            if (pair.getCount() < this.minsuppRelative) continue;
            SequentialPattern newPrefix = pair.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, pair.getItem()) : this.appendItemToSequence(prefix, pair.getItem());
            newPrefix.setSequenceIDs(pair.getSequenceIDs());
            PairSequences projectedDatabase = this.buildProjectedDatabase(pair.getItem(), database, pair.getSequenceIDs(), pair.isPostfix());
            boolean canPrune = false;
            boolean isGenerator = true;
            if (prefix.getAbsoluteSupport() == pair.getSequenceIDs().size()) {
                canPrune = this.checkForwardPruningGeneralCase(projectedDatabase, pair.getItem(), pair.isPostfix());
                isGenerator = false;
            }
            if (!canPrune) {
                Boolean[] returnValues = this.checkBackwardPruning(newPrefix, projectedDatabase.newSequences, isGenerator);
                isGenerator = returnValues[0];
                canPrune = returnValues[1];
            }
            if (isGenerator) {
                this.savePattern(newPrefix);
            }
            if (!(this.performPruning && canPrune || k >= this.maximumPatternLength)) {
                this.featRecursion(newPrefix, projectedDatabase.newSequences, k + 1);
                continue;
            }
            ++this.prefixPrunedCount;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private Boolean[] checkBackwardPruning(SequentialPattern newPrefix, List<PseudoSequence> projectedDatabase, boolean isGeneratorParameter) {
        boolean isGenerator = isGeneratorParameter;
        boolean canPrune = false;
        int prefixTotalSize = newPrefix.getItemOccurencesTotalCount();
        int j = 1;
        block0: while (j < prefixTotalSize) {
            ArrayList<List<Integer>> prefixTruncated = new ArrayList<List<Integer>>();
            int itemCounter = j;
            block1: for (Itemset itemsetPrefix : newPrefix.getItemsets()) {
                ArrayList<Integer> newItemset = new ArrayList<Integer>();
                prefixTruncated.add(newItemset);
                for (Integer currentItem : itemsetPrefix.getItems()) {
                    newItemset.add(currentItem);
                    if (--itemCounter < 0) break block1;
                }
            }
            int i = 0;
            while (i < j) {
                int supCount = 0;
                boolean localCanPrune = true;
                int seqRemaining = this.initialDatabase.size();
                for (PseudoSequence originalSequence : this.initialDatabase) {
                    --seqRemaining;
                    ProjectionEnum result = this.sameProjection(originalSequence, prefixTruncated, i);
                    if (result.equals((Object)ProjectionEnum.SAME_PROJECTION) || result.equals((Object)ProjectionEnum.CONTAIN_PREFIX_WITHOUT_I)) {
                        ++supCount;
                    }
                    if (result.equals((Object)ProjectionEnum.SAME_PROJECTION) || result.equals((Object)ProjectionEnum.SAME_PROJECTION_NOT_CONTAINED_IN)) continue;
                    localCanPrune = false;
                    if (!isGenerator || supCount + seqRemaining < newPrefix.getAbsoluteSupport()) break;
                }
                if (localCanPrune && (canPrune = true) && !isGenerator) break block0;
                if (supCount == newPrefix.getAbsoluteSupport()) {
                    isGenerator = false;
                }
                ++i;
            }
            ++j;
        }
        Boolean[] returnValues = new Boolean[]{isGenerator, canPrune};
        return returnValues;
    }

    private ProjectionEnum sameProjection(PseudoSequence originalSequence, List<List<Integer>> prefix, int i) {
        int projectionWithoutI = -1;
        int itemsetPos = 0;
        Integer itemI = null;
        if (i < prefix.get(itemsetPos).size()) {
            if (prefix.get(itemsetPos).size() == 1) {
                ++itemsetPos;
                --i;
            } else {
                itemI = prefix.get(itemsetPos).get(i);
            }
        }
        int k = 0;
        while (k < originalSequence.size()) {
            List<Integer> itemsetSequence = originalSequence.getItemset(k);
            boolean contained = true;
            for (Integer item : prefix.get(itemsetPos)) {
                if (item == itemI || itemsetSequence.contains(item)) continue;
                contained = false;
                break;
            }
            if (contained) {
                i -= prefix.get(itemsetPos).size();
                if (++itemsetPos == prefix.size()) {
                    projectionWithoutI = k;
                    break;
                }
                itemI = null;
                if (i < prefix.get(itemsetPos).size() && i >= 0) {
                    if (prefix.get(itemsetPos).size() == 1) {
                        ++itemsetPos;
                        --i;
                    } else {
                        itemI = prefix.get(itemsetPos).get(i);
                    }
                }
            }
            ++k;
        }
        int projectionWithI = -1;
        itemsetPos = 0;
        int k2 = 0;
        while (k2 < originalSequence.size()) {
            List<Integer> itemsetSequence = originalSequence.getItemset(k2);
            boolean contained = true;
            for (Integer item : prefix.get(itemsetPos)) {
                if (itemsetSequence.contains(item)) continue;
                contained = false;
                break;
            }
            if (contained && ++itemsetPos == prefix.size()) {
                projectionWithI = k2;
                break;
            }
            ++k2;
        }
        if (projectionWithI == projectionWithoutI) {
            if (projectionWithI > 0) {
                return ProjectionEnum.SAME_PROJECTION;
            }
            return ProjectionEnum.SAME_PROJECTION_NOT_CONTAINED_IN;
        }
        if (projectionWithoutI >= 0) {
            return ProjectionEnum.CONTAIN_PREFIX_WITHOUT_I;
        }
        return null;
    }

    private boolean checkForwardPruningGeneralCase(PairSequences projectedDatabase, Integer item, boolean postfix) {
        int i = 0;
        while (i < projectedDatabase.newSequences.size()) {
            PseudoSequence seq = projectedDatabase.newSequences.get(i);
            PseudoSequence seqProjected = projectedDatabase.olderSequences.get(i);
            Integer firstItem = seq.getItemAtInItemsetAt(0, 0);
            if (!firstItem.equals(item)) {
                return false;
            }
            int itemPos = seq.firstItem + 1;
            int itemsetPos = seq.firstItemset;
            if (seq.getSizeOfItemsetAt(0) == itemPos) {
                itemPos = 0;
                ++itemsetPos;
            }
            if (seqProjected.firstItem != itemPos || seqProjected.firstItemset != itemsetPos) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Set<Pair> findAllFrequentPairs(List<PseudoSequence> sequences) {
        HashMap<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        for (PseudoSequence sequence : sequences) {
            int i = 0;
            while (i < sequence.size()) {
                int j = 0;
                while (j < sequence.getSizeOfItemsetAt(i)) {
                    Integer item = sequence.getItemAtInItemsetAt(j, i);
                    Pair pair = new Pair(sequence.isPostfix(i), item);
                    Pair oldPair = (Pair)mapPairs.get(pair);
                    if (oldPair == null) {
                        mapPairs.put(pair, pair);
                    } else {
                        pair = oldPair;
                    }
                    pair.getSequenceIDs().add(sequence.getId());
                    ++j;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapPairs.keySet();
    }

    private SequentialPattern appendItemToSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        newPrefix.addItemset(new Itemset(item));
        return newPrefix;
    }

    private SequentialPattern appendItemToPrefixOfSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        Itemset itemset = newPrefix.get(newPrefix.size() - 1);
        itemset.addItem(item);
        return newPrefix;
    }

    public void printStatistics(int size) {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  FEAT - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.getPatternCount());
        r.append(" + 1 (the empty sequence) ");
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(" Prefix pruned count: " + this.prefixPrunedCount);
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void setShowSequenceIdentifiers(boolean showSequenceIdentifiers) {
        this.showSequenceIdentifiers = showSequenceIdentifiers;
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        for (SequentialPattern pattern : this.generators) {
            StringBuilder buffer = new StringBuilder();
            for (Itemset itemset : pattern.getItemsets()) {
                for (Integer item : itemset.getItems()) {
                    buffer.append(item.toString());
                    buffer.append(' ');
                }
                buffer.append("-1 ");
            }
            buffer.append(" #SUP: ");
            buffer.append(pattern.getAbsoluteSupport());
            if (this.showSequenceIdentifiers) {
                buffer.append(" #SID: ");
                for (Integer sid : pattern.getSequenceIDs()) {
                    buffer.append(sid);
                    buffer.append(" ");
                }
            }
            writer.write(buffer.toString());
            writer.newLine();
        }
        writer.close();
    }

    private class PairSequences {
        List<PseudoSequence> olderSequences = new ArrayList<PseudoSequence>();
        List<PseudoSequence> newSequences = new ArrayList<PseudoSequence>();

        private PairSequences() {
        }
    }

    public static enum ProjectionEnum {
        SAME_PROJECTION,
        SAME_PROJECTION_NOT_CONTAINED_IN,
        CONTAIN_PREFIX_WITHOUT_I;

    }
}

