/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPatterns;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoFSGP {
    long startTime;
    long endTime;
    public int minsuppRelative;
    private SequentialPatterns patterns = null;
    List<SequentialPattern> generators = null;
    private int maximumPatternLength = Integer.MAX_VALUE;
    public int prefixPrunedCount = 0;
    private boolean performPruning = true;
    boolean DEBUG_MODE = false;
    boolean showSequenceIdentifiers = false;

    public List<SequentialPattern> runAlgorithm(SequenceDatabase database, double minsupPercent, boolean performPruning) throws IOException {
        if (this.DEBUG_MODE) {
            System.out.println(" %%%%%%%%%%  DEBUG MODE %%%%%%%%%%");
        }
        this.performPruning = performPruning;
        this.minsuppRelative = (int)Math.ceil(minsupPercent * (double)database.size());
        if (this.minsuppRelative == 0) {
            this.minsuppRelative = 1;
        }
        this.startTime = System.currentTimeMillis();
        this.fsgp(database);
        this.filterNonGenerator(database);
        this.endTime = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            for (SequentialPattern pat1 : this.generators) {
                if (pat1.size() > 0 && pat1.getAbsoluteSupport() == database.size()) {
                    System.out.println("NOT A GENERATOR !!!!!!!!!  " + pat1 + "    sup: " + pat1.getAbsoluteSupport() + " because of empty set");
                }
                for (SequentialPattern pat2 : this.generators) {
                    if (pat1 == pat2 || pat1.getAbsoluteSupport() != pat2.getAbsoluteSupport() || !this.strictlyContains(pat1, pat2)) continue;
                    System.out.println("NOT A GENERATOR !!!!!!!!!  " + pat1 + " " + pat2 + "   sup: " + pat1.getAbsoluteSupport());
                    System.out.println(String.valueOf(pat1.getAbsoluteSupport()) + " " + pat2.getAbsoluteSupport());
                }
            }
            for (SequentialPattern pattern : this.generators) {
                System.out.println(pattern + " #SUP: " + pattern.getAbsoluteSupport());
            }
        }
        return this.generators;
    }

    public List<SequentialPattern> runAlgorithm(SequenceDatabase database, int minsup, boolean performPruning) throws IOException {
        if (this.DEBUG_MODE) {
            System.out.println(" %%%%%%%%%%  DEBUG MODE %%%%%%%%%%");
        }
        this.performPruning = performPruning;
        MemoryLogger.getInstance().reset();
        this.minsuppRelative = minsup;
        this.startTime = System.currentTimeMillis();
        this.fsgp(database);
        this.filterNonGenerator(database);
        this.endTime = System.currentTimeMillis();
        return this.generators;
    }

    private List<SequentialPattern> filterNonGenerator(SequenceDatabase database) {
        int emptySequenceSupport = database.size();
        this.generators = new ArrayList<SequentialPattern>();
        if (this.performPruning) {
            int i = 1;
            while (i < this.patterns.levels.size()) {
                block1: for (SequentialPattern pattern : this.patterns.levels.get(i)) {
                    if (pattern.getItemsets().size() == 1 && pattern.get(0).size() == 3 && pattern.get(0).get(0) == 1 && pattern.get(0).get(1) == 2 && pattern.get(0).get(2) == 3) {
                        System.out.println("TEST");
                    }
                    if (pattern.getAbsoluteSupport() == emptySequenceSupport) continue;
                    int j = 1;
                    while (j < i) {
                        List<SequentialPattern> levelJ = this.patterns.levels.get(j);
                        for (SequentialPattern pattern2 : levelJ) {
                            if (pattern2.getAbsoluteSupport() == pattern.getAbsoluteSupport() && this.strictlyContains(pattern, pattern2)) continue block1;
                        }
                        ++j;
                    }
                    this.generators.add(pattern);
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < this.patterns.levels.size()) {
                block5: for (SequentialPattern pattern : this.patterns.levels.get(i)) {
                    if (pattern.getAbsoluteSupport() == emptySequenceSupport) continue;
                    for (SequentialPattern pattern2 : this.patterns.levels.get(i - 1)) {
                        if (pattern2.getAbsoluteSupport() == pattern.getAbsoluteSupport() && this.strictlyContains(pattern, pattern2)) continue block5;
                    }
                    this.generators.add(pattern);
                }
                ++i;
            }
        }
        return this.generators;
    }

    public long getPatternCount() {
        return this.generators.size();
    }

    private boolean pruningCheck(SequentialPattern pattern, List<PseudoSequence> projectedDatabase) {
        int i = pattern.size();
        block0: for (SequentialPattern pattern2 : this.patterns.levels.get(i - 1)) {
            if (pattern2.getAbsoluteSupport() != pattern.getAbsoluteSupport() || !this.strictlyContains(pattern, pattern2)) continue;
            for (PseudoSequence pseudoSeq : projectedDatabase) {
                Sequence originalSequence = pseudoSeq.getOriginalSequence();
                if (!this.sameProjection(originalSequence, pattern, pattern2)) continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean sameProjection(Sequence originalSequence, SequentialPattern pattern1, SequentialPattern pattern2) {
        int pat1itemsetPos = 0;
        int pat1itemPos = 0;
        int pat2itemsetPos = 0;
        int pat2itemPos = 0;
        for (List<Integer> itemset : originalSequence.getItemsets()) {
            for (Integer item : itemset) {
                if (item.intValue() == pattern1.getItemsets().get(pat1itemsetPos).get(pat1itemPos).intValue() && pattern1.getItemsets().get(pat1itemsetPos).size() == ++pat1itemPos) {
                    ++pat1itemsetPos;
                    pat1itemPos = 0;
                }
                if (item.intValue() == pattern2.getItemsets().get(pat2itemsetPos).get(pat2itemPos).intValue() && pattern2.getItemsets().get(pat2itemsetPos).size() == ++pat2itemPos) {
                    ++pat2itemsetPos;
                    pat2itemPos = 0;
                }
                if (pat2itemsetPos != pattern2.getItemsets().size()) continue;
                return pat1itemsetPos == pattern1.getItemsets().size();
            }
        }
        System.out.println("This should never happen");
        return false;
    }

    boolean strictlyContains(SequentialPattern pattern1, SequentialPattern pattern2) {
        int i = 0;
        int j = 0;
        do {
            if (pattern1.get(j).containsAll(pattern2.get(i)) && ++i == pattern2.size()) {
                return true;
            }
            if (++j < pattern1.size()) continue;
            return false;
        } while (pattern1.size() - j >= pattern2.size() - i);
        return false;
    }

    private void fsgp(SequenceDatabase database) throws IOException {
        this.patterns = new SequentialPatterns("SEQUENTIAL GENERATOR PATTERNS");
        Map<Integer, Set<Integer>> mapSequenceID = this.findSequencesContainingItems(database);
        ArrayList<PseudoSequence> initialDatabase = new ArrayList<PseudoSequence>();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsuppRelative);
            if (optimizedSequence.size() == 0) continue;
            initialDatabase.add(new PseudoSequence(optimizedSequence, 0, 0));
        }
        for (Map.Entry entry : mapSequenceID.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsuppRelative) continue;
            Integer item = (Integer)entry.getKey();
            SequentialPattern prefix = new SequentialPattern();
            prefix.addItemset(new Itemset(item));
            prefix.setSequenceIDs((Set)entry.getValue());
            this.savePattern(prefix, 1);
            List<PseudoSequence> projectedContext = this.buildProjectedDatabaseForSingleItem(item, initialDatabase, (Set)entry.getValue());
            if (this.maximumPatternLength <= 1) continue;
            this.recursion(prefix, projectedContext, 2);
        }
    }

    private void savePattern(SequentialPattern prefix, int itemCount) throws IOException {
        this.patterns.addSequence(prefix, itemCount);
    }

    private Map<Integer, Set<Integer>> findSequencesContainingItems(SequenceDatabase database) {
        HashMap<Integer, Set<Integer>> mapSequenceID = new HashMap<Integer, Set<Integer>>();
        for (Sequence sequence : database.getSequences()) {
            for (List<Integer> itemset : sequence.getItemsets()) {
                for (Integer item : itemset) {
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private List<PseudoSequence> buildProjectedDatabaseForSingleItem(Integer item, List<PseudoSequence> initialDatabase, Set<Integer> sidSet) {
        ArrayList<PseudoSequence> sequenceDatabase = new ArrayList<PseudoSequence>();
        for (PseudoSequence sequence : initialDatabase) {
            if (!sidSet.contains(sequence.getId())) continue;
            int i = 0;
            while (i < sequence.size()) {
                int index = sequence.indexOfBis(i, item);
                if (index != -1) {
                    if (index == sequence.getSizeOfItemsetAt(i) - 1) {
                        if (i != sequence.size() - 1) {
                            sequenceDatabase.add(new PseudoSequence(sequence, i + 1, 0));
                        }
                    } else {
                        sequenceDatabase.add(new PseudoSequence(sequence, i, index + 1));
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private List<PseudoSequence> buildProjectedDatabase(Integer item, List<PseudoSequence> database, Set<Integer> sidset, boolean inPostFix) {
        ArrayList<PseudoSequence> sequenceDatabase = new ArrayList<PseudoSequence>();
        for (PseudoSequence sequence : database) {
            if (!sidset.contains(sequence.getId())) continue;
            int i = 0;
            while (i < sequence.size()) {
                int index;
                if (sequence.isPostfix(i) == inPostFix && (index = sequence.indexOfBis(i, item)) != -1) {
                    if (index == sequence.getSizeOfItemsetAt(i) - 1) {
                        if (i != sequence.size() - 1) {
                            sequenceDatabase.add(new PseudoSequence(sequence, i + 1, 0));
                        }
                    } else {
                        sequenceDatabase.add(new PseudoSequence(sequence, i, index + 1));
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private void recursion(SequentialPattern prefix, List<PseudoSequence> database, int k) throws IOException {
        Set<Pair> pairs = this.findAllFrequentPairs(database);
        for (Pair pair : pairs) {
            boolean passedPruningCheck;
            if (pair.getCount() < this.minsuppRelative) continue;
            SequentialPattern newPrefix = pair.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, pair.getItem()) : this.appendItemToSequence(prefix, pair.getItem());
            newPrefix.setSequenceIDs(pair.getSequenceIDs());
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabase(pair.getItem(), database, pair.getSequenceIDs(), pair.isPostfix());
            boolean bl = passedPruningCheck = !this.performPruning || this.pruningCheck(newPrefix, projectedDatabase);
            if (passedPruningCheck) {
                this.savePattern(newPrefix, k);
                if (k >= this.maximumPatternLength) continue;
                this.recursion(newPrefix, projectedDatabase, k + 1);
                continue;
            }
            ++this.prefixPrunedCount;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    protected Set<Pair> findAllFrequentPairs(List<PseudoSequence> sequences) {
        HashMap<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        for (PseudoSequence sequence : sequences) {
            int i = 0;
            while (i < sequence.size()) {
                int j = 0;
                while (j < sequence.getSizeOfItemsetAt(i)) {
                    Integer item = sequence.getItemAtInItemsetAt(j, i);
                    Pair pair = new Pair(sequence.isPostfix(i), item);
                    Pair oldPair = (Pair)mapPairs.get(pair);
                    if (oldPair == null) {
                        mapPairs.put(pair, pair);
                    } else {
                        pair = oldPair;
                    }
                    pair.getSequenceIDs().add(sequence.getId());
                    ++j;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapPairs.keySet();
    }

    private SequentialPattern appendItemToSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        newPrefix.addItemset(new Itemset(item));
        return newPrefix;
    }

    private SequentialPattern appendItemToPrefixOfSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        Itemset itemset = newPrefix.get(newPrefix.size() - 1);
        itemset.addItem(item);
        return newPrefix;
    }

    public void printStatistics(int size) {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  FSGP - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.getPatternCount());
        r.append(" + 1 (the empty sequence) ");
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(" Prefix pruned count: " + this.prefixPrunedCount);
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        for (SequentialPattern pattern : this.generators) {
            StringBuilder buffer = new StringBuilder();
            for (Itemset itemset : pattern.getItemsets()) {
                for (Integer item : itemset.getItems()) {
                    buffer.append(item.toString());
                    buffer.append(' ');
                }
                buffer.append("-1 ");
            }
            buffer.append(" #SUP: ");
            buffer.append(pattern.getAbsoluteSupport());
            if (this.showSequenceIdentifiers) {
                buffer.append(" #SID: ");
                for (Integer sid : pattern.getSequenceIDs()) {
                    buffer.append(sid);
                    buffer.append(" ");
                }
            }
            writer.write(buffer.toString());
            writer.newLine();
        }
        writer.close();
    }

    public void setShowSequenceIdentifiers(boolean showSequenceIdentifiers) {
        this.showSequenceIdentifiers = showSequenceIdentifiers;
    }
}

