/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.Candidate;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPattern;
import ca.pfv.spmf.datastructures.redblacktree.RedBlackTree;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class AlgoTSP_nonClosed {
    private long startTime;
    private long endTime;
    private int minsupAbsolute;
    private int k = 0;
    PriorityQueue<SequentialPattern> kPatterns;
    RedBlackTree<Candidate> candidates;
    boolean showSequenceIdentifiers = false;

    public PriorityQueue<SequentialPattern> runAlgorithm(SequenceDatabase database, int k) throws IOException {
        MemoryLogger.getInstance().reset();
        this.k = k;
        this.kPatterns = new PriorityQueue();
        this.candidates = new RedBlackTree();
        this.minsupAbsolute = 1;
        this.startTime = System.currentTimeMillis();
        this.prefixSpan(database);
        this.endTime = System.currentTimeMillis();
        return this.kPatterns;
    }

    private void prefixSpan(SequenceDatabase database) throws IOException {
        Map<Integer, Set<Integer>> mapSequenceID = this.findSequencesContainingItems(database);
        Iterator<Map.Entry<Integer, Set<Integer>>> iter = mapSequenceID.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Set<Integer>> entry = iter.next();
            if (entry.getValue().size() < this.minsupAbsolute) {
                iter.remove();
                continue;
            }
            SequentialPattern pattern = new SequentialPattern();
            pattern.addItemset(new Itemset(entry.getKey()));
            pattern.setSequenceIDs(entry.getValue());
            this.save(pattern);
        }
        ArrayList<PseudoSequence> initialDatabase = new ArrayList<PseudoSequence>();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsupAbsolute);
            if (optimizedSequence.size() == 0) continue;
            initialDatabase.add(new PseudoSequence(optimizedSequence, 0, 0));
        }
        for (Map.Entry<Integer, Set<Integer>> entry : mapSequenceID.entrySet()) {
            SequentialPattern prefix = new SequentialPattern();
            prefix.addItemset(new Itemset(entry.getKey()));
            prefix.setSequenceIDs(entry.getValue());
            Candidate cand = new Candidate(prefix, initialDatabase, entry.getKey(), null);
            this.registerAsCandidate(cand);
        }
        while (!this.candidates.isEmpty()) {
            Candidate cand = this.candidates.popMaximum();
            if (cand.prefix.getAbsoluteSupport() < this.minsupAbsolute) break;
            if (cand.isPostfix == null) {
                List<PseudoSequence> projectedContext = this.buildProjectedDatabaseForSingleItem(cand.item, cand.databaseBeforeProjection, cand.prefix.getSequenceIDs());
                this.recursion(cand.prefix, projectedContext);
                continue;
            }
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabase(cand.item, cand.databaseBeforeProjection, cand.prefix.getSequenceIDs(), cand.isPostfix);
            this.recursion(cand.prefix, projectedDatabase);
        }
    }

    private void save(SequentialPattern pattern) {
        this.kPatterns.add(pattern);
        if (this.kPatterns.size() > this.k) {
            if (pattern.getAbsoluteSupport() > this.minsupAbsolute) {
                do {
                    this.kPatterns.poll();
                } while (this.kPatterns.size() > this.k);
            }
            this.minsupAbsolute = this.kPatterns.peek().getAbsoluteSupport();
        }
    }

    private void registerAsCandidate(Candidate candidate) {
        this.candidates.add(candidate);
    }

    private Map<Integer, Set<Integer>> findSequencesContainingItems(SequenceDatabase database) {
        HashMap<Integer, Set<Integer>> mapSequenceID = new HashMap<Integer, Set<Integer>>();
        for (Sequence sequence : database.getSequences()) {
            for (List<Integer> itemset : sequence.getItemsets()) {
                for (Integer item : itemset) {
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private List<PseudoSequence> buildProjectedDatabaseForSingleItem(Integer item, List<PseudoSequence> initialDatabase, Set<Integer> sidSet) {
        ArrayList<PseudoSequence> sequenceDatabase = new ArrayList<PseudoSequence>();
        for (PseudoSequence sequence : initialDatabase) {
            if (!sidSet.contains(sequence.getId())) continue;
            int i = 0;
            while (i < sequence.size()) {
                int index = sequence.indexOfBis(i, item);
                if (index != -1) {
                    if (index == sequence.getSizeOfItemsetAt(i) - 1) {
                        if (i != sequence.size() - 1) {
                            sequenceDatabase.add(new PseudoSequence(sequence, i + 1, 0));
                        }
                    } else {
                        sequenceDatabase.add(new PseudoSequence(sequence, i, index + 1));
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private List<PseudoSequence> buildProjectedDatabase(Integer item, List<PseudoSequence> database, Set<Integer> sidset, boolean inPostFix) {
        ArrayList<PseudoSequence> sequenceDatabase = new ArrayList<PseudoSequence>();
        for (PseudoSequence sequence : database) {
            if (!sidset.contains(sequence.getId())) continue;
            int i = 0;
            while (i < sequence.size()) {
                int index;
                if (sequence.isPostfix(i) == inPostFix && (index = sequence.indexOfBis(i, item)) != -1) {
                    if (index == sequence.getSizeOfItemsetAt(i) - 1) {
                        if (i != sequence.size() - 1) {
                            sequenceDatabase.add(new PseudoSequence(sequence, i + 1, 0));
                        }
                    } else {
                        sequenceDatabase.add(new PseudoSequence(sequence, i, index + 1));
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private void recursion(SequentialPattern prefix, List<PseudoSequence> database) throws IOException {
        Set<Pair> pairs = this.findAllFrequentPairs(database);
        for (Pair pair : pairs) {
            if (pair.getCount() < this.minsupAbsolute) continue;
            SequentialPattern newPrefix = pair.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, pair.getItem()) : this.appendItemToSequence(prefix, pair.getItem());
            newPrefix.setSequenceIDs(pair.getSequenceIDs());
            this.save(newPrefix);
            Candidate cand = new Candidate(newPrefix, database, pair.item, pair.isPostfix());
            this.registerAsCandidate(cand);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    protected Set<Pair> findAllFrequentPairs(List<PseudoSequence> sequences) {
        HashMap<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        for (PseudoSequence sequence : sequences) {
            int i = 0;
            while (i < sequence.size()) {
                int j = 0;
                while (j < sequence.getSizeOfItemsetAt(i)) {
                    Integer item = sequence.getItemAtInItemsetAt(j, i);
                    Pair pair = new Pair(sequence.isPostfix(i), item);
                    Pair oldPair = (Pair)mapPairs.get(pair);
                    if (oldPair == null) {
                        mapPairs.put(pair, pair);
                    } else {
                        pair = oldPair;
                    }
                    pair.getSequenceIDs().add(sequence.getId());
                    ++j;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapPairs.keySet();
    }

    private SequentialPattern appendItemToSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        newPrefix.addItemset(new Itemset(item));
        return newPrefix;
    }

    private SequentialPattern appendItemToPrefixOfSequence(SequentialPattern prefix, Integer item) {
        SequentialPattern newPrefix = prefix.cloneSequence();
        Itemset itemset = newPrefix.get(newPrefix.size() - 1);
        itemset.addItem(item);
        return newPrefix;
    }

    public void printStatistics(int size) {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  TSP_non_closed - STATISTICS =============\n Total time ~ ");
        r.append("Pattern found count : " + this.kPatterns.size());
        r.append('\n');
        r.append("Total time: " + (this.endTime - this.startTime) + " ms \n");
        r.append("Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append("Final minsup value: " + this.minsupAbsolute);
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        for (SequentialPattern pattern : this.kPatterns) {
            StringBuilder buffer = new StringBuilder();
            for (Itemset itemset : pattern.getItemsets()) {
                for (Integer item : itemset.getItems()) {
                    buffer.append(item.toString());
                    buffer.append(' ');
                }
                buffer.append("-1 ");
            }
            buffer.append(" #SUP: ");
            buffer.append(pattern.getAbsoluteSupport());
            if (this.showSequenceIdentifiers) {
                buffer.append(" #SID: ");
                for (Integer sid : pattern.getSequenceIDs()) {
                    buffer.append(sid);
                    buffer.append(" ");
                }
            }
            writer.write(buffer.toString());
            writer.newLine();
        }
        writer.close();
    }

    public void setShowSequenceIdentifiers(boolean showSequenceIdentifiers) {
        this.showSequenceIdentifiers = showSequenceIdentifiers;
    }
}

