/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.SequentialPattern;
import java.util.ArrayList;
import java.util.List;

public class SequentialPatterns {
    public final List<List<SequentialPattern>> levels = new ArrayList<List<SequentialPattern>>();
    public int sequenceCount = 0;
    private final String name;

    public SequentialPatterns(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public void printFrequentPatterns(int nbObject, boolean showSequenceIdentifiers) {
        System.out.println(this.toString(nbObject, showSequenceIdentifiers));
    }

    public String toString(int nbObject, boolean showSequenceIdentifiers) {
        StringBuilder r = new StringBuilder(200);
        r.append(" ----------");
        r.append(this.name);
        r.append(" -------\n");
        int levelCount = 0;
        int patternCount = 0;
        for (List<SequentialPattern> level : this.levels) {
            r.append("  L");
            r.append(levelCount);
            r.append(" \n");
            for (SequentialPattern sequence : level) {
                r.append("  pattern ");
                r.append(++patternCount);
                r.append(":  ");
                r.append(sequence.toString());
                r.append("support :  ");
                r.append(sequence.getRelativeSupportFormated(nbObject));
                r.append(" (");
                r.append(sequence.getAbsoluteSupport());
                r.append('/');
                r.append(nbObject);
                r.append(")");
                if (showSequenceIdentifiers) {
                    r.append(" sequence ids: ");
                    for (Integer sid : sequence.getSequenceIDs()) {
                        r.append(sid);
                        r.append(" ");
                    }
                }
                r.append("\n");
            }
            ++levelCount;
        }
        r.append(" -------------------------------- Patterns count : ");
        r.append(this.sequenceCount);
        return r.toString();
    }

    public void addSequence(SequentialPattern sequence, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(sequence);
        ++this.sequenceCount;
    }

    public List<SequentialPattern> getLevel(int index) {
        return this.levels.get(index);
    }

    public int getLevelCount() {
        return this.levels.size();
    }

    public List<List<SequentialPattern>> getLevels() {
        return this.levels;
    }
}

