/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.database;

import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.ItemAbstractionPairCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.database.ItemFactory;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.IDList;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.creators.IdListCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.tries.Trie;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.tries.TrieNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SequenceDatabase {
    private AbstractionCreator abstractionCreator;
    private IdListCreator idListCreator;
    private Map<Item, TrieNode> frequentItems = new HashMap<Item, TrieNode>();
    private List<Sequence> sequences = new ArrayList<Sequence>();
    private ItemFactory<Integer> itemFactory = new ItemFactory();
    private int nSequences = 1;
    private Map<Integer, Integer> sequencesLengths = new HashMap<Integer, Integer>();
    private Map<Integer, List<Integer>> sequenceItemsetSize = new HashMap<Integer, List<Integer>>();
    private Map<Item, Map<Integer, List<Integer>>> projectingDistance = new HashMap<Item, Map<Integer, List<Integer>>>();

    public SequenceDatabase(AbstractionCreator abstractionCreator, IdListCreator IdListCreator2) {
        this.abstractionCreator = abstractionCreator;
        this.idListCreator = IdListCreator2;
    }

    public double loadFile(String path, double minSupport) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.addSequence(thisLine.split(" "));
            }
            double support = (int)Math.ceil(minSupport * (double)this.sequences.size());
            Set<Item> frequentItemsSet = this.frequentItems.keySet();
            HashSet<Item> itemsToRemove = new HashSet<Item>();
            for (Item item : frequentItemsSet) {
                TrieNode nodo = this.frequentItems.get(item);
                if ((double)nodo.getChild().getIdList().getSupport() < support) {
                    itemsToRemove.add(item);
                    continue;
                }
                nodo.getChild().getIdList().setAppearingIn(nodo.getChild());
            }
            for (Item<Object> item : itemsToRemove) {
                this.frequentItems.remove(item);
            }
            this.reduceDatabase(this.frequentItems.keySet());
            this.idListCreator.initializeMaps(this.frequentItems, this.projectingDistance, this.sequencesLengths, this.sequenceItemsetSize);
            double d = support;
            return d;
        }
        return -1.0;
    }

    public void addSequence(String[] integers) {
        ItemAbstractionPairCreator pairCreator = ItemAbstractionPairCreator.getInstance();
        long timestamp = -1L;
        Sequence sequence = new Sequence(this.sequences.size());
        Itemset itemset = new Itemset();
        sequence.setID(this.nSequences);
        int beginning = 0;
        ArrayList<Integer> sizeItemsetsList = new ArrayList<Integer>();
        int i = beginning;
        while (i < integers.length) {
            if (integers[i].codePointAt(0) == 60) {
                String value = integers[i].substring(1, integers[i].length() - 1);
                timestamp = Long.parseLong(value);
                itemset.setTimestamp(timestamp);
            } else if (integers[i].equals("-1")) {
                timestamp = itemset.getTimestamp() + 1L;
                sequence.addItemset(itemset);
                itemset = new Itemset();
                itemset.setTimestamp(timestamp);
                sizeItemsetsList.add(sequence.length());
            } else if (integers[i].equals("-2")) {
                this.sequences.add(sequence);
                ++this.nSequences;
                this.sequencesLengths.put(sequence.getId(), sequence.length());
                this.sequenceItemsetSize.put(sequence.getId(), sizeItemsetsList);
            } else {
                int indexParentheseGauche = integers[i].indexOf("(");
                if (indexParentheseGauche == -1) {
                    IDList idlist;
                    Item item = this.itemFactory.getItem(Integer.parseInt(integers[i]));
                    TrieNode node = this.frequentItems.get(item);
                    if (node == null) {
                        idlist = this.idListCreator.create();
                        node = new TrieNode(pairCreator.getItemAbstractionPair(item, this.abstractionCreator.createDefaultAbstraction()), new Trie(null, idlist));
                        this.frequentItems.put(item, node);
                    }
                    idlist = node.getChild().getIdList();
                    if (timestamp < 0L) {
                        timestamp = 1L;
                        itemset.setTimestamp(timestamp);
                    }
                    itemset.addItem(item);
                    this.idListCreator.addAppearance(idlist, sequence.getId(), (int)timestamp, sequence.length() + itemset.size());
                    this.idListCreator.updateProjectionDistance(this.projectingDistance, item, sequence.getId(), sequence.size(), sequence.length() + itemset.size());
                }
            }
            ++i;
        }
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Sequence sequence : this.sequences) {
            r.append(sequence.getId());
            r.append(":  ");
            r.append(sequence.toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public Trie frequentItems() {
        Trie result = new Trie();
        ArrayList<TrieNode> frequentItemsNodes = new ArrayList<TrieNode>(this.frequentItems.values());
        result.setNodes(frequentItemsNodes);
        result.sort();
        return result;
    }

    public Map<Item, TrieNode> getFrequentItems() {
        return this.frequentItems;
    }

    private void reduceDatabase(Set<Item> keySet) {
        int k = 0;
        while (k < this.sequences.size()) {
            Sequence sequence = this.sequences.get(k);
            int i = 0;
            while (i < sequence.size()) {
                Itemset itemset = sequence.get(i);
                int j = 0;
                while (j < itemset.size()) {
                    Item item = itemset.get(j);
                    if (!keySet.contains(item)) {
                        sequence.remove(i, j);
                        --j;
                    }
                    ++j;
                }
                if (itemset.size() == 0) {
                    sequence.remove(i);
                    --i;
                }
                ++i;
            }
            if (sequence.size() == 0) {
                this.sequences.remove(k);
                --k;
            }
            ++k;
        }
    }

    public void clear() {
        if (this.sequences != null) {
            this.sequences.clear();
        }
        this.sequences = null;
        if (this.frequentItems != null) {
            this.frequentItems.clear();
        }
        this.frequentItems = null;
        this.itemFactory = null;
        this.projectingDistance = null;
        this.sequenceItemsetSize = null;
        this.sequencesLengths = null;
    }
}

