/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.PseudoSequence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PseudoSequenceDatabase {
    private List<PseudoSequence> pseudoSequences = new ArrayList<PseudoSequence>();
    private int cumulativeSum;
    private int cumulativeSumNumberOfProjections;
    private int numberOfElementsProjectedDatabase;
    private int elementsProjectedDatabase;

    public List<PseudoSequence> getPseudoSequences() {
        return this.pseudoSequences;
    }

    public String toString() {
        StringBuilder r = new StringBuilder("============  CONTEXTE ==========");
        for (PseudoSequence sequence : this.pseudoSequences) {
            r.append(sequence.getId());
            r.append(":  ");
            r.append(sequence.toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.pseudoSequences.size();
    }

    public int getNumberOfElementsProjectedDatabase() {
        return this.numberOfElementsProjectedDatabase;
    }

    public void setNumberOfElementsProjectedDatabase(int value) {
        this.numberOfElementsProjectedDatabase = value;
    }

    public Set<Integer> getSequenceIDs() {
        HashSet<Integer> ensemble = new HashSet<Integer>();
        for (PseudoSequence sequence : this.getPseudoSequences()) {
            ensemble.add(sequence.getId());
        }
        return ensemble;
    }

    public void addSequence(PseudoSequence newSequence) {
        this.pseudoSequences.add(newSequence);
    }

    public void clear() {
        if (this.pseudoSequences != null) {
            this.pseudoSequences.clear();
            this.pseudoSequences = null;
        }
    }

    public void setCumulativeSum(int cumulativeSum) {
        this.cumulativeSum = cumulativeSum;
    }

    public int getCumulativeSum() {
        return this.cumulativeSum;
    }

    public int getCumulativeSumNumberOfProjections() {
        return this.cumulativeSumNumberOfProjections;
    }

    public void setCumulativeSumNumberOfProjections(int cumulativeSumNumberOfProjections) {
        this.cumulativeSumNumberOfProjections = cumulativeSumNumberOfProjections;
    }

    public int getElementsProjectedDatabase() {
        return this.elementsProjectedDatabase;
    }

    public void setElementsProjectedDatabase(String string) {
        if (string.length() <= 0) {
            this.elementsProjectedDatabase = 0;
        }
    }
}

