/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.trie;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.trie.Trie;

public class TrieNode
implements Comparable {
    private ItemAbstractionPair pair;
    private Trie child;
    private boolean alreadyExplored;

    public TrieNode() {
    }

    public TrieNode(ItemAbstractionPair pair) {
        this.pair = pair;
    }

    public TrieNode(ItemAbstractionPair pair, Trie child) {
        this.pair = pair;
        this.child = child;
        this.alreadyExplored = false;
    }

    public TrieNode(ItemAbstractionPair pair, Trie child, boolean alreadyExplored) {
        this.pair = pair;
        this.child = child;
        this.alreadyExplored = alreadyExplored;
    }

    public Trie getChild() {
        return this.child;
    }

    public void setChild(Trie child) {
        this.child = child;
    }

    public ItemAbstractionPair getPair() {
        return this.pair;
    }

    public void setPair(ItemAbstractionPair par) {
        this.pair = par;
    }

    public void clear() {
        this.child.removeAll();
        this.child = null;
        this.pair = null;
    }

    public int compareTo(Object o) {
        if (o instanceof TrieNode) {
            TrieNode t = (TrieNode)o;
            return this.getPair().compareTo(t.getPair());
        }
        if (o instanceof ItemAbstractionPair) {
            ItemAbstractionPair pair = (ItemAbstractionPair)o;
            return this.getPair().compareTo(pair);
        }
        if (o instanceof Item) {
            return this.getPair().getItem().compareTo((Item)o);
        }
        throw new RuntimeException("Error comparing a TrieNode with an object different from a TrieNode or an ItemAbstractionPair");
    }

    public boolean isAlreadyExplored() {
        return this.alreadyExplored;
    }

    public void setAlreadyExplored(boolean alreadyExplored) {
        this.alreadyExplored = alreadyExplored;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{").append(this.pair.toString()).append("}, [");
        if (this.child == null) {
            s.append("NULL");
        } else {
            s.append(this.child.toString());
        }
        s.append("]");
        return s.toString();
    }
}

