/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemSimple;
import java.util.HashSet;
import java.util.Set;

class Pair {
    private final long timestamp;
    private final boolean postfix;
    private final boolean prefix;
    private final ItemSimple item;
    private Set<Integer> sequencesID = new HashSet<Integer>();

    Pair(long timestamp, boolean prefix, boolean postfix, ItemSimple item) {
        this.timestamp = timestamp;
        this.postfix = postfix;
        this.prefix = prefix;
        this.item = item;
    }

    public Pair(boolean prefix, boolean postfix, ItemSimple item) {
        this.timestamp = 0L;
        this.postfix = postfix;
        this.prefix = prefix;
        this.item = item;
    }

    public boolean equals(Object object) {
        Pair paire = (Pair)object;
        return paire.timestamp == this.timestamp && paire.postfix == this.postfix && paire.prefix == this.prefix && paire.item.equals(this.item);
    }

    public int hashCode() {
        StringBuilder r = new StringBuilder();
        r.append(this.timestamp);
        r.append(this.postfix ? (char)'P' : 'N');
        r.append(this.prefix ? (char)'X' : 'Z');
        r.append(this.item.getId());
        return r.toString().hashCode();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isPostfix() {
        return this.postfix;
    }

    public ItemSimple getItem() {
        return this.item;
    }

    public int getCount() {
        return this.sequencesID.size();
    }

    public Set<Integer> getSequencesID() {
        return this.sequencesID;
    }

    public void setSequencesID(Set<Integer> sequencesID) {
        this.sequencesID = sequencesID;
    }

    public boolean isPrefix() {
        return this.prefix;
    }
}

