/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.kmeans_for_fournier08;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemValued;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.kmeans_for_fournier08.Cluster;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class AlgoKMeans_forFournier08 {
    private int k;
    private static final Random random = new Random(System.currentTimeMillis());

    public AlgoKMeans_forFournier08(int k) {
        this.k = k;
    }

    public List<Cluster> runAlgorithm(List<ItemValued> input) {
        boolean changed;
        ArrayList<Cluster> clusters = new ArrayList<Cluster>(this.k);
        if (input.size() == 1) {
            ItemValued item = input.get(0);
            Cluster cluster = new Cluster(item);
            cluster.addItem(item);
            clusters.add(cluster);
            return clusters;
        }
        double higher = input.get(0).getId();
        double lower = input.get(0).getId();
        for (ItemValued item : input) {
            if (item.getValue() > higher) {
                higher = item.getValue();
            }
            if (!(item.getValue() < lower)) continue;
            lower = item.getValue();
        }
        if (higher == lower) {
            Cluster cluster = new Cluster(input);
            clusters.add(cluster);
            return clusters;
        }
        int i = 0;
        while (i < this.k) {
            double average = (double)random.nextInt((int)(higher - lower)) + lower;
            Cluster cluster = new Cluster(average);
            clusters.add(cluster);
            ++i;
        }
        do {
            changed = false;
            for (ItemValued item : input) {
                Cluster nearestCluster = null;
                Cluster containingCluster = null;
                double distanceToNearestCluster = Double.MAX_VALUE;
                for (Cluster cluster : clusters) {
                    double distance = this.averageDistance(cluster, item);
                    if (distance < distanceToNearestCluster) {
                        nearestCluster = cluster;
                        distanceToNearestCluster = distance;
                    }
                    if (!cluster.containsItem(item)) continue;
                    containingCluster = cluster;
                }
                if (containingCluster == nearestCluster) continue;
                if (containingCluster != null) {
                    this.removeItem(containingCluster.getItems(), item);
                }
                nearestCluster.addItem(item);
                changed = true;
            }
            for (Cluster cluster : clusters) {
                cluster.recomputeClusterAverage();
            }
        } while (changed);
        for (Cluster cluster : clusters) {
            cluster.computeHigherAndLower();
        }
        return clusters;
    }

    private void removeItem(List<ItemValued> items, ItemValued item) {
        int i = 0;
        while (i < items.size()) {
            if (items.get(i) == item) {
                items.remove(i);
            }
            ++i;
        }
    }

    private double averageDistance(Cluster cluster1, ItemValued item) {
        return Math.abs(cluster1.getaverage() - item.getValue());
    }

    public void setK(int k) {
        this.k = k;
    }
}

