/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.kmeans_for_fournier08;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemValued;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Cluster {
    private List<ItemValued> items;
    private double average;
    private double higher = 0.0;
    private double lower = Double.MAX_VALUE;
    private double sum = 0.0;
    private Set<Integer> sequenceIDs = null;

    public Cluster(double average) {
        this.items = new ArrayList<ItemValued>();
        this.average = average;
    }

    public Cluster(List<ItemValued> newItems) {
        this.items = new ArrayList<ItemValued>(newItems);
        this.recomputeClusterAverage();
    }

    public Cluster(List<ItemValued> newItems, List<ItemValued> newItems2) {
        this.items = new ArrayList<ItemValued>(newItems);
        this.items.addAll(newItems2);
        this.recomputeClusterAverage();
    }

    public Cluster(ItemValued item) {
        this.items = new ArrayList<ItemValued>();
        this.items.add(item);
        this.sum += item.getValue();
        this.average = item.getValue();
    }

    public void addItemsFromCluster(Cluster cluster2) {
        for (ItemValued item : cluster2.getItems()) {
            this.getItems().add(item);
            this.sum += item.getValue();
        }
    }

    public void addItem(ItemValued item) {
        this.getItems().add(item);
        this.sum += item.getValue();
    }

    public void addItems(List<ItemValued> newItems) {
        for (ItemValued item : newItems) {
            this.getItems().add(item);
            this.sum += item.getValue();
        }
    }

    public List<ItemValued> getItems() {
        return this.items;
    }

    public int size() {
        return this.getItems().size();
    }

    public double getaverage() {
        return this.average;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("(");
        for (ItemValued item : this.getItems()) {
            buffer.append(item.getValue());
            buffer.append(" ");
        }
        buffer.append(")      <");
        buffer.append(this.average);
        buffer.append(", min=");
        buffer.append(this.getLower());
        buffer.append(" max=");
        buffer.append(this.getHigher());
        buffer.append(">");
        return buffer.toString();
    }

    public void recomputeClusterAverage() {
        if (this.getItems().isEmpty()) {
            return;
        }
        if (this.getItems().size() == 1) {
            this.average = this.getItems().get(0).getValue();
            return;
        }
        this.average = this.sum / (double)this.items.size();
    }

    public void computeHigherAndLower() {
        for (ItemValued item : this.getItems()) {
            if (item.getValue() > this.higher) {
                this.higher = item.getValue();
            }
            if (!(item.getValue() < this.lower)) continue;
            this.lower = item.getValue();
        }
    }

    public boolean containsItem(ItemValued item2) {
        for (ItemValued item : this.getItems()) {
            if (item != item2) continue;
            return true;
        }
        return false;
    }

    public double getHigher() {
        return this.higher;
    }

    public double getLower() {
        return this.lower;
    }

    public int getItemId() {
        return this.getItems().get(0).getId();
    }

    public Set<Integer> getSequenceIDs() {
        return this.sequenceIDs;
    }

    public void setSequenceIDs(Set<Integer> sequenceIDs) {
        this.sequenceIDs = sequenceIDs;
    }
}

