/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPattern;
import java.util.ArrayList;
import java.util.List;

public class MDPatterns {
    private final List<List<MDPattern>> levels = new ArrayList<List<MDPattern>>();
    private int patternsCount = 0;
    private final String name;

    public MDPatterns(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public void printPatterns(int databaseSize) {
        StringBuilder r = new StringBuilder(150);
        r.append(" ------- ");
        r.append(this.name);
        r.append(" -------\n");
        int levelCount = 0;
        for (List<MDPattern> level : this.levels) {
            r.append("  L");
            r.append(levelCount);
            r.append(" \n");
            for (MDPattern pattern : level) {
                StringBuilder s = new StringBuilder(100);
                s.append("  pattern ");
                s.append(pattern.getId());
                s.append(":  ");
                s.append(pattern.toString());
                s.append("support :  ");
                s.append(pattern.getRelativeSupportFormatted(databaseSize));
                s.append(" (");
                s.append(pattern.getAbsoluteSupport());
                s.append("/");
                s.append(databaseSize);
                s.append(") ");
                s.append("\n");
                r.append((CharSequence)s);
            }
            ++levelCount;
        }
        r.append(" --------------------------------\n");
        System.out.print(r);
    }

    void addPattern(MDPattern pattern, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(pattern);
        ++this.patternsCount;
    }

    void removePattern(MDPattern pattern, int k) {
        this.levels.get(k).remove(pattern);
        --this.patternsCount;
    }

    public List<MDPattern> getLevel(int k) {
        return this.levels.get(k);
    }

    public int size() {
        return this.patternsCount;
    }

    public int getLevelCount() {
        return this.levels.size();
    }
}

