/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.patterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.abstractions.ItemAbstractionPair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class Pattern
implements Comparable<Pattern> {
    private List<ItemAbstractionPair> elements;
    private BitSet appearingIn;

    public Pattern() {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.appearingIn = new BitSet();
    }

    public Pattern(List<ItemAbstractionPair> elements) {
        this.elements = elements;
        this.appearingIn = new BitSet();
    }

    public Pattern(ItemAbstractionPair pair) {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.elements.add(pair);
        this.appearingIn = new BitSet();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        BitSet sequenceIdsList = this.appearingIn;
        int i = 0;
        while (i < this.elements.size()) {
            result.append(this.elements.get(i).toString());
            ++i;
        }
        result.append("\t[");
        i = sequenceIdsList.nextSetBit(0);
        while (i >= 0) {
            result.append(i).append(", ");
            i = sequenceIdsList.nextSetBit(i + 1);
        }
        result.deleteCharAt(result.length() - 1);
        result.deleteCharAt(result.length() - 1);
        result.append("]");
        return result.toString();
    }

    public String toStringToFile(boolean outputSequenceIdentifiers) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.elements.size()) {
            if (i == this.elements.size() - 1) {
                if (i != 0) {
                    result.append(this.elements.get(i).toStringToFile());
                } else {
                    result.append(this.elements.get(i).getItem());
                }
                result.append(" -1");
            } else if (i == 0) {
                result.append(this.elements.get(i).getItem());
            } else {
                result.append(this.elements.get(i).toStringToFile());
            }
            ++i;
        }
        result.append(" #SUP: ");
        result.append(this.appearingIn.cardinality());
        if (outputSequenceIdentifiers) {
            result.append(" #SID: ");
            i = this.appearingIn.nextSetBit(0);
            while (i >= 0) {
                result.append(i);
                result.append(" ");
                i = this.appearingIn.nextSetBit(i + 1);
            }
        }
        return result.toString();
    }

    public Pattern clonePattern() {
        ArrayList<ItemAbstractionPair> elementsCopy = new ArrayList<ItemAbstractionPair>(this.elements);
        Pattern clone = new Pattern(elementsCopy);
        return clone;
    }

    public List<ItemAbstractionPair> getElements() {
        return this.elements;
    }

    public ItemAbstractionPair getIthElement(int i) {
        return this.elements.get(i);
    }

    public ItemAbstractionPair getLastButOneElement() {
        if (this.size() > 1) {
            return this.getIthElement(this.size() - 2);
        }
        return null;
    }

    public ItemAbstractionPair getLastElement() {
        if (this.size() > 0) {
            return this.getIthElement(this.size() - 1);
        }
        return null;
    }

    public List<ItemAbstractionPair> getNElements(int n) {
        if (n <= this.elements.size()) {
            return this.elements.subList(0, n - 1);
        }
        return null;
    }

    public void setElements(List<ItemAbstractionPair> elements) {
        this.elements = elements;
    }

    public void add(ItemAbstractionPair pair) {
        this.elements.add(pair);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public int compareTo(Pattern arg) {
        List<ItemAbstractionPair> elementsOfSmallerPattern;
        List<ItemAbstractionPair> elementsOfBiggerPattern;
        if (this.getElements().size() >= arg.getElements().size()) {
            elementsOfBiggerPattern = this.getElements();
            elementsOfSmallerPattern = arg.getElements();
        } else {
            elementsOfSmallerPattern = this.getElements();
            elementsOfBiggerPattern = arg.getElements();
        }
        int i = 0;
        while (i < elementsOfSmallerPattern.size()) {
            int comparison = elementsOfSmallerPattern.get(i).compareTo(elementsOfBiggerPattern.get(i));
            if (comparison != 0) {
                return comparison;
            }
            ++i;
        }
        if (elementsOfBiggerPattern.size() == elementsOfSmallerPattern.size()) {
            return 0;
        }
        if (this.getElements().size() < arg.getElements().size()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object arg) {
        if (arg instanceof Pattern) {
            Pattern p = (Pattern)arg;
            return this.compareTo(p) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.elements != null ? this.elements.hashCode() : 0);
        return hash;
    }

    public boolean isPrefix(Pattern p) {
        boolean output = false;
        ArrayList<ItemAbstractionPair> pElements = new ArrayList<ItemAbstractionPair>(p.getElements());
        pElements.remove(pElements.size() - 1);
        Pattern pTemp = new Pattern(pElements);
        if (this.equals(pTemp)) {
            output = true;
        }
        return output;
    }

    public BitSet getAppearingIn() {
        return this.appearingIn;
    }

    public void setAppearingIn(BitSet appearingIn) {
        this.appearingIn = appearingIn;
    }

    public void clear() {
        this.elements.clear();
        this.appearingIn.clear();
    }

    public void addAppearance(Integer sequenceId) {
        this.appearingIn.set(sequenceId);
    }

    public double getSupport() {
        return this.appearingIn.cardinality();
    }
}

