/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.patterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixSpan_AGP.items.patterns.PatternCreator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class Pattern
implements Comparable<Pattern> {
    private List<ItemAbstractionPair> elements;
    private BitSet appearingIn;

    public Pattern() {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.appearingIn = new BitSet();
    }

    public Pattern(List<ItemAbstractionPair> elements) {
        this.elements = elements;
        this.appearingIn = new BitSet();
    }

    public Pattern(ItemAbstractionPair pair) {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.elements.add(pair);
        this.appearingIn = new BitSet();
    }

    public int getSupport() {
        return this.appearingIn.cardinality();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.elements.size()) {
            result.append(this.elements.get(i).toString());
            ++i;
        }
        result.append("\t(").append(this.getSupport()).append(')');
        result.append("\t[");
        i = this.appearingIn.nextSetBit(0);
        while (i >= 0) {
            result.append(i).append(", ");
            i = this.appearingIn.nextSetBit(i + 1);
        }
        result.deleteCharAt(result.length() - 1);
        result.deleteCharAt(result.length() - 1);
        result.append("]");
        return result.toString();
    }

    public String toStringToFile(boolean outputSequenceIdentifiers) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.elements.size()) {
            if (i == this.elements.size() - 1) {
                if (i != 0) {
                    result.append(this.elements.get(i).toStringToFile());
                } else {
                    result.append(this.elements.get(i).getItem());
                }
                result.append(" -1");
            } else if (i == 0) {
                result.append(this.elements.get(i).getItem());
            } else {
                result.append(this.elements.get(i).toStringToFile());
            }
            ++i;
        }
        result.append(" #SUP: ");
        result.append(this.appearingIn.cardinality());
        if (outputSequenceIdentifiers) {
            result.append(" #SID: ");
            i = this.appearingIn.nextSetBit(0);
            while (i >= 0) {
                result.append(i);
                result.append(" ");
                i = this.appearingIn.nextSetBit(i + 1);
            }
        }
        return result.toString();
    }

    public Pattern clonePattern() {
        PatternCreator patternCreator = new PatternCreator();
        ArrayList<ItemAbstractionPair> elementsCopy = new ArrayList<ItemAbstractionPair>(this.elements);
        Pattern clon = patternCreator.createPattern(elementsCopy);
        return clon;
    }

    public List<ItemAbstractionPair> getElements() {
        return this.elements;
    }

    public ItemAbstractionPair getIthElement(int i) {
        return this.elements.get(i);
    }

    public ItemAbstractionPair getLastElement() {
        if (this.size() > 0) {
            return this.getIthElement(this.size() - 1);
        }
        return null;
    }

    public void setElements(List<ItemAbstractionPair> elements) {
        this.elements = elements;
    }

    public void add(ItemAbstractionPair pair) {
        this.elements.add(pair);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public int compareTo(Pattern arg) {
        List<ItemAbstractionPair> elementOfSmallerPattern;
        List<ItemAbstractionPair> elementsOfGreaterPattern;
        if (this.getElements().size() >= arg.getElements().size()) {
            elementsOfGreaterPattern = this.getElements();
            elementOfSmallerPattern = arg.getElements();
        } else {
            elementOfSmallerPattern = this.getElements();
            elementsOfGreaterPattern = arg.getElements();
        }
        int i = 0;
        while (i < elementOfSmallerPattern.size()) {
            int comparison = elementOfSmallerPattern.get(i).compareTo(elementsOfGreaterPattern.get(i));
            if (comparison != 0) {
                return comparison;
            }
            ++i;
        }
        if (elementsOfGreaterPattern.size() == elementOfSmallerPattern.size()) {
            return 0;
        }
        if (this.getElements().size() < arg.getElements().size()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object arg) {
        if (arg instanceof Pattern) {
            Pattern pattern = (Pattern)arg;
            return this.compareTo(pattern) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.elements != null ? this.elements.hashCode() : 0);
        return hash;
    }

    public BitSet getAppearingIn() {
        return this.appearingIn;
    }

    public void setAppearingIn(BitSet appearingIn) {
        this.appearingIn = appearingIn;
    }
}

