/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.SequentialPatterns;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoBIDEPlus {
    long startTime;
    long endTime;
    public int patternCount;
    private int minsuppAbsolute;
    BufferedWriter writer = null;
    private SequentialPatterns patterns = null;
    private int maximumPatternLength = Integer.MAX_VALUE;
    boolean showSequenceIdentifiers = false;
    final int BUFFERS_SIZE = 2000;
    private int[] patternBuffer = new int[2000];
    int sequenceCount = 0;
    SequenceDatabase sequenceDatabase;
    boolean containsItemsetsWithMultipleItems = false;
    Set<Integer> alreadySeen = new HashSet<Integer>();
    Set<Integer> alreadySeenPostfix = new HashSet<Integer>();
    Set<Integer> alreadySeenSuffix = new HashSet<Integer>();
    Map<Integer, Integer> mapItemSupport = new HashMap<Integer, Integer>();
    Map<Integer, Integer> mapsItemSupportPostfix = new HashMap<Integer, Integer>();
    Map<Integer, Integer> mapsItemSupportSuffix = new HashMap<Integer, Integer>();

    public SequentialPatterns runAlgorithm(String inputFile, double minsupRelative, String outputFilePath) throws IOException {
        this.startTime = System.currentTimeMillis();
        this.sequenceDatabase = new SequenceDatabase();
        this.sequenceDatabase.loadFile(inputFile);
        this.sequenceCount = this.sequenceDatabase.size();
        this.minsuppAbsolute = (int)Math.ceil(minsupRelative * (double)this.sequenceCount);
        if (this.minsuppAbsolute == 0) {
            this.minsuppAbsolute = 1;
        }
        this.bide(this.sequenceDatabase, outputFilePath);
        this.sequenceDatabase = null;
        this.endTime = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    public SequentialPatterns runAlgorithm(String inputFile, String outputFilePath, int minsup) throws IOException {
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.minsuppAbsolute = minsup;
        this.startTime = System.currentTimeMillis();
        this.sequenceDatabase = new SequenceDatabase();
        this.sequenceDatabase.loadFile(inputFile);
        this.bide(this.sequenceDatabase, outputFilePath);
        this.sequenceDatabase = null;
        this.endTime = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    private void bide(SequenceDatabase sequenceDatabase, String outputFilePath) throws IOException {
        if (outputFilePath == null) {
            this.writer = null;
            this.patterns = new SequentialPatterns("FREQUENT SEQUENTIAL PATTERNS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        }
        this.sequenceCount = sequenceDatabase.size();
        Map<Integer, List<Integer>> mapSequenceID = this.findSequencesContainingItems();
        if (this.containsItemsetsWithMultipleItems) {
            this.bideWithMultipleItems(mapSequenceID);
        } else {
            this.bideWithSingleItems(mapSequenceID);
        }
    }

    private void bideWithSingleItems(Map<Integer, List<Integer>> mapSequenceID) throws IOException {
        int i = 0;
        while (i < this.sequenceDatabase.size()) {
            int[] sequence = this.sequenceDatabase.getSequences().get(i);
            int currentPosition = 0;
            int j = 0;
            while (j < sequence.length) {
                int token = sequence[j];
                if (token > 0) {
                    boolean isFrequent;
                    boolean bl = isFrequent = mapSequenceID.get(token).size() >= this.minsuppAbsolute;
                    if (isFrequent) {
                        sequence[currentPosition] = token;
                        ++currentPosition;
                    }
                } else if (token == -2) {
                    if (currentPosition > 0) {
                        sequence[currentPosition] = -2;
                        int[] newSequence = new int[currentPosition + 1];
                        System.arraycopy(sequence, 0, newSequence, 0, currentPosition + 1);
                        this.sequenceDatabase.getSequences().set(i, newSequence);
                    } else {
                        this.sequenceDatabase.getSequences().set(i, null);
                    }
                }
                ++j;
            }
            ++i;
        }
        for (Map.Entry<Integer, List<Integer>> entry : mapSequenceID.entrySet()) {
            boolean passBackwardExtensionChecking;
            int item;
            boolean passBackscanPruning;
            int support = entry.getValue().size();
            if (support < this.minsuppAbsolute || !(passBackscanPruning = this.checkBackscanPruningSingleItemsFirstTime(item = entry.getKey().intValue(), entry.getValue()))) continue;
            this.patternBuffer[0] = item;
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabaseSingleItems(item, entry.getValue());
            int maxSupportExtensions = 0;
            if (this.maximumPatternLength > 1) {
                maxSupportExtensions = this.recursionSingleItems(projectedDatabase, 2, 0);
            }
            if (support == maxSupportExtensions || !(passBackwardExtensionChecking = this.checkBackwardExtensionSingleItemsFirstTime(item, entry.getValue()))) continue;
            this.savePattern(item, support, entry.getValue());
        }
    }

    private boolean checkBackscanPruningSingleItemsFirstTime(int item, List<Integer> sequenceIDs) {
        HashMap<Integer, Integer> mapItemSupport = new HashMap<Integer, Integer>();
        int highestSupportUntilNow = 0;
        int k = 0;
        while (k < sequenceIDs.size()) {
            int sid = sequenceIDs.get(k);
            int[] sequence = this.sequenceDatabase.getSequences().get(sid);
            this.alreadySeen.clear();
            int j = 0;
            while (sequence[j] != -2) {
                int token = sequence[j];
                if (token > 0) {
                    if (token == item) break;
                    if (!this.alreadySeen.contains(token)) {
                        Integer itemSupport = (Integer)mapItemSupport.get(token);
                        itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                        if (itemSupport > highestSupportUntilNow) {
                            highestSupportUntilNow = itemSupport;
                        }
                        mapItemSupport.put(token, itemSupport);
                        if (itemSupport.intValue() == sequenceIDs.size()) {
                            return false;
                        }
                        this.alreadySeen.add(token);
                    }
                }
                ++j;
            }
            if (highestSupportUntilNow + (sequenceIDs.size() - k - 1) < sequenceIDs.size()) {
                return true;
            }
            ++k;
        }
        return true;
    }

    private boolean checkBackwardExtensionSingleItemsFirstTime(int item, List<Integer> sequenceIDs) {
        HashMap<Integer, Integer> mapItemSupport = new HashMap<Integer, Integer>();
        int highestSupportUntilNow = 0;
        int k = 0;
        while (k < sequenceIDs.size()) {
            int sid = sequenceIDs.get(k);
            int[] sequence = this.sequenceDatabase.getSequences().get(sid);
            this.alreadySeen.clear();
            boolean foundTheItem = false;
            int j = sequence.length - 1;
            while (j >= 0) {
                int token = sequence[j];
                if (token > 0) {
                    if (token == item) {
                        foundTheItem = true;
                    } else if (foundTheItem && !this.alreadySeen.contains(token)) {
                        Integer itemSupport = (Integer)mapItemSupport.get(token);
                        itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                        if (itemSupport > highestSupportUntilNow) {
                            highestSupportUntilNow = itemSupport;
                        }
                        mapItemSupport.put(token, itemSupport);
                        if (itemSupport.intValue() == sequenceIDs.size()) {
                            return false;
                        }
                        this.alreadySeen.add(token);
                    }
                }
                --j;
            }
            if (highestSupportUntilNow + (sequenceIDs.size() - k - 1) < sequenceIDs.size()) {
                return true;
            }
            ++k;
        }
        return true;
    }

    private void bideWithMultipleItems(Map<Integer, List<Integer>> mapSequenceID) throws IOException {
        int i = 0;
        while (i < this.sequenceDatabase.size()) {
            int[] sequence = this.sequenceDatabase.getSequences().get(i);
            int currentPosition = 0;
            int currentItemsetItemCount = 0;
            int j = 0;
            while (j < sequence.length) {
                int token = sequence[j];
                if (token > 0) {
                    boolean isFrequent;
                    boolean bl = isFrequent = mapSequenceID.get(token).size() >= this.minsuppAbsolute;
                    if (isFrequent) {
                        sequence[currentPosition] = token;
                        ++currentPosition;
                        ++currentItemsetItemCount;
                    }
                } else if (token == -1) {
                    if (currentItemsetItemCount > 0) {
                        sequence[currentPosition] = -1;
                        ++currentPosition;
                        currentItemsetItemCount = 0;
                    }
                } else if (token == -2) {
                    if (currentPosition > 0) {
                        sequence[currentPosition] = -2;
                        int[] newSequence = new int[currentPosition + 1];
                        System.arraycopy(sequence, 0, newSequence, 0, currentPosition + 1);
                        this.sequenceDatabase.getSequences().set(i, newSequence);
                    } else {
                        this.sequenceDatabase.getSequences().set(i, null);
                    }
                }
                ++j;
            }
            ++i;
        }
        for (Map.Entry<Integer, List<Integer>> entry : mapSequenceID.entrySet()) {
            boolean passBackwardExtensionChecking;
            int item;
            boolean passBackscanPruning;
            int support = entry.getValue().size();
            if (support < this.minsuppAbsolute || !(passBackscanPruning = this.checkBackscanPruningMultipleItemsFirstTime(item = entry.getKey().intValue(), entry.getValue()))) continue;
            this.patternBuffer[0] = item;
            List<PseudoSequence> projectedDatabase = this.buildProjectedDatabaseFirstTimeMultipleItems(item, entry.getValue());
            int maxSupportExtensions = 0;
            if (this.maximumPatternLength > 1) {
                maxSupportExtensions = this.recursionMultipleItems(projectedDatabase, 2, 0);
            }
            if (support == maxSupportExtensions || !(passBackwardExtensionChecking = this.checkBackwardExtensionMultipleItemsFirstTime(item, entry.getValue()))) continue;
            this.savePattern(item, support, entry.getValue());
        }
    }

    private boolean checkBackwardExtensionMultipleItemsFirstTime(int item, List<Integer> sequenceIDs) {
        this.mapItemSupport.clear();
        this.mapsItemSupportPostfix.clear();
        int highestSupportUntilNow = 0;
        int k = 0;
        while (k < sequenceIDs.size()) {
            int sid = sequenceIDs.get(k);
            int[] sequence = this.sequenceDatabase.getSequences().get(sid);
            int posItem = 0;
            int j = sequence.length - 1;
            while (true) {
                int token;
                if ((token = sequence[j]) == item) break;
                --j;
            }
            posItem = j;
            this.alreadySeen.clear();
            this.alreadySeenPostfix.clear();
            boolean itemsetContainsItem = true;
            boolean firstTimeContainsItem = posItem > 0 && sequence[posItem - 1] != -1;
            int i = posItem - 1;
            while (i >= 0) {
                int token = sequence[i];
                if (token == -1) {
                    itemsetContainsItem = false;
                    firstTimeContainsItem = false;
                }
                if (token > 0) {
                    Integer itemSupport;
                    boolean couldBeExtension = false;
                    boolean couldBePostfixExtension = false;
                    if (item == token) {
                        itemsetContainsItem = true;
                        couldBeExtension = true;
                    } else {
                        couldBeExtension = !firstTimeContainsItem;
                        couldBePostfixExtension = itemsetContainsItem;
                    }
                    if (couldBePostfixExtension && !this.alreadySeenPostfix.contains(token)) {
                        itemSupport = this.mapsItemSupportPostfix.get(token);
                        itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                        if (itemSupport > highestSupportUntilNow) {
                            highestSupportUntilNow = itemSupport;
                        }
                        this.mapsItemSupportPostfix.put(token, itemSupport);
                        if (itemSupport.intValue() == sequenceIDs.size()) {
                            return false;
                        }
                        this.alreadySeenPostfix.add(token);
                    }
                    if (couldBeExtension && !this.alreadySeen.contains(token)) {
                        itemSupport = this.mapItemSupport.get(token);
                        itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                        if (itemSupport > highestSupportUntilNow) {
                            highestSupportUntilNow = itemSupport;
                        }
                        this.mapItemSupport.put(token, itemSupport);
                        if (itemSupport.intValue() == sequenceIDs.size()) {
                            return false;
                        }
                        this.alreadySeen.add(token);
                    }
                }
                --i;
            }
            if (highestSupportUntilNow + (sequenceIDs.size() - k - 1) < sequenceIDs.size()) {
                return true;
            }
            ++k;
        }
        return true;
    }

    private boolean checkBackscanPruningMultipleItemsFirstTime(int item, List<Integer> sequenceIDs) {
        this.mapItemSupport.clear();
        this.mapsItemSupportPostfix.clear();
        int highestSupportUntilNow = 0;
        int k = 0;
        while (k < sequenceIDs.size()) {
            int token;
            int sid = sequenceIDs.get(k);
            int[] sequence = this.sequenceDatabase.getSequences().get(sid);
            int posItem = 0;
            int posItemset = 0;
            int j = 0;
            while (true) {
                if ((token = sequence[j]) == item) break;
                if (token == -1) {
                    posItemset = j + 1;
                }
                ++j;
            }
            posItem = j;
            this.alreadySeen.clear();
            this.alreadySeenPostfix.clear();
            int i = 0;
            while (i < posItem) {
                token = sequence[i];
                if (token > 0) {
                    Integer itemSupport;
                    if (i < posItemset) {
                        if (!this.alreadySeen.contains(token)) {
                            itemSupport = this.mapItemSupport.get(token);
                            itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                            if (itemSupport > highestSupportUntilNow) {
                                highestSupportUntilNow = itemSupport;
                            }
                            this.mapItemSupport.put(token, itemSupport);
                            if (itemSupport.intValue() == sequenceIDs.size()) {
                                return false;
                            }
                            this.alreadySeen.add(token);
                        }
                    } else if (!this.alreadySeenPostfix.contains(token)) {
                        itemSupport = this.mapsItemSupportPostfix.get(token);
                        itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                        if (itemSupport > highestSupportUntilNow) {
                            highestSupportUntilNow = itemSupport;
                        }
                        this.mapsItemSupportPostfix.put(token, itemSupport);
                        if (itemSupport.intValue() == sequenceIDs.size()) {
                            return false;
                        }
                        this.alreadySeenPostfix.add(token);
                    }
                }
                ++i;
            }
            if (highestSupportUntilNow + (sequenceIDs.size() - k - 1) < sequenceIDs.size()) {
                return true;
            }
            ++k;
        }
        return true;
    }

    private void savePattern(int item, int support, List<Integer> sequenceIDs) throws IOException {
        ++this.patternCount;
        if (this.writer != null) {
            StringBuilder r = new StringBuilder();
            r.append(item);
            r.append(" -1 #SUP: ");
            r.append(support);
            if (this.showSequenceIdentifiers) {
                r.append(" #SID: ");
                for (Integer sid : sequenceIDs) {
                    r.append(sid);
                    r.append(" ");
                }
            }
            this.writer.write(r.toString());
            this.writer.newLine();
        } else {
            SequentialPattern pattern = new SequentialPattern();
            pattern.addItemset(new Itemset(item));
            pattern.setSequenceIDs(sequenceIDs);
            this.patterns.addSequence(pattern, 1);
        }
    }

    private void savePattern(int lastBufferPosition, List<PseudoSequence> pseudoSequences) throws IOException {
        ++this.patternCount;
        if (this.writer != null) {
            StringBuilder r = new StringBuilder();
            int i = 0;
            while (i <= lastBufferPosition) {
                r.append(this.patternBuffer[i]);
                if (!this.containsItemsetsWithMultipleItems) {
                    r.append(" -1");
                }
                r.append(" ");
                ++i;
            }
            if (!this.containsItemsetsWithMultipleItems) {
                r.append("-1 ");
            }
            r.append("#SUP: ");
            r.append(pseudoSequences.size());
            if (this.showSequenceIdentifiers) {
                r.append(" #SID: ");
                for (PseudoSequence sequence : pseudoSequences) {
                    r.append(sequence.sequenceID);
                    r.append(" ");
                }
            }
            this.writer.write(r.toString());
            this.writer.newLine();
        } else {
            SequentialPattern pattern = new SequentialPattern();
            int itemsetCount = 0;
            Itemset currentItemset = new Itemset();
            int i = 0;
            while (i <= lastBufferPosition) {
                int token = this.patternBuffer[i];
                if (token > 0) {
                    currentItemset.addItem(token);
                } else if (token == -1) {
                    pattern.addItemset(currentItemset);
                    currentItemset = new Itemset();
                    ++itemsetCount;
                }
                ++i;
            }
            pattern.addItemset(currentItemset);
            ++itemsetCount;
            ArrayList<Integer> sequencesIDs = new ArrayList<Integer>(pseudoSequences.size());
            int i2 = 0;
            while (i2 < pseudoSequences.size()) {
                sequencesIDs.add(pseudoSequences.get((int)i2).sequenceID);
                ++i2;
            }
            pattern.setSequenceIDs(sequencesIDs);
            this.patterns.addSequence(pattern, itemsetCount);
        }
    }

    private Map<Integer, List<Integer>> findSequencesContainingItems() {
        HashMap<Integer, List<Integer>> mapSequenceID = new HashMap<Integer, List<Integer>>();
        int i = 0;
        while (i < this.sequenceDatabase.size()) {
            int[] sequence = this.sequenceDatabase.getSequences().get(i);
            int itemCountInCurrentItemset = 0;
            int[] nArray = sequence;
            int n = sequence.length;
            int n2 = 0;
            while (n2 < n) {
                int token = nArray[n2];
                if (token > 0) {
                    ArrayList<Integer> sequenceIDs = (ArrayList<Integer>)mapSequenceID.get(token);
                    if (sequenceIDs == null) {
                        sequenceIDs = new ArrayList<Integer>();
                        mapSequenceID.put(token, sequenceIDs);
                    }
                    if (sequenceIDs.size() == 0 || (Integer)sequenceIDs.get(sequenceIDs.size() - 1) != i) {
                        sequenceIDs.add(i);
                    }
                    if (++itemCountInCurrentItemset > 1) {
                        this.containsItemsetsWithMultipleItems = true;
                    }
                } else if (token == -1) {
                    itemCountInCurrentItemset = 0;
                }
                ++n2;
            }
            ++i;
        }
        return mapSequenceID;
    }

    private List<PseudoSequence> buildProjectedDatabaseSingleItems(int item, List<Integer> sequenceIDs) {
        ArrayList<PseudoSequence> projectedDatabase = new ArrayList<PseudoSequence>();
        block0: for (int sequenceID : sequenceIDs) {
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int j = 0;
            while (sequence[j] != -2) {
                int token = sequence[j];
                if (token == item) {
                    if (sequence[j + 1] == -2) continue block0;
                    PseudoSequence pseudoSequence = new PseudoSequence(sequenceID, j + 1);
                    projectedDatabase.add(pseudoSequence);
                    continue block0;
                }
                ++j;
            }
        }
        return projectedDatabase;
    }

    private List<PseudoSequence> buildProjectedDatabaseFirstTimeMultipleItems(int item, List<Integer> sequenceIDs) {
        ArrayList<PseudoSequence> projectedDatabase = new ArrayList<PseudoSequence>();
        block0: for (int sequenceID : sequenceIDs) {
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int j = 0;
            while (sequence[j] != -2) {
                int token = sequence[j];
                if (token == item) {
                    boolean isEndOfSequence;
                    boolean bl = isEndOfSequence = sequence[j + 1] == -1 && sequence[j + 2] == -2;
                    if (isEndOfSequence) continue block0;
                    PseudoSequence pseudoSequence = new PseudoSequence(sequenceID, j + 1);
                    projectedDatabase.add(pseudoSequence);
                    continue block0;
                }
                ++j;
            }
        }
        return projectedDatabase;
    }

    private int recursionSingleItems(List<PseudoSequence> database, int k, int lastBufferPosition) throws IOException {
        int maxSupport = 0;
        Map<Integer, List<PseudoSequence>> itemsPseudoSequences = this.findAllFrequentPairsSingleItems(database, lastBufferPosition);
        database = null;
        for (Map.Entry<Integer, List<PseudoSequence>> entry : itemsPseudoSequences.entrySet()) {
            boolean passBackwardExtensionChecking;
            int support = entry.getValue().size();
            if (support < this.minsuppAbsolute) continue;
            if (support > maxSupport) {
                maxSupport = support;
            }
            this.patternBuffer[lastBufferPosition + 1] = entry.getKey();
            boolean passBackscanPruning = this.checkBackscanPruningSingleItems(lastBufferPosition + 1, entry.getValue());
            if (!passBackscanPruning) continue;
            int maxSupportExtensions = 0;
            if (k < this.maximumPatternLength) {
                maxSupportExtensions = this.recursionSingleItems(entry.getValue(), k + 1, lastBufferPosition + 1);
            }
            if (support == maxSupportExtensions || !(passBackwardExtensionChecking = this.checkBackwardExtensionSingleItems(lastBufferPosition + 1, entry.getValue()))) continue;
            this.savePattern(lastBufferPosition + 1, entry.getValue());
        }
        MemoryLogger.getInstance().checkMemory();
        return maxSupport;
    }

    private boolean checkBackscanPruningSingleItems(int lastBufferPosition, List<PseudoSequence> projectedDatabase) {
        int i = 0;
        while (i <= lastBufferPosition) {
            int highestSupportUntilNow = 0;
            this.mapItemSupport.clear();
            int k = 0;
            while (k < projectedDatabase.size()) {
                block9: {
                    PseudoSequence pseudoSequence = projectedDatabase.get(k);
                    int sid = pseudoSequence.getOriginalSequenceID();
                    int[] sequence = this.sequenceDatabase.getSequences().get(sid);
                    int currentPositionToMatch = 0;
                    this.alreadySeen.clear();
                    int j = 0;
                    while (sequence[j] != -2) {
                        int token = sequence[j];
                        if (token > 0) {
                            if (token == this.patternBuffer[currentPositionToMatch]) {
                                if (i == currentPositionToMatch) break block9;
                                ++currentPositionToMatch;
                            } else if (!this.alreadySeen.contains(token) && currentPositionToMatch == i) {
                                Integer itemSupport = this.mapItemSupport.get(token);
                                itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                                if (itemSupport > highestSupportUntilNow) {
                                    highestSupportUntilNow = itemSupport;
                                }
                                this.mapItemSupport.put(token, itemSupport);
                                if (itemSupport.intValue() == projectedDatabase.size()) {
                                    return false;
                                }
                                this.alreadySeen.add(token);
                            }
                        }
                        ++j;
                    }
                    if (highestSupportUntilNow + (projectedDatabase.size() - k - 1) < projectedDatabase.size()) break;
                }
                ++k;
            }
            ++i;
        }
        return true;
    }

    private boolean checkBackwardExtensionSingleItems(int lastBufferPosition, List<PseudoSequence> projectedDatabase) {
        int i = 0;
        while (i <= lastBufferPosition) {
            int highestSupportUntilNow = 0;
            this.mapItemSupport.clear();
            int k = 0;
            while (k < projectedDatabase.size()) {
                PseudoSequence pseudoSequence = projectedDatabase.get(k);
                int sid = pseudoSequence.getOriginalSequenceID();
                int[] sequence = this.sequenceDatabase.getSequences().get(sid);
                int currentPositionToMatch1 = 0;
                int posAfterFirstInstance = 0;
                if (i != 0) {
                    int j = 0;
                    while (j < sequence.length) {
                        int token = sequence[j];
                        if (token > 0 && token == this.patternBuffer[currentPositionToMatch1]) {
                            if (currentPositionToMatch1 == i - 1) {
                                posAfterFirstInstance = j + 1;
                                break;
                            }
                            ++currentPositionToMatch1;
                        }
                        ++j;
                    }
                }
                int currentPositionToMatch = lastBufferPosition;
                this.alreadySeen.clear();
                int j = sequence.length - 1;
                while (j >= posAfterFirstInstance) {
                    int token = sequence[j];
                    if (token > 0) {
                        if (currentPositionToMatch >= i && token == this.patternBuffer[currentPositionToMatch]) {
                            --currentPositionToMatch;
                        } else if (currentPositionToMatch == i - 1 && !this.alreadySeen.contains(token)) {
                            Integer itemSupport = this.mapItemSupport.get(token);
                            itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                            if (itemSupport > highestSupportUntilNow) {
                                highestSupportUntilNow = itemSupport;
                            }
                            this.mapItemSupport.put(token, itemSupport);
                            if (itemSupport.intValue() == projectedDatabase.size()) {
                                return false;
                            }
                            this.alreadySeen.add(token);
                        }
                    }
                    --j;
                }
                if (highestSupportUntilNow + (projectedDatabase.size() - k - 1) < projectedDatabase.size()) break;
                ++k;
            }
            ++i;
        }
        return true;
    }

    private int recursionMultipleItems(List<PseudoSequence> database, int k, int lastBufferPosition) throws IOException {
        boolean passBackwardExtensionChecking;
        int maxSupportExtensions;
        boolean passBackscanPruning;
        int newBuferPosition;
        int support;
        Pair pair;
        int maxSupport = 0;
        MapFrequentPairs mapsPairs = this.findAllFrequentPairs(database, lastBufferPosition);
        database = null;
        for (Map.Entry<Pair, Pair> entry : mapsPairs.mapPairsInPostfix.entrySet()) {
            pair = entry.getKey();
            support = pair.getCount();
            if (pair.getCount() < this.minsuppAbsolute) continue;
            if (support > maxSupport) {
                maxSupport = support;
            }
            newBuferPosition = lastBufferPosition;
            this.patternBuffer[++newBuferPosition] = pair.item;
            passBackscanPruning = this.checkBackscanPruningMultipleItems(newBuferPosition, entry.getValue().getPseudoSequences());
            if (!passBackscanPruning) continue;
            maxSupportExtensions = 0;
            if (k < this.maximumPatternLength) {
                maxSupportExtensions = this.recursionMultipleItems(pair.getPseudoSequences(), k + 1, newBuferPosition);
            }
            if (support == maxSupportExtensions || !(passBackwardExtensionChecking = this.checkBackwardExtensionMultipleItems(newBuferPosition, entry.getValue().getPseudoSequences()))) continue;
            this.savePattern(newBuferPosition, pair.getPseudoSequences());
        }
        for (Map.Entry<Pair, Pair> entry : mapsPairs.mapPairs.entrySet()) {
            pair = entry.getKey();
            support = pair.getCount();
            if (support < this.minsuppAbsolute) continue;
            if (support > maxSupport) {
                maxSupport = support;
            }
            newBuferPosition = lastBufferPosition;
            this.patternBuffer[++newBuferPosition] = -1;
            this.patternBuffer[++newBuferPosition] = pair.item;
            passBackscanPruning = this.checkBackscanPruningMultipleItems(newBuferPosition, entry.getValue().getPseudoSequences());
            if (!passBackscanPruning) continue;
            maxSupportExtensions = 0;
            if (k < this.maximumPatternLength) {
                maxSupportExtensions = this.recursionMultipleItems(pair.getPseudoSequences(), k + 1, newBuferPosition);
            }
            if (support == maxSupportExtensions || !(passBackwardExtensionChecking = this.checkBackwardExtensionMultipleItems(newBuferPosition, entry.getValue().getPseudoSequences()))) continue;
            this.savePattern(newBuferPosition, pair.getPseudoSequences());
        }
        MemoryLogger.getInstance().checkMemory();
        return maxSupport;
    }

    private boolean checkBackwardExtensionMultipleItems(int lastBufferPosition, List<PseudoSequence> sequences) {
        int i = 0;
        while (i <= lastBufferPosition) {
            int highestSupportUntilNow = 0;
            if (this.patternBuffer[i] != -1) {
                this.mapItemSupport.clear();
                this.mapsItemSupportPostfix.clear();
                this.mapsItemSupportSuffix.clear();
                int k = 0;
                while (k < sequences.size()) {
                    PseudoSequence pseudoSequence = sequences.get(k);
                    int sid = pseudoSequence.getOriginalSequenceID();
                    int[] sequence = this.sequenceDatabase.getSequences().get(sid);
                    this.alreadySeen.clear();
                    this.alreadySeenPostfix.clear();
                    this.alreadySeenSuffix.clear();
                    int currentPositionToMatch = 0;
                    int positionToMatchAtBeginingOfCurrentItemset = 0;
                    int posItemFirst = 0;
                    int posItemsetFirst = 0;
                    if (i > 0) {
                        int j = 0;
                        while (true) {
                            int token;
                            if ((token = sequence[j]) == -1) {
                                if (this.patternBuffer[currentPositionToMatch] == -1) {
                                    positionToMatchAtBeginingOfCurrentItemset = currentPositionToMatch;
                                } else {
                                    currentPositionToMatch = positionToMatchAtBeginingOfCurrentItemset;
                                }
                                posItemsetFirst = j;
                            }
                            if (token == this.patternBuffer[currentPositionToMatch]) {
                                if (currentPositionToMatch == i - 1) {
                                    posItemFirst = j + 1;
                                    break;
                                }
                                if (currentPositionToMatch == i - 2 && this.patternBuffer[currentPositionToMatch + 1] == -1) {
                                    posItemFirst = j + 1;
                                    break;
                                }
                                ++currentPositionToMatch;
                            }
                            ++j;
                        }
                    }
                    int posItemLast = sequence.length - 1;
                    int posLastItemset = 99999;
                    currentPositionToMatch = lastBufferPosition;
                    positionToMatchAtBeginingOfCurrentItemset = lastBufferPosition;
                    int j = posItemLast;
                    while (true) {
                        int token;
                        if ((token = sequence[j]) == -1) {
                            if (this.patternBuffer[currentPositionToMatch] == -1) {
                                positionToMatchAtBeginingOfCurrentItemset = currentPositionToMatch;
                            } else {
                                currentPositionToMatch = positionToMatchAtBeginingOfCurrentItemset;
                            }
                        }
                        if (token == this.patternBuffer[currentPositionToMatch]) {
                            if (currentPositionToMatch == i) {
                                posItemLast = j - 1;
                                while (j >= 0 && sequence[j] != -1) {
                                    --j;
                                }
                                break;
                            }
                            --currentPositionToMatch;
                        }
                        --j;
                    }
                    posLastItemset = j + 1;
                    boolean firstItemstIsCut = i != 0 && sequence[posItemFirst] != -1;
                    boolean lastItemsetIsCut = posItemLast >= 0 && sequence[posItemLast] != -1;
                    boolean inFirstPostfix = firstItemstIsCut;
                    if (lastItemsetIsCut) {
                        int posToMatch = posItemLast + 1;
                        inFirstPostfix = false;
                        int j2 = posItemFirst;
                        while (j2 <= posItemLast) {
                            if (sequence[posItemFirst] == sequence[posToMatch] && sequence[++posToMatch] == -1) {
                                inFirstPostfix = true;
                                break;
                            }
                            ++j2;
                        }
                    } else {
                        inFirstPostfix = true;
                    }
                    boolean inAnotherPostfix = false;
                    int postfixItemToMatch = posItemsetFirst;
                    int j3 = posItemFirst;
                    while (j3 <= posItemLast) {
                        int token = sequence[j3];
                        if (token == -1) {
                            inFirstPostfix = false;
                            inAnotherPostfix = false;
                            postfixItemToMatch = posItemsetFirst;
                            if (this.patternBuffer[postfixItemToMatch] == -1) {
                                ++postfixItemToMatch;
                            }
                        }
                        if (token > 0) {
                            boolean justMatched = false;
                            if (!(inAnotherPostfix || i == 0 || this.patternBuffer[postfixItemToMatch] != token || --postfixItemToMatch >= 0 && this.patternBuffer[postfixItemToMatch] != -1)) {
                                inAnotherPostfix = true;
                                if (lastItemsetIsCut) {
                                    int posToMatch = posItemLast + 1;
                                    inFirstPostfix = false;
                                    int w = j3;
                                    while (w <= posItemLast) {
                                        if (sequence[w] == sequence[posToMatch] && sequence[++posToMatch] == -1) {
                                            inAnotherPostfix = true;
                                            break;
                                        }
                                        ++w;
                                    }
                                }
                                justMatched = true;
                            }
                            if ((inFirstPostfix || inAnotherPostfix && !justMatched) && !this.alreadySeenPostfix.contains(token)) {
                                Integer itemSupport = this.mapsItemSupportPostfix.get(token);
                                itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                                if (itemSupport.intValue() == sequences.size()) {
                                    return false;
                                }
                                if (itemSupport > highestSupportUntilNow) {
                                    highestSupportUntilNow = itemSupport;
                                }
                                this.mapsItemSupportPostfix.put(token, itemSupport);
                                this.alreadySeenPostfix.add(token);
                            }
                            if (j3 >= posLastItemset && !this.alreadySeenSuffix.contains(token)) {
                                Integer itemSupport = this.mapsItemSupportSuffix.get(token);
                                itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                                if (itemSupport.intValue() == sequences.size()) {
                                    return false;
                                }
                                if (itemSupport > highestSupportUntilNow) {
                                    highestSupportUntilNow = itemSupport;
                                }
                                this.mapsItemSupportSuffix.put(token, itemSupport);
                                this.alreadySeenSuffix.add(token);
                            }
                            if (!inFirstPostfix && j3 < posLastItemset && !this.alreadySeen.contains(token)) {
                                Integer itemSupport = this.mapItemSupport.get(token);
                                itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                                if (itemSupport.intValue() == sequences.size()) {
                                    return false;
                                }
                                if (itemSupport > highestSupportUntilNow) {
                                    highestSupportUntilNow = itemSupport;
                                }
                                this.mapItemSupport.put(token, itemSupport);
                                this.alreadySeen.add(token);
                            }
                        }
                        ++j3;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean checkBackscanPruningMultipleItems(int lastBufferPosition, List<PseudoSequence> sequences) {
        int i = 0;
        while (i <= lastBufferPosition) {
            int highestSupportUntilNow = 0;
            if (this.patternBuffer[i] != -1) {
                this.mapItemSupport.clear();
                this.mapsItemSupportPostfix.clear();
                this.mapsItemSupportSuffix.clear();
                int k = 0;
                while (k < sequences.size()) {
                    PseudoSequence pseudoSequence = sequences.get(k);
                    int sid = pseudoSequence.getOriginalSequenceID();
                    int[] sequence = this.sequenceDatabase.getSequences().get(sid);
                    this.alreadySeen.clear();
                    this.alreadySeenPostfix.clear();
                    this.alreadySeenSuffix.clear();
                    int currentPositionToMatch = 0;
                    int positionToMatchAtBeginingOfCurrentItemset = 0;
                    int posItemFirst = 0;
                    int posItemsetFirst = 0;
                    if (i > 0) {
                        int j = 0;
                        while (true) {
                            int token;
                            if ((token = sequence[j]) == -1) {
                                if (this.patternBuffer[currentPositionToMatch] == -1) {
                                    positionToMatchAtBeginingOfCurrentItemset = currentPositionToMatch;
                                } else {
                                    currentPositionToMatch = positionToMatchAtBeginingOfCurrentItemset;
                                }
                                posItemsetFirst = j;
                            }
                            if (token == this.patternBuffer[currentPositionToMatch]) {
                                if (currentPositionToMatch == i - 1) {
                                    if (this.patternBuffer[currentPositionToMatch] == -1) break;
                                    posItemFirst = j + 1;
                                    break;
                                }
                                if (token != -1) {
                                    posItemFirst = j + 1;
                                }
                                ++currentPositionToMatch;
                            }
                            ++j;
                        }
                    }
                    currentPositionToMatch = i;
                    int posItemLast = -999;
                    int posLastItemset = posItemFirst;
                    int j = posItemFirst;
                    while (true) {
                        int token;
                        if ((token = sequence[j]) == -1) {
                            currentPositionToMatch = i;
                            posLastItemset = j + 1;
                            posItemLast = -999;
                        }
                        if (token > 0 && token == this.patternBuffer[currentPositionToMatch]) {
                            if (posItemLast == -999) {
                                posItemLast = j - 1;
                            }
                            if (currentPositionToMatch == lastBufferPosition || this.patternBuffer[++currentPositionToMatch] == -1) break;
                        }
                        ++j;
                    }
                    if (lastBufferPosition == 3 && this.patternBuffer[3] == 6 && this.patternBuffer[0] == 4 && i == 3 && sid == 3) {
                        System.out.println(i);
                        System.out.println();
                    }
                    boolean firstItemstIsCut = i != 0 && sequence[posItemFirst] != -1;
                    boolean lastItemsetIsCut = posItemLast >= 0 && sequence[posItemLast] != -1;
                    boolean inFirstPostfix = firstItemstIsCut;
                    if (lastItemsetIsCut) {
                        int posToMatch = posItemLast + 1;
                        inFirstPostfix = false;
                        int j2 = posItemFirst;
                        while (j2 <= posItemLast) {
                            if (sequence[posItemFirst] == sequence[posToMatch] && sequence[++posToMatch] == -1) {
                                inFirstPostfix = true;
                                break;
                            }
                            ++j2;
                        }
                    } else {
                        inFirstPostfix = true;
                    }
                    boolean inAnotherPostfix = false;
                    int postfixItemToMatch = posItemsetFirst;
                    int j3 = posItemFirst;
                    while (j3 <= posItemLast) {
                        int token = sequence[j3];
                        if (token == -1) {
                            inFirstPostfix = false;
                            inAnotherPostfix = false;
                            postfixItemToMatch = posItemsetFirst;
                        }
                        if (token > 0) {
                            boolean justMatched = false;
                            if (!(inAnotherPostfix || i == 0 || this.patternBuffer[postfixItemToMatch] != token || --postfixItemToMatch >= 0 && this.patternBuffer[postfixItemToMatch] != -1)) {
                                inAnotherPostfix = true;
                                if (lastItemsetIsCut) {
                                    int posToMatch = posItemLast + 1;
                                    inFirstPostfix = false;
                                    int w = j3;
                                    while (w <= posItemLast) {
                                        if (sequence[w] == sequence[posToMatch] && sequence[++posToMatch] == -1) {
                                            inAnotherPostfix = true;
                                            break;
                                        }
                                        ++w;
                                    }
                                }
                                justMatched = true;
                            }
                            if ((inFirstPostfix || inAnotherPostfix && !justMatched) && !this.alreadySeenPostfix.contains(token)) {
                                Integer itemSupport = this.mapsItemSupportPostfix.get(token);
                                itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                                if (itemSupport.intValue() == sequences.size()) {
                                    return false;
                                }
                                if (itemSupport > highestSupportUntilNow) {
                                    highestSupportUntilNow = itemSupport;
                                }
                                this.mapsItemSupportPostfix.put(token, itemSupport);
                                this.alreadySeenPostfix.add(token);
                            }
                            if (j3 >= posLastItemset && !this.alreadySeenSuffix.contains(token)) {
                                Integer itemSupport = this.mapsItemSupportSuffix.get(token);
                                itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                                if (itemSupport.intValue() == sequences.size()) {
                                    return false;
                                }
                                if (itemSupport > highestSupportUntilNow) {
                                    highestSupportUntilNow = itemSupport;
                                }
                                this.mapsItemSupportSuffix.put(token, itemSupport);
                                this.alreadySeenSuffix.add(token);
                            }
                            if (!inFirstPostfix && j3 < posLastItemset && !this.alreadySeen.contains(token)) {
                                Integer itemSupport = this.mapItemSupport.get(token);
                                itemSupport = itemSupport == null ? Integer.valueOf(1) : Integer.valueOf(itemSupport + 1);
                                if (itemSupport.intValue() == sequences.size()) {
                                    return false;
                                }
                                if (itemSupport > highestSupportUntilNow) {
                                    highestSupportUntilNow = itemSupport;
                                }
                                this.mapItemSupport.put(token, itemSupport);
                                this.alreadySeen.add(token);
                            }
                        }
                        ++j3;
                    }
                    if (highestSupportUntilNow + (sequences.size() - k - 1) < sequences.size()) break;
                    ++k;
                }
            }
            ++i;
        }
        return true;
    }

    protected Map<Integer, List<PseudoSequence>> findAllFrequentPairsSingleItems(List<PseudoSequence> sequences, int lastBufferPosition) {
        HashMap<Integer, List<PseudoSequence>> mapItemsPseudoSequences = new HashMap<Integer, List<PseudoSequence>>();
        for (PseudoSequence pseudoSequence : sequences) {
            int sequenceID = pseudoSequence.getOriginalSequenceID();
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int i = pseudoSequence.indexFirstItem;
            while (sequence[i] != -2) {
                int token = sequence[i];
                if (token > 0) {
                    ArrayList<PseudoSequence> listSequences = (ArrayList<PseudoSequence>)mapItemsPseudoSequences.get(token);
                    if (listSequences == null) {
                        listSequences = new ArrayList<PseudoSequence>();
                        mapItemsPseudoSequences.put(token, listSequences);
                    }
                    boolean ok = true;
                    if (listSequences.size() > 0) {
                        boolean bl = ok = ((PseudoSequence)listSequences.get((int)(listSequences.size() - 1))).sequenceID != sequenceID;
                    }
                    if (ok) {
                        listSequences.add(new PseudoSequence(sequenceID, i + 1));
                    }
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapItemsPseudoSequences;
    }

    protected MapFrequentPairs findAllFrequentPairs(List<PseudoSequence> sequences, int lastBufferPosition) {
        MapFrequentPairs mapsPairs = new MapFrequentPairs();
        int firstPositionOfLastItemsetInBuffer = lastBufferPosition;
        while (lastBufferPosition > 0) {
            if (--firstPositionOfLastItemsetInBuffer >= 0 && this.patternBuffer[firstPositionOfLastItemsetInBuffer] != -1) continue;
            ++firstPositionOfLastItemsetInBuffer;
            break;
        }
        int positionToBeMatched = firstPositionOfLastItemsetInBuffer;
        for (PseudoSequence pseudoSequence : sequences) {
            int sequenceID = pseudoSequence.getOriginalSequenceID();
            int[] sequence = this.sequenceDatabase.getSequences().get(sequenceID);
            int previousItem = sequence[pseudoSequence.indexFirstItem - 1];
            boolean currentItemsetIsPostfix = previousItem != -1;
            boolean isFirstItemset = true;
            int i = pseudoSequence.indexFirstItem;
            while (sequence[i] != -2) {
                int token = sequence[i];
                if (token > 0) {
                    Pair pair = new Pair(token);
                    Pair oldPair = currentItemsetIsPostfix ? mapsPairs.mapPairsInPostfix.get(pair) : mapsPairs.mapPairs.get(pair);
                    if (oldPair == null) {
                        if (currentItemsetIsPostfix) {
                            mapsPairs.mapPairsInPostfix.put(pair, pair);
                        } else {
                            mapsPairs.mapPairs.put(pair, pair);
                        }
                    } else {
                        pair = oldPair;
                    }
                    boolean ok = true;
                    if (pair.getPseudoSequences().size() > 0) {
                        boolean bl = ok = pair.getPseudoSequences().get((int)(pair.getPseudoSequences().size() - 1)).sequenceID != sequenceID;
                    }
                    if (ok) {
                        pair.getPseudoSequences().add(new PseudoSequence(sequenceID, i + 1));
                    }
                    if (currentItemsetIsPostfix && !isFirstItemset) {
                        pair = new Pair(token);
                        oldPair = mapsPairs.mapPairs.get(pair);
                        if (oldPair == null) {
                            mapsPairs.mapPairs.put(pair, pair);
                        } else {
                            pair = oldPair;
                        }
                        ok = true;
                        if (pair.getPseudoSequences().size() > 0) {
                            boolean bl = ok = pair.getPseudoSequences().get((int)(pair.getPseudoSequences().size() - 1)).sequenceID != sequenceID;
                        }
                        if (ok) {
                            pair.getPseudoSequences().add(new PseudoSequence(sequenceID, i + 1));
                        }
                    }
                    if (!currentItemsetIsPostfix && this.patternBuffer[positionToBeMatched] == token && ++positionToBeMatched > lastBufferPosition) {
                        currentItemsetIsPostfix = true;
                    }
                } else if (token == -1) {
                    isFirstItemset = false;
                    currentItemsetIsPostfix = false;
                    positionToBeMatched = firstPositionOfLastItemsetInBuffer;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        return mapsPairs;
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("============  BIDE+ - SPMF 0.99c - 2016 - STATISTICS =====\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append('\n');
        r.append(" minsup = " + this.minsuppAbsolute + " sequences.");
        r.append('\n');
        r.append(" Pattern count : ");
        r.append(this.patternCount);
        r.append('\n');
        r.append("==========================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void setShowSequenceIdentifiers(boolean showSequenceIdentifiers) {
        this.showSequenceIdentifiers = showSequenceIdentifiers;
    }

    public class MapFrequentPairs {
        public final Map<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        public final Map<Pair, Pair> mapPairsInPostfix = new HashMap<Pair, Pair>();
    }
}

