/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.currentDebug;

import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class SequentialPattern
implements Comparable<SequentialPattern> {
    private final List<Itemset> itemsets = new ArrayList<Itemset>();
    private List<Integer> sequencesIds;

    public void setSequenceIDs(List<Integer> sequencesIds) {
        this.sequencesIds = sequencesIds;
    }

    public String getRelativeSupportFormated(int sequencecount) {
        double relSupport = (double)this.sequencesIds.size() / (double)sequencecount;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(relSupport);
    }

    public int getAbsoluteSupport() {
        return this.sequencesIds.size();
    }

    public void addItemset(Itemset itemset) {
        this.itemsets.add(itemset);
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset : this.itemsets) {
            r.append('(');
            for (Integer item : itemset.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append(')');
        }
        return r.append("    ").toString();
    }

    public String itemsetsToString() {
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset : this.itemsets) {
            r.append('{');
            for (Integer item : itemset.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append('}');
        }
        return r.append("    ").toString();
    }

    public List<Itemset> getItemsets() {
        return this.itemsets;
    }

    public Itemset get(int index) {
        return this.itemsets.get(index);
    }

    public int size() {
        return this.itemsets.size();
    }

    public List<Integer> getSequenceIDs() {
        return this.sequencesIds;
    }

    @Override
    public int compareTo(SequentialPattern o) {
        if (o == this) {
            return 0;
        }
        int compare = this.getAbsoluteSupport() - o.getAbsoluteSupport();
        if (compare != 0) {
            return compare;
        }
        return this.hashCode() - o.hashCode();
    }
}

