/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.EquivalenceClass;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.FrequentPatternEnumeration_SPAM;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.Saver;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.SaverIntoFile;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.SaverIntoMemory;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AlgoSPAM_AGP {
    protected double minSupRelative;
    protected double minSupAbsolute;
    Saver saver = null;
    protected long start;
    protected long end;
    protected List<EquivalenceClass> frequentItems;
    private int numberOfFrequentPatterns;

    public AlgoSPAM_AGP(double minsupRelative) {
        this.minSupRelative = minsupRelative;
    }

    public void runAlgorithm(SequenceDatabase database, boolean keepPatterns, boolean verbose, String outputFilePath, boolean outputSequenceIdentifiers) throws IOException {
        this.saver = outputFilePath == null ? new SaverIntoMemory(outputSequenceIdentifiers) : new SaverIntoFile(outputFilePath, outputSequenceIdentifiers);
        this.minSupAbsolute = (int)Math.ceil(this.minSupRelative * (double)database.size());
        if (this.minSupAbsolute == 0.0) {
            this.minSupAbsolute = 1.0;
        }
        MemoryLogger.getInstance().reset();
        this.start = System.currentTimeMillis();
        this.runSPAM(database, (long)this.minSupAbsolute, keepPatterns, verbose);
        this.end = System.currentTimeMillis();
        this.saver.finish();
    }

    protected void runSPAM(SequenceDatabase database, long minSupportAbsolute, boolean keepPatterns, boolean verbose) {
        this.frequentItems = database.frequentItems();
        Collection<Pattern> size1sequences = this.getPatterns(this.frequentItems);
        if (keepPatterns) {
            for (Pattern atom : size1sequences) {
                this.saver.savePattern(atom);
            }
        }
        database = null;
        EquivalenceClass rootClass = new EquivalenceClass(null);
        for (EquivalenceClass atom : this.frequentItems) {
            rootClass.addClassMember(atom);
        }
        FrequentPatternEnumeration_SPAM frequentPatternEnumeration = new FrequentPatternEnumeration_SPAM(this.minSupAbsolute, this.saver);
        frequentPatternEnumeration.execute(rootClass, keepPatterns, verbose);
        this.numberOfFrequentPatterns = frequentPatternEnumeration.getFrequentPatterns();
        MemoryLogger.getInstance().checkMemory();
    }

    private Collection<Pattern> getPatterns(List<EquivalenceClass> equivalenceClasses) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (EquivalenceClass equivalenceClass : equivalenceClasses) {
            Pattern frequentPattern = equivalenceClass.getClassIdentifier();
            patterns.add(frequentPattern);
        }
        return patterns;
    }

    public String printStatistics() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        sb.append(this.getRunningTime());
        sb.append(" ms\n");
        sb.append(" Frequent sequences count : ");
        sb.append(this.numberOfFrequentPatterns);
        sb.append('\n');
        sb.append(" Max memory (mb):");
        sb.append(MemoryLogger.getInstance().getMaxMemory());
        sb.append('\n');
        sb.append(this.saver.print());
        sb.append("\n===================================================\n");
        return sb.toString();
    }

    public int getNumberOfFrequentPatterns() {
        return this.numberOfFrequentPatterns;
    }

    public long getRunningTime() {
        return this.end - this.start;
    }

    public double getMinSupRelative() {
        return this.minSupAbsolute;
    }

    public void clear() {
        this.frequentItems.clear();
        if (this.saver != null) {
            this.saver.clear();
            this.saver = null;
        }
    }
}

