/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.database;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.EquivalenceClass;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.ItemFactory;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.creators.ItemAbstractionPairCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.PatternCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.IDList;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.idLists.creators.IdListCreator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SequenceDatabase {
    private AbstractionCreator abstractionCreator;
    private IdListCreator idListCreator;
    private Map<Item, EquivalenceClass> frequentItems = new HashMap<Item, EquivalenceClass>();
    private List<Sequence> sequences = new LinkedList<Sequence>();
    private ItemFactory<Integer> itemFactory = new ItemFactory();
    private PatternCreator patternCreator = PatternCreator.getInstance();
    private int nSequences = 1;

    public SequenceDatabase(AbstractionCreator abstractionCreator, IdListCreator idListCreator) {
        this.abstractionCreator = abstractionCreator;
        this.idListCreator = idListCreator;
    }

    public void loadFile(String path, double minSupport) throws IOException {
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(path));
                myInput = new BufferedReader(new InputStreamReader(fin));
                while ((thisLine = myInput.readLine()) != null) {
                    if (thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                    this.addSequence(thisLine.split(" "));
                }
                double support = (int)Math.ceil(minSupport * (double)this.sequences.size());
                Set<Item> frequentItemsSet = this.frequentItems.keySet();
                HashSet<Item> itemsToRemove = new HashSet<Item>();
                for (Item item : frequentItemsSet) {
                    EquivalenceClass equivalenceClass = this.frequentItems.get(item);
                    if ((double)equivalenceClass.getIdList().getSupport() < support) {
                        itemsToRemove.add(item);
                        continue;
                    }
                    equivalenceClass.getIdList().setAppearingSequences(equivalenceClass.getClassIdentifier());
                }
                for (Item<Object> item : itemsToRemove) {
                    this.frequentItems.remove(item);
                }
                this.reduceDatabase(this.frequentItems.keySet());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    public void addSequence(String[] integers) {
        int beginning;
        ItemAbstractionPairCreator pairCreator = ItemAbstractionPairCreator.getInstance();
        long timestamp = -1L;
        Sequence sequence = new Sequence(this.sequences.size());
        Itemset itemset = new Itemset();
        sequence.setID(this.nSequences);
        ++this.nSequences;
        int i = beginning = 0;
        while (i < integers.length) {
            if (integers[i].codePointAt(0) == 60) {
                String value = integers[i].substring(1, integers[i].length() - 1);
                timestamp = Long.parseLong(value);
                itemset.setTimestamp(timestamp);
            } else if (integers[i].equals("-1")) {
                long time = itemset.getTimestamp() + 1L;
                sequence.addItemset(itemset);
                itemset = new Itemset();
                itemset.setTimestamp(time);
                ++timestamp;
            } else if (integers[i].equals("-2")) {
                this.sequences.add(sequence);
            } else {
                IDList idlist;
                Item item = this.itemFactory.getItem(Integer.parseInt(integers[i]));
                EquivalenceClass clase = this.frequentItems.get(item);
                if (clase == null) {
                    idlist = this.idListCreator.create();
                    clase = new EquivalenceClass(this.patternCreator.createPattern(pairCreator.getItemAbstractionPair(item, this.abstractionCreator.createDefaultAbstraction())), idlist);
                    this.frequentItems.put(item, clase);
                }
                idlist = clase.getIdList();
                if (timestamp < 0L) {
                    timestamp = 1L;
                    itemset.setTimestamp(timestamp);
                }
                this.idListCreator.addAppearance(idlist, sequence.getId(), (int)timestamp);
                itemset.addItem(item);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Sequence sequence : this.sequences) {
            r.append(sequence.getId());
            r.append(":  ");
            r.append(sequence.toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public List<EquivalenceClass> frequentItems() {
        ArrayList<EquivalenceClass> celdasDeItemsFrecuentes = new ArrayList<EquivalenceClass>(this.frequentItems.values());
        Collections.sort(celdasDeItemsFrecuentes);
        return celdasDeItemsFrecuentes;
    }

    public Map<Item, EquivalenceClass> getFrequentItems() {
        return this.frequentItems;
    }

    public List<EquivalenceClass> getSize2FrecuentSequences(double minSupport) {
        List<EquivalenceClass> patronesSize2 = this.abstractionCreator.getFrequentSize2Sequences(this.sequences, this.idListCreator);
        this.removeInfrequentItems(patronesSize2, minSupport);
        for (EquivalenceClass clase : patronesSize2) {
            clase.getIdList().setAppearingSequences(clase.getClassIdentifier());
        }
        return patronesSize2;
    }

    private void removeInfrequentItems(List<EquivalenceClass> size2Patterns, double minSupport) {
        if (size2Patterns.isEmpty()) {
            return;
        }
        Item currentItem = size2Patterns.get(0).getClassIdentifier().getElements().get(0).getItem();
        EquivalenceClass value = this.frequentItems.get(currentItem);
        ArrayList<Integer> infrequentItems = new ArrayList<Integer>();
        int i = 0;
        while (i < size2Patterns.size()) {
            Item nuevoItem = size2Patterns.get(i).getClassIdentifier().getElements().get(0).getItem();
            if (!nuevoItem.equals(currentItem)) {
                currentItem = nuevoItem;
                value = this.frequentItems.get(currentItem);
            }
            if ((double)size2Patterns.get(i).getIdList().getSupport() < minSupport) {
                infrequentItems.add(i);
            } else {
                value.addClassMember(size2Patterns.get(i));
            }
            ++i;
        }
        i = infrequentItems.size() - 1;
        while (i >= 0) {
            EquivalenceClass equivalenceClass = size2Patterns.remove((Integer)infrequentItems.get(i));
            --i;
        }
        Collections.sort(infrequentItems);
    }

    private void reduceDatabase(Set<Item> keySet) {
        for (Sequence sequence : this.sequences) {
            int i = 0;
            while (i < sequence.size()) {
                Itemset itemset = sequence.get(i);
                int j = 0;
                while (j < itemset.size()) {
                    Item item = itemset.get(j);
                    if (!keySet.contains(item)) {
                        sequence.remove(i, j);
                        --j;
                    }
                    ++j;
                }
                if (itemset.size() == 0) {
                    sequence.remove(i);
                    --i;
                }
                ++i;
            }
        }
    }

    public void clear() {
        if (this.sequences != null) {
            this.sequences.clear();
        }
        this.sequences = null;
        if (this.frequentItems != null) {
            this.frequentItems.clear();
        }
        this.frequentItems = null;
        this.itemFactory = null;
    }
}

