/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers;

import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.dataStructures.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.spade_spam_AGP.savers.Saver;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SaverIntoFile
implements Saver {
    private BufferedWriter writer = null;
    private String path = null;
    boolean outputSequenceIdentifiers = false;

    public SaverIntoFile(String outputFilePath, boolean outputSequenceIdentifier) throws IOException {
        this.path = outputFilePath;
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.outputSequenceIdentifiers = outputSequenceIdentifier;
    }

    @Override
    public void savePattern(Pattern p) {
        if (this.writer != null) {
            StringBuilder r = new StringBuilder("");
            r.append(p.toStringToFile(this.outputSequenceIdentifiers));
            try {
                this.writer.write(r.toString());
                this.writer.newLine();
            }
            catch (IOException ex) {
                Logger.getLogger(SaverIntoFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void finish() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SaverIntoFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void clear() {
        this.writer = null;
    }

    @Override
    public String print() {
        return "Content at file " + this.path;
    }

    @Override
    public void savePatterns(Collection<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            this.savePattern(pattern);
        }
    }
}

