/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Bitmap;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Prefix;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoSPAM {
    private long startTime;
    private long endTime;
    private int patternCount;
    private int minsup = 0;
    BufferedWriter writer = null;
    Map<Integer, Bitmap> verticalDB = new HashMap<Integer, Bitmap>();
    List<Integer> sequencesSize = null;
    int lastBitIndex = 0;
    private int minimumPatternLength = 0;
    private int maximumPatternLength = Integer.MAX_VALUE;
    private int maxGap = Integer.MAX_VALUE;
    private boolean outputSequenceIdentifiers;

    public void runAlgorithm(String input, String outputFilePath, double minsupRel) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.spam(input, minsupRel);
        this.endTime = System.currentTimeMillis();
        this.writer.close();
    }

    private void spam(String input, double minsupRel) throws IOException {
        int n;
        String thisLine;
        BufferedReader reader;
        FileInputStream fin;
        this.verticalDB = new HashMap<Integer, Bitmap>();
        this.sequencesSize = new ArrayList<Integer>();
        this.lastBitIndex = 0;
        try {
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int bitIndex = 0;
            while ((thisLine = reader.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.sequencesSize.add(bitIndex);
                String[] stringArray = thisLine.split(" ");
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if (token.equals("-1")) {
                        ++bitIndex;
                    }
                    ++n2;
                }
            }
            this.lastBitIndex = bitIndex - 1;
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsup = (int)Math.ceil(minsupRel * (double)this.sequencesSize.size());
        if (this.minsup == 0) {
            this.minsup = 1;
        }
        try {
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int sid = 0;
            int tid = 0;
            while ((thisLine = reader.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] stringArray = thisLine.split(" ");
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String token = stringArray[n];
                    if (token.equals("-1")) {
                        ++tid;
                    } else if (token.equals("-2")) {
                        ++sid;
                        tid = 0;
                    } else {
                        Integer item = Integer.parseInt(token);
                        Bitmap bitmapItem = this.verticalDB.get(item);
                        if (bitmapItem == null) {
                            bitmapItem = new Bitmap(this.lastBitIndex);
                            this.verticalDB.put(item, bitmapItem);
                        }
                        bitmapItem.registerBit(sid, tid, this.sequencesSize);
                    }
                    ++n;
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, Bitmap>> iter = this.verticalDB.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Bitmap> entry = iter.next();
            if (entry.getValue().getSupport() < this.minsup) {
                iter.remove();
                continue;
            }
            if (this.minimumPatternLength <= 1 && this.maximumPatternLength >= 1) {
                this.savePattern(entry.getKey(), entry.getValue());
            }
            frequentItems.add(entry.getKey());
        }
        if (this.maximumPatternLength == 1) {
            return;
        }
        for (Map.Entry<Integer, Bitmap> entry : this.verticalDB.entrySet()) {
            Prefix prefix = new Prefix();
            prefix.addItemset(new Itemset(entry.getKey()));
            this.dfsPruning(prefix, entry.getValue(), frequentItems, frequentItems, entry.getKey(), 2);
        }
    }

    private void dfsPruning(Prefix prefix, Bitmap prefixBitmap, List<Integer> sn, List<Integer> in, int hasToBeGreaterThanForIStep, int m) throws IOException {
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> sTempBitmaps = new ArrayList<Bitmap>();
        for (Integer i : sn) {
            Bitmap newBitmap = prefixBitmap.createNewBitmapSStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex, this.maxGap);
            if (newBitmap.getSupportWithoutGapTotal() < this.minsup) continue;
            sTemp.add(i);
            sTempBitmaps.add(newBitmap);
        }
        int k = 0;
        while (k < sTemp.size()) {
            int item = (Integer)sTemp.get(k);
            Prefix prefixSStep = prefix.cloneSequence();
            prefixSStep.addItemset(new Itemset(item));
            Bitmap newBitmap = (Bitmap)sTempBitmaps.get(k);
            if (newBitmap.getSupport() >= this.minsup) {
                if (m >= this.minimumPatternLength) {
                    this.savePattern(prefixSStep, newBitmap);
                }
                if (this.maximumPatternLength > m) {
                    this.dfsPruning(prefixSStep, newBitmap, sTemp, sTemp, item, m + 1);
                }
            }
            ++k;
        }
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> iTempBitmaps = new ArrayList<Bitmap>();
        for (Integer i : in) {
            Bitmap newBitmap;
            if (i <= hasToBeGreaterThanForIStep || (newBitmap = prefixBitmap.createNewBitmapIStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex)).getSupport() < this.minsup) continue;
            iTemp.add(i);
            iTempBitmaps.add(newBitmap);
        }
        int k2 = 0;
        while (k2 < iTemp.size()) {
            int item = (Integer)iTemp.get(k2);
            Prefix prefixIStep = prefix.cloneSequence();
            prefixIStep.getItemsets().get(prefixIStep.size() - 1).addItem(item);
            Bitmap newBitmap = (Bitmap)iTempBitmaps.get(k2);
            if (m >= this.minimumPatternLength) {
                this.savePattern(prefixIStep, newBitmap);
            }
            if (this.maximumPatternLength > m) {
                this.dfsPruning(prefixIStep, newBitmap, sTemp, iTemp, item, m + 1);
            }
            ++k2;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void savePattern(Integer item, Bitmap bitmap) throws IOException {
        ++this.patternCount;
        StringBuilder r = new StringBuilder("");
        r.append(item);
        r.append(" -1 ");
        r.append("#SUP: ");
        r.append(bitmap.getSupport());
        if (this.outputSequenceIdentifiers) {
            r.append(" #SID: ");
            r.append(bitmap.getSIDs(this.sequencesSize));
        }
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    private void savePattern(Prefix prefix, Bitmap bitmap) throws IOException {
        ++this.patternCount;
        StringBuilder r = new StringBuilder("");
        for (Itemset itemset : prefix.getItemsets()) {
            for (Integer item : itemset.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append("-1 ");
        }
        r.append("#SUP: ");
        r.append(bitmap.getSupport());
        if (this.outputSequenceIdentifiers) {
            r.append(" #SID: ");
            r.append(bitmap.getSIDs(this.sequencesSize));
        }
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  SPAM v0.97a- STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("minsup " + this.minsup);
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }

    public void setMinimumPatternLength(int minimumPatternLength) {
        this.minimumPatternLength = minimumPatternLength;
    }

    public void setMaxGap(int maxGap) {
        this.maxGap = maxGap;
    }

    public void showSequenceIdentifiersInOutput(boolean showSequenceIdentifiers) {
        this.outputSequenceIdentifiers = showSequenceIdentifiers;
    }
}

