/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.uspan;

import ca.pfv.spmf.algorithms.sequentialpatterns.uspan.MatrixPosition;
import ca.pfv.spmf.algorithms.sequentialpatterns.uspan.QMatrix;
import ca.pfv.spmf.algorithms.sequentialpatterns.uspan.QMatrixProjection;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoUSpan {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int patternCount = 0;
    BufferedWriter writer = null;
    final int BUFFERS_SIZE = 2000;
    private int[] patternBuffer = null;
    final boolean DEBUG = false;
    final boolean SAVE_RESULT_EASIER_TO_READ_FORMAT = false;
    int minUtility = 0;
    int maxPatternLength = Integer.MAX_VALUE;
    String input;

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        ArrayList<QMatrix> database;
        block35: {
            String thisLine;
            BufferedReader myInput;
            int sequenceCount;
            HashMap<Integer, Integer> mapItemToSWU;
            block33: {
                MemoryLogger.getInstance().reset();
                this.input = input;
                this.patternBuffer = new int[2000];
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.minUtility = minUtility;
                mapItemToSWU = new HashMap<Integer, Integer>();
                sequenceCount = 0;
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] tokens = thisLine.split(" ");
                            String sequenceUtilityString = tokens[tokens.length - 1];
                            int positionColons = sequenceUtilityString.indexOf(58);
                            int sequenceUtility = Integer.parseInt(sequenceUtilityString.substring(positionColons + 1));
                            int i = 0;
                            while (i < tokens.length - 3) {
                                String currentToken = tokens[i];
                                if (currentToken.length() != 0 && currentToken.charAt(0) != '-') {
                                    int positionLeftBracketString = currentToken.indexOf(91);
                                    String itemString = currentToken.substring(0, positionLeftBracketString);
                                    Integer item = Integer.parseInt(itemString);
                                    Integer swu = (Integer)mapItemToSWU.get(item);
                                    swu = swu == null ? sequenceUtility : swu + sequenceUtility;
                                    mapItemToSWU.put(item, swu);
                                }
                                ++i;
                            }
                            ++sequenceCount;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            database = new ArrayList<QMatrix>(sequenceCount);
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int[] itemBuffer = new int[2000];
                    int[] utilityBuffer = new int[2000];
                    int[] itemsSequenceBuffer = new int[2000];
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        int itemBufferLength = 0;
                        int itemsLength = 0;
                        String[] tokens = thisLine.split(" ");
                        String sequenceUtilityString = tokens[tokens.length - 1];
                        int positionColons = sequenceUtilityString.indexOf(58);
                        int sequenceUtility = Integer.parseInt(sequenceUtilityString.substring(positionColons + 1));
                        int nbItemsets = 1;
                        boolean currentItemsetHasAPromisingItem = false;
                        int i = 0;
                        while (i < tokens.length - 3) {
                            String currentToken = tokens[i];
                            if (currentToken.length() != 0) {
                                if (currentToken.equals("-1")) {
                                    if (currentItemsetHasAPromisingItem) {
                                        itemBuffer[itemBufferLength] = -1;
                                        utilityBuffer[itemBufferLength] = -1;
                                        ++itemBufferLength;
                                        ++nbItemsets;
                                        currentItemsetHasAPromisingItem = false;
                                    }
                                } else {
                                    int positionLeftBracketString = currentToken.indexOf(91);
                                    int positionRightBracketString = currentToken.indexOf(93);
                                    String itemString = currentToken.substring(0, positionLeftBracketString);
                                    Integer item = Integer.parseInt(itemString);
                                    String utilityString = currentToken.substring(positionLeftBracketString + 1, positionRightBracketString);
                                    Integer itemUtility = Integer.parseInt(utilityString);
                                    if ((Integer)mapItemToSWU.get(item) >= minUtility) {
                                        currentItemsetHasAPromisingItem = true;
                                        itemBuffer[itemBufferLength] = item;
                                        utilityBuffer[itemBufferLength] = itemUtility;
                                        ++itemBufferLength;
                                        itemsSequenceBuffer[itemsLength++] = item;
                                    } else {
                                        sequenceUtility -= itemUtility.intValue();
                                    }
                                }
                            }
                            ++i;
                        }
                        if (sequenceUtility == 0) continue;
                        Arrays.sort(itemsSequenceBuffer, 0, itemsLength);
                        int newItemsPos = 0;
                        int lastItemSeen = -999;
                        int i2 = 0;
                        while (i2 < itemsLength) {
                            int item = itemsSequenceBuffer[i2];
                            if (item != lastItemSeen) {
                                itemsSequenceBuffer[newItemsPos++] = item;
                                lastItemSeen = item;
                            }
                            ++i2;
                        }
                        int nbItems = newItemsPos;
                        QMatrix matrix = new QMatrix(nbItems, nbItemsets, itemsSequenceBuffer, newItemsPos, sequenceUtility);
                        database.add(matrix);
                        int posBuffer = 0;
                        int itemset = 0;
                        while (itemset < nbItemsets) {
                            int posNames = 0;
                            while (posBuffer < itemBufferLength) {
                                int item = itemBuffer[posBuffer];
                                if (item == -1) {
                                    ++posBuffer;
                                    break;
                                }
                                if (item == matrix.itemNames[posNames]) {
                                    int utility = utilityBuffer[posBuffer];
                                    matrix.registerItem(posNames, itemset, utility, sequenceUtility -= utility);
                                    ++posNames;
                                    ++posBuffer;
                                    continue;
                                }
                                if (item > matrix.itemNames[posNames]) {
                                    matrix.registerItem(posNames, itemset, 0, sequenceUtility);
                                    ++posNames;
                                    continue;
                                }
                                matrix.registerItem(posNames, itemset, 0, sequenceUtility);
                                ++posBuffer;
                            }
                            ++itemset;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block35;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.uspanFirstTime(this.patternBuffer, 0, database);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void uspanFirstTime(int[] prefix, int prefixLength, List<QMatrix> database) throws IOException {
        HashMap<Integer, Integer> mapItemSWU = new HashMap<Integer, Integer>();
        for (QMatrix qMatrix : database) {
            int[] nArray = qMatrix.itemNames;
            int n = qMatrix.itemNames.length;
            int n2 = 0;
            while (n2 < n) {
                int item = nArray[n2];
                Integer currentSWU = (Integer)mapItemSWU.get(item);
                if (currentSWU == null) {
                    mapItemSWU.put(item, qMatrix.swu);
                } else {
                    mapItemSWU.put(item, currentSWU + qMatrix.swu);
                }
                ++n2;
            }
        }
        for (Map.Entry entry : mapItemSWU.entrySet()) {
            Integer itemSWU = (Integer)entry.getValue();
            if (itemSWU < this.minUtility) continue;
            int item = (Integer)entry.getKey();
            int totalUtility = 0;
            int totalRemainingUtility = 0;
            ArrayList<QMatrixProjection> matrixProjections = new ArrayList<QMatrixProjection>();
            for (QMatrix qmatrix : database) {
                int row = Arrays.binarySearch(qmatrix.itemNames, item);
                if (row < 0) continue;
                ArrayList<MatrixPosition> positions = new ArrayList<MatrixPosition>();
                int maxUtility = 0;
                int maxRemainingUtility = 0;
                int itemset = 0;
                while (itemset < qmatrix.matrixItemRemainingUtility[row].length) {
                    int utility = qmatrix.matrixItemUtility[row][itemset];
                    if (utility > 0) {
                        positions.add(new MatrixPosition(row, itemset, utility));
                        if (utility > maxUtility) {
                            maxUtility = utility;
                            int remaining = qmatrix.matrixItemRemainingUtility[row][itemset];
                            if (remaining > 0 && maxRemainingUtility == 0) {
                                maxRemainingUtility = remaining;
                            }
                        }
                    }
                    ++itemset;
                }
                totalUtility += maxUtility;
                totalRemainingUtility += maxRemainingUtility;
                QMatrixProjection projection = new QMatrixProjection(qmatrix, positions);
                matrixProjections.add(projection);
            }
            if (totalUtility + totalRemainingUtility < this.minUtility) continue;
            prefix[0] = item;
            if (totalUtility >= this.minUtility) {
                this.writeOut(prefix, 1, totalUtility);
            }
            if (1 >= this.maxPatternLength) continue;
            this.uspan(prefix, 1, matrixProjections, 1);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void uspan(int[] prefix, int prefixLength, List<QMatrixProjection> projectedDatabase, int itemCount) throws IOException {
        QMatrixProjection projection;
        int remaining;
        int newPrefixUtility;
        int newItemUtility;
        int column;
        ArrayList<MatrixPosition> positions;
        int maxRemainingUtility;
        int maxUtility;
        int totalRemainingUtility;
        int totalUtility;
        Pair itemSWU;
        Pair pair;
        Object currentSWU;
        HashMap<Integer, Pair> mapItemSWU = new HashMap<Integer, Pair>();
        for (QMatrixProjection qMatrixProjection : projectedDatabase) {
            for (MatrixPosition position : qMatrixProjection.positions) {
                int row = position.row + 1;
                int column2 = position.column;
                int localSequenceUtility = qMatrixProjection.getLocalSequenceUtility(position);
                while (row < qMatrixProjection.getItemNames().length) {
                    int item = qMatrixProjection.getItemNames()[row];
                    if (qMatrixProjection.getItemUtility(row, column2) > 0) {
                        currentSWU = (Pair)mapItemSWU.get(item);
                        if (currentSWU == null) {
                            pair = new Pair();
                            pair.lastSID = qMatrixProjection;
                            pair.swu = position.utility + localSequenceUtility;
                            mapItemSWU.put(item, pair);
                        } else if (((Pair)currentSWU).lastSID != qMatrixProjection) {
                            ((Pair)currentSWU).lastSID = qMatrixProjection;
                            ((Pair)currentSWU).swu += position.utility + localSequenceUtility;
                        }
                    }
                    ++row;
                }
            }
        }
        for (Map.Entry entry : mapItemSWU.entrySet()) {
            itemSWU = (Pair)entry.getValue();
            if (itemSWU.swu < this.minUtility) continue;
            int item = (Integer)entry.getKey();
            totalUtility = 0;
            totalRemainingUtility = 0;
            ArrayList<QMatrixProjection> matrixProjections = new ArrayList<QMatrixProjection>();
            for (QMatrixProjection qmatrix : projectedDatabase) {
                int rowItem = Arrays.binarySearch(qmatrix.getItemNames(), item);
                if (rowItem < 0) continue;
                maxUtility = 0;
                maxRemainingUtility = 0;
                positions = new ArrayList<MatrixPosition>();
                for (MatrixPosition position : qmatrix.positions) {
                    column = position.column;
                    newItemUtility = qmatrix.getItemUtility(rowItem, column);
                    if (newItemUtility <= 0) continue;
                    newPrefixUtility = position.utility + newItemUtility;
                    positions.add(new MatrixPosition(rowItem, column, newPrefixUtility));
                    if (newPrefixUtility <= maxUtility) continue;
                    maxUtility = newPrefixUtility;
                    remaining = qmatrix.getRemainingUtility(rowItem, column);
                    if (remaining <= 0 || maxRemainingUtility != 0) continue;
                    maxRemainingUtility = remaining;
                }
                totalUtility += maxUtility;
                totalRemainingUtility += maxRemainingUtility;
                projection = new QMatrixProjection(qmatrix, positions);
                matrixProjections.add(projection);
            }
            if (totalUtility + totalRemainingUtility < this.minUtility) continue;
            prefix[prefixLength] = item;
            if (totalUtility >= this.minUtility) {
                this.writeOut(prefix, prefixLength + 1, totalUtility);
            }
            if (itemCount + 1 >= this.maxPatternLength) continue;
            this.uspan(prefix, prefixLength + 1, matrixProjections, itemCount + 1);
        }
        mapItemSWU.clear();
        for (QMatrixProjection qMatrixProjection : projectedDatabase) {
            for (MatrixPosition position : qMatrixProjection.positions) {
                int localSequenceUtility = qMatrixProjection.getLocalSequenceUtility(position);
                int row = 0;
                while (row < qMatrixProjection.getItemNames().length) {
                    int item = qMatrixProjection.getItemNames()[row];
                    int column3 = position.column + 1;
                    while (column3 < qMatrixProjection.originalMatrix.matrixItemUtility[row].length) {
                        if (qMatrixProjection.getItemUtility(row, column3) > 0) {
                            currentSWU = (Pair)mapItemSWU.get(item);
                            if (currentSWU == null) {
                                pair = new Pair();
                                pair.lastSID = qMatrixProjection;
                                pair.swu = position.utility + localSequenceUtility;
                                mapItemSWU.put(item, pair);
                                break;
                            }
                            if (((Pair)currentSWU).lastSID == qMatrixProjection) break;
                            ((Pair)currentSWU).lastSID = qMatrixProjection;
                            ((Pair)currentSWU).swu += position.utility + localSequenceUtility;
                            break;
                        }
                        ++column3;
                    }
                    ++row;
                }
            }
        }
        for (Map.Entry entry : mapItemSWU.entrySet()) {
            itemSWU = (Pair)entry.getValue();
            if (itemSWU.swu < this.minUtility) continue;
            int item = (Integer)entry.getKey();
            totalUtility = 0;
            totalRemainingUtility = 0;
            ArrayList<QMatrixProjection> matrixProjections = new ArrayList<QMatrixProjection>();
            for (QMatrixProjection qmatrix : projectedDatabase) {
                int rowItem = Arrays.binarySearch(qmatrix.getItemNames(), item);
                if (rowItem < 0) continue;
                maxUtility = 0;
                maxRemainingUtility = 0;
                positions = new ArrayList();
                for (MatrixPosition position : qmatrix.positions) {
                    column = position.column + 1;
                    while (column < qmatrix.originalMatrix.matrixItemUtility[rowItem].length) {
                        newItemUtility = qmatrix.getItemUtility(rowItem, column);
                        if (newItemUtility > 0) {
                            newPrefixUtility = position.utility + newItemUtility;
                            positions.add(new MatrixPosition(rowItem, column, newPrefixUtility));
                            if (newPrefixUtility > maxUtility) {
                                maxUtility = newPrefixUtility;
                                remaining = qmatrix.getRemainingUtility(rowItem, column);
                                if (remaining > 0 && maxRemainingUtility == 0) {
                                    maxRemainingUtility = remaining;
                                }
                            }
                        }
                        ++column;
                    }
                }
                totalUtility += maxUtility;
                totalRemainingUtility += maxRemainingUtility;
                projection = new QMatrixProjection(qmatrix, positions);
                matrixProjections.add(projection);
            }
            if (totalUtility + totalRemainingUtility < this.minUtility) continue;
            prefix[prefixLength] = -1;
            prefix[prefixLength + 1] = item;
            if (totalUtility >= this.minUtility) {
                this.writeOut(prefix, prefixLength + 2, totalUtility);
            }
            if (itemCount + 1 >= this.maxPatternLength) continue;
            this.uspan(prefix, prefixLength + 2, matrixProjections, itemCount + 1);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void setMaxPatternLength(int maxPatternLength) {
        this.maxPatternLength = maxPatternLength;
    }

    private void writeOut(int[] prefix, int prefixLength, int utility) throws IOException {
        ++this.patternCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append("-1 #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkIfUtilityOfPatternIsCorrect(int[] prefix, int prefixLength, int utility) throws IOException {
        int calculatedUtility;
        block15: {
            calculatedUtility = 0;
            BufferedReader myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(this.input))));
            try {
                try {
                    String thisLine;
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] tokens = thisLine.split(" ");
                        int tokensLength = tokens.length - 3;
                        int[] sequence = new int[tokensLength];
                        int[] sequenceUtility = new int[tokensLength];
                        int i = 0;
                        while (i < tokensLength) {
                            String currentToken = tokens[i];
                            if (currentToken.length() != 0) {
                                int itemUtility;
                                int item;
                                if (currentToken.equals("-1")) {
                                    item = -1;
                                    itemUtility = 0;
                                } else {
                                    int positionLeftBracketString = currentToken.indexOf(91);
                                    int positionRightBracketString = currentToken.indexOf(93);
                                    String itemString = currentToken.substring(0, positionLeftBracketString);
                                    item = Integer.parseInt(itemString);
                                    String utilityString = currentToken.substring(positionLeftBracketString + 1, positionRightBracketString);
                                    itemUtility = Integer.parseInt(utilityString);
                                }
                                sequence[i] = item;
                                sequenceUtility[i] = itemUtility;
                            }
                            ++i;
                        }
                        int util = this.tryToMatch(sequence, sequenceUtility, prefix, prefixLength, 0, 0, 0);
                        calculatedUtility += util;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        if (calculatedUtility != utility) {
            System.out.print(" ERROR, WRONG UTILITY FOR PATTERN : ");
            int i = 0;
            while (i < prefixLength) {
                System.out.print(prefix[i]);
                ++i;
            }
            System.out.println(" utility is: " + utility + " but should be: " + calculatedUtility);
        }
    }

    private int tryToMatch(int[] sequence, int[] sequenceUtility, int[] prefix, int prefixLength, int prefixPos, int seqPos, int utility) {
        ArrayList<Integer> otherUtilityValues = new ArrayList<Integer>();
        int posP = prefixPos;
        int posS = seqPos;
        int previousPrefixPos = prefixPos;
        int itemsetUtility = 0;
        while (posP < prefixLength & posS < sequence.length) {
            int otherUtility;
            if (prefix[posP] == -1 && sequence[posS] == -1) {
                otherUtility = this.tryToMatch(sequence, sequenceUtility, prefix, prefixLength, previousPrefixPos, ++posS, utility);
                otherUtilityValues.add(otherUtility);
                utility += itemsetUtility;
                itemsetUtility = 0;
                previousPrefixPos = ++posP;
                continue;
            }
            if (prefix[posP] == -1) {
                while (posS < sequence.length && sequence[posS] != -1) {
                    ++posS;
                }
                otherUtility = this.tryToMatch(sequence, sequenceUtility, prefix, prefixLength, previousPrefixPos, posS, utility);
                otherUtilityValues.add(otherUtility);
                utility += itemsetUtility;
                itemsetUtility = 0;
                previousPrefixPos = posP;
                continue;
            }
            if (sequence[posS] == -1) {
                posP = previousPrefixPos;
                itemsetUtility = 0;
                ++posS;
                continue;
            }
            if (prefix[posP] == sequence[posS]) {
                itemsetUtility += sequenceUtility[posS];
                ++posS;
                if (++posP != prefixLength) continue;
                while (posS < sequence.length && sequence[posS] != -1) {
                    ++posS;
                }
                otherUtility = this.tryToMatch(sequence, sequenceUtility, prefix, prefixLength, previousPrefixPos, posS, utility);
                otherUtilityValues.add(otherUtility);
                utility += itemsetUtility;
                continue;
            }
            if (prefix[posP] == sequence[posS]) continue;
            ++posS;
        }
        int max = 0;
        if (posP == prefixLength) {
            max = utility;
        }
        Iterator iterator = otherUtilityValues.iterator();
        while (iterator.hasNext()) {
            int utilValue = (Integer)iterator.next();
            if (utilValue <= utility) continue;
            max = utilValue;
        }
        return max;
    }

    public void printStatistics() {
        System.out.println("=============  USPAN ALGORITHM v98c - STATS ==========");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility sequential pattern count : " + this.patternCount);
        System.out.println("========================================================");
    }

    private class Pair {
        int swu;
        QMatrixProjection lastSID;

        private Pair() {
        }
    }
}

