/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.movingaverage;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.Arrays;

public class AlgoMovingAverage {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = false;

    public TimeSeries runAlgorithm(TimeSeries timeSeries, int windowSize) throws IOException {
        if (timeSeries.data.length < windowSize) {
            throw new IllegalArgumentException(" The window size should be greater or equal to 1");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        if (this.DEBUG_MODE) {
            System.out.println(" Time series: " + Arrays.toString(timeSeries.data));
        }
        double[] movingAverageData = this.calculateMovingAverage(timeSeries.data, windowSize);
        TimeSeries movingAverage = new TimeSeries(movingAverageData, String.valueOf(timeSeries.getName()) + "_MAVG");
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return movingAverage;
    }

    private double[] calculateMovingAverage(double[] timeSeries, int windowSize) {
        double[] movingAverage = new double[timeSeries.length];
        double sum = 0.0;
        double firstSum = 0.0;
        int i = 0;
        while (i < timeSeries.length) {
            if (i < windowSize - 1) {
                sum += timeSeries[i] / (double)windowSize;
                movingAverage[i] = (firstSum += timeSeries[i]) / (double)(i + 1);
            } else {
                if (i >= windowSize) {
                    sum -= timeSeries[i - windowSize] / (double)windowSize;
                }
                movingAverage[i] = sum += timeSeries[i] / (double)windowSize;
            }
            ++i;
        }
        if (this.DEBUG_MODE) {
            System.out.println(" Number of data points = " + timeSeries.length);
            System.out.println(" Window size = " + windowSize);
            System.out.println(" Moving average transformation: " + Arrays.toString(movingAverage));
        }
        return movingAverage;
    }

    public void printStats() {
        System.out.println("=============  Transform to Moving Average v2.05- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }
}

