/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.sax;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.sax.AlgoSAX;
import ca.pfv.spmf.algorithms.timeseries.sax.SAXSymbol;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;

public class MainTestSAX_MultipleTimeSeries {
    public static void main(String[] arg) throws IOException {
        int numberOfSegments = 3;
        int numberOfSymbols = 3;
        ArrayList<TimeSeries> timeSeries = new ArrayList<TimeSeries>();
        TimeSeries timeSeries1 = new TimeSeries(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0}, "SERIES1");
        TimeSeries timeSeries2 = new TimeSeries(new double[]{10.0, 9.0, 8.0, 7.0, 6.0, 5.0}, "SERIES2");
        TimeSeries timeSeries3 = new TimeSeries(new double[]{-1.0, -2.0, -3.0, -4.0, -5.0}, "SERIES3");
        TimeSeries timeSeries4 = new TimeSeries(new double[]{-1.0, -2.0, -3.0, -4.0, -5.0}, "SERIES4");
        timeSeries.add(timeSeries1);
        timeSeries.add(timeSeries2);
        timeSeries.add(timeSeries3);
        timeSeries.add(timeSeries4);
        AlgoSAX algorithm = new AlgoSAX();
        SAXSymbol[][] saxSequences = algorithm.runAlgorithm(timeSeries, numberOfSegments, numberOfSymbols);
        algorithm.printStats();
        Object[] symbols = algorithm.getSymbols();
        System.out.println(" SAX SYMBOLS: ");
        System.out.println(" Symbols : " + Arrays.toString(symbols) + System.lineSeparator());
        System.out.println(" SAX SEQUENCES : ");
        SAXSymbol[][] sAXSymbolArray = saxSequences;
        int n = saxSequences.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] saxSequence = sAXSymbolArray[n2];
            System.out.println(" Sequence : " + Arrays.toString(saxSequence));
            ++n2;
        }
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestSAX_MultipleTimeSeries.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

