/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.split;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.tools.MemoryLogger;

public class AlgoSplitTimeSeries {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    boolean DEBUG_MODE = true;
    private int numberOfSeries;

    public TimeSeries[] runAlgorithm(TimeSeries timeSeries, int sizeOfSegment) {
        if (sizeOfSegment < 1) {
            throw new IllegalArgumentException(" The size of segment should be > 1");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.numberOfSeries = (int)Math.ceil((double)timeSeries.data.length / (double)sizeOfSegment);
        if (this.DEBUG_MODE) {
            System.out.println(" The time series: " + timeSeries);
            System.out.println(" The length of the time series is: " + timeSeries.data.length);
            System.out.println(" The size of segment is : " + sizeOfSegment);
            System.out.println(" It will be splitted into " + this.numberOfSeries + " time series.");
        }
        TimeSeries[] splittedTimeSeries = this.splitTimeSeries(timeSeries, sizeOfSegment);
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return splittedTimeSeries;
    }

    public TimeSeries[] runAlgorithm(int number, TimeSeries timeSeries) {
        if (number < 1) {
            throw new IllegalArgumentException(" The number of segments should be > 1");
        }
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        int sizeOfSegment = (int)Math.ceil((double)timeSeries.size() / (double)number);
        this.numberOfSeries = number;
        if (this.DEBUG_MODE) {
            System.out.println(" The time series: " + timeSeries);
            System.out.println(" The length of the time series is: " + timeSeries.data.length);
            System.out.println(" The size of segment is : " + sizeOfSegment);
            System.out.println(" It will be splitted into " + this.numberOfSeries + " time series.");
        }
        TimeSeries[] splittedTimeSeries = this.splitTimeSeries(timeSeries, sizeOfSegment);
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return splittedTimeSeries;
    }

    private TimeSeries[] splitTimeSeries(TimeSeries timeSeries, int sizeOfSegment) {
        TimeSeries[] splittedTimeSeries = new TimeSeries[(int)Math.ceil(this.numberOfSeries)];
        int currentDataPoint = 0;
        int i = 0;
        while (i < this.numberOfSeries) {
            int numberOfPoints = timeSeries.data.length - currentDataPoint;
            if (numberOfPoints >= sizeOfSegment) {
                numberOfPoints = sizeOfSegment;
            }
            double[] dataPoints = new double[numberOfPoints];
            splittedTimeSeries[i] = new TimeSeries(dataPoints, String.valueOf(timeSeries.getName()) + "_PART" + i);
            int j = 0;
            while (j < numberOfPoints) {
                double dataPoint;
                splittedTimeSeries[i].data[j] = dataPoint = timeSeries.data[currentDataPoint++];
                ++j;
            }
            ++i;
        }
        return splittedTimeSeries;
    }

    public void printStats() {
        System.out.println("=============  Split Time Series  ALGORITHM v2.05- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" The result is " + this.numberOfSeries + " time series.");
        System.out.println("===================================================");
    }
}

