/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.timeseriesviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class Plot {
    private PlotOptions opts = new PlotOptions();
    private Rectangle boundRect;
    private PlotArea plotArea;
    private Map<String, Axis> xAxes = new HashMap<String, Axis>(3);
    private Map<String, Axis> yAxes = new HashMap<String, Axis>(3);
    private Map<String, DataSeries> dataSeriesMap = new LinkedHashMap<String, DataSeries>(5);

    public static Plot plot(PlotOptions opts) {
        return new Plot(opts);
    }

    public static PlotOptions plotOpts() {
        return new PlotOptions();
    }

    private Plot(PlotOptions opts) {
        if (opts != null) {
            this.opts = opts;
        }
        this.boundRect = new Rectangle(0, 0, this.opts.width, this.opts.height);
        this.plotArea = new PlotArea();
    }

    public PlotOptions opts() {
        return this.opts;
    }

    public Plot xAxis(String name, AxisOptions opts) {
        this.xAxes.put(name, new Axis(name, opts));
        return this;
    }

    public Plot yAxis(String name, AxisOptions opts) {
        this.yAxes.put(name, new Axis(name, opts));
        return this;
    }

    public Plot series(String name, Data data, DataSeriesOptions opts) {
        DataSeries series = this.dataSeriesMap.get(name);
        if (opts != null) {
            opts.setPlot(this);
        }
        if (series == null) {
            series = new DataSeries(name, data, opts);
            this.dataSeriesMap.put(name, series);
        } else {
            series.data = data;
            series.opts = opts;
        }
        return this;
    }

    public Plot series(String name, DataSeriesOptions opts) {
        DataSeries series = this.dataSeriesMap.get(name);
        if (opts != null) {
            opts.setPlot(this);
        }
        if (series != null) {
            series.opts = opts;
        }
        return this;
    }

    private void calc(Graphics2D g) {
        this.plotArea.calc(g);
    }

    private void clear() {
        this.plotArea.clear();
        for (DataSeries series : this.dataSeriesMap.values()) {
            series.clear();
        }
    }

    private BufferedImage draw() {
        BufferedImage image = new BufferedImage(this.opts.width, this.opts.height, 1);
        Graphics2D g = image.createGraphics();
        try {
            this.calc(g);
            this.drawBackground(g);
            this.plotArea.draw(g);
            for (DataSeries series : this.dataSeriesMap.values()) {
                series.draw(g);
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
    }

    private void drawBackground(Graphics2D g) {
        g.setColor(this.opts.backgroundColor);
        g.fillRect(0, 0, this.opts.width, this.opts.height);
    }

    public void save(String fileName, String type) throws IOException {
        this.clear();
        BufferedImage bi = this.draw();
        File outputFile = new File(String.valueOf(fileName) + "." + type);
        ImageIO.write((RenderedImage)bi, type, outputFile);
    }

    public static AxisOptions axisOpts() {
        return new AxisOptions();
    }

    public static DataSeriesOptions seriesOpts() {
        return new DataSeriesOptions();
    }

    public static Data data() {
        return new Data();
    }

    private static void drawLabel(Graphics2D g, String s, int x, int y, HorizAlign hAlign, VertAlign vAlign) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(s, g);
        if (hAlign == HorizAlign.RIGHT) {
            x = (int)((double)x - rect.getWidth());
        } else if (hAlign == HorizAlign.CENTER) {
            x = (int)((double)x - rect.getWidth() / 2.0);
        }
        if (vAlign == VertAlign.TOP) {
            y = (int)((double)y + rect.getHeight());
        } else if (vAlign == VertAlign.CENTER) {
            y = (int)((double)y + rect.getHeight() / 2.0);
        }
        g.drawString(s, x, y);
    }

    public static String formatDouble(double d, AxisFormat format) {
        switch (format) {
            case TIME_HM: {
                return String.format("%tR", new Date((long)d));
            }
            case TIME_HMS: {
                return String.format("%tT", new Date((long)d));
            }
            case DATE: {
                return String.format("%tF", new Date((long)d));
            }
            case DATETIME_HM: {
                return String.format("%tF %1$tR", new Date((long)d));
            }
            case DATETIME_HMS: {
                return String.format("%tF %1$tT", new Date((long)d));
            }
            case NUMBER_KGM: {
                return Plot.formatDoubleAsNumber(d, true);
            }
            case NUMBER_INT: {
                return Integer.toString((int)d);
            }
        }
        return Plot.formatDoubleAsNumber(d, false);
    }

    private static String formatDoubleAsNumber(double d, boolean useKGM) {
        if (useKGM && d > 1000.0 && d < 1.0E12) {
            long[] numbers = new long[]{1000L, 1000000L, 1000000000L};
            char[] suffix = new char[]{'K', 'M', 'G'};
            int i = 0;
            double r = 0.0;
            long[] lArray = numbers;
            int n = numbers.length;
            int n2 = 0;
            while (n2 < n) {
                long number = lArray[n2];
                r = d / (double)number;
                if (r < 1000.0) break;
                ++i;
                ++n2;
            }
            if (i == suffix.length) {
                --i;
            }
            return String.format("%1$,.2f%2$c", r, Character.valueOf(suffix[i]));
        }
        return String.format("%1$.3G", d);
    }

    private static double x2x(double x, Range xr1, Range xr2) {
        return xr1.diff == 0.0 ? xr2.min + xr2.diff / 2.0 : xr2.min + (x - xr1.min) / xr1.diff * xr2.diff;
    }

    private static double y2y(double x, Range xr1, Range xr2) {
        return xr1.diff == 0.0 ? xr2.min + xr2.diff / 2.0 : xr2.max - (x - xr1.min) / xr1.diff * xr2.diff;
    }

    private static int toInt(double d) {
        return (int)Math.round(d);
    }

    public int getWidth() {
        return this.opts.width;
    }

    public int getHeight() {
        return this.opts.height;
    }

    public void showInJFrame(String title) {
        this.clear();
        BufferedImage bi = this.draw();
        JFrame frame = new JFrame();
        frame.setTitle(title);
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new JLabel(new ImageIcon(bi)));
        frame.pack();
        frame.setVisible(true);
    }

    public void drawChartOnGraphics2D(Graphics2D g) {
        this.calc(g);
        this.drawBackground(g);
        this.plotArea.draw(g);
        for (DataSeries series : this.dataSeriesMap.values()) {
            series.draw(g);
        }
    }

    public Rectangle getPlotAreaRectangle() {
        return this.plotArea.plotBorderRect;
    }

    private class Axis {
        private String name;
        private AxisOptions opts = new AxisOptions();
        private Rectangle2D labelRect;
        private String[] labels;

        public Axis(String name, AxisOptions opts) {
            this.name = name;
            if (opts != null) {
                this.opts = opts;
            }
        }

        public String toString() {
            return "Axis [name=" + this.name + ", opts=" + this.opts + "]";
        }
    }

    public static enum AxisFormat {
        NUMBER,
        NUMBER_KGM,
        NUMBER_INT,
        TIME_HM,
        TIME_HMS,
        DATE,
        DATETIME_HM,
        DATETIME_HMS;

    }

    public static class AxisOptions {
        private AxisFormat format = AxisFormat.NUMBER;
        private boolean dynamicRange = true;
        private Range range;

        public AxisOptions format(AxisFormat format) {
            this.format = format;
            return this;
        }

        public AxisOptions range(double min, double max) {
            this.range = new Range(min, max);
            this.dynamicRange = false;
            return this;
        }
    }

    public static class Data {
        private double[] x1;
        private double[] y1;
        private List<Double> x2;
        private List<Double> y2;

        private Data() {
        }

        public Data xy(double[] x, double[] y) {
            this.x1 = x;
            this.y1 = y;
            return this;
        }

        public Data xy(double x, double y) {
            if (this.x2 == null || this.y2 == null) {
                this.x2 = new ArrayList<Double>(10);
                this.y2 = new ArrayList<Double>(10);
            }
            this.x2.add(x);
            this.y2.add(y);
            return this;
        }

        public Data xy(List<Double> x, List<Double> y) {
            this.x2 = x;
            this.y2 = y;
            return this;
        }

        public int size() {
            if (this.x1 != null) {
                return this.x1.length;
            }
            if (this.x2 != null) {
                return this.x2.size();
            }
            return 0;
        }

        public double x(int i) {
            if (this.x1 != null) {
                return this.x1[i];
            }
            if (this.x2 != null) {
                return this.x2.get(i);
            }
            return 0.0;
        }

        public double y(int i) {
            if (this.y1 != null) {
                return this.y1[i];
            }
            if (this.y2 != null) {
                return this.y2.get(i);
            }
            return 0.0;
        }
    }

    public class DataSeries {
        private String name;
        private String nameWithAxes;
        private DataSeriesOptions opts = new DataSeriesOptions();
        private Data data;

        public DataSeries(String name, Data data, DataSeriesOptions opts) {
            if (opts != null) {
                this.opts = opts;
            }
            this.name = name;
            this.data = data;
            if (this.data == null) {
                this.data = Plot.data();
            }
        }

        public void clear() {
        }

        private void addAxesToName() {
            this.nameWithAxes = String.valueOf(this.name) + " (" + this.opts.yAxis.name + "/" + this.opts.xAxis.name + ")";
        }

        private Range xRange() {
            Range range = new Range(0.0, 0.0);
            if (this.data != null && this.data.size() > 0) {
                range = new Range(this.data.x(0), this.data.x(0));
                int i = 1;
                while (i < this.data.size()) {
                    if (this.data.x(i) > range.max) {
                        range.setMax(this.data.x(i));
                    }
                    if (this.data.x(i) < range.min) {
                        range.setMin(this.data.x(i));
                    }
                    ++i;
                }
            }
            return range;
        }

        private Range yRange() {
            Range range = new Range(0.0, 0.0);
            if (this.data != null && this.data.size() > 0) {
                range = new Range(this.data.y(0), this.data.y(0));
                int i = 1;
                while (i < this.data.size()) {
                    if (this.data.y(i) > range.max) {
                        range.setMax(this.data.y(i));
                    }
                    if (this.data.y(i) < range.min) {
                        range.setMin(this.data.y(i));
                    }
                    ++i;
                }
            }
            return range;
        }

        private void draw(Graphics2D g) {
            g.setClip(Plot.this.plotArea.plotClipRect);
            if (this.data != null) {
                double x1 = 0.0;
                double y1 = 0.0;
                int size = this.data.size();
                if (this.opts.line != Line.NONE) {
                    int j = 0;
                    while (j < size) {
                        double x2 = Plot.x2x(this.data.x(j), this.opts.xAxis.opts.range, Plot.this.plotArea.xPlotRange);
                        double y2 = Plot.y2y(this.data.y(j), this.opts.yAxis.opts.range, Plot.this.plotArea.yPlotRange);
                        int ix1 = Plot.toInt(x1);
                        int iy1 = Plot.toInt(y1);
                        int ix2 = Plot.toInt(x2);
                        int iy2 = Plot.toInt(y2);
                        int iy3 = ((PlotArea)((Plot)Plot.this).plotArea).plotRect.y + ((PlotArea)((Plot)Plot.this).plotArea).plotRect.height;
                        if (size == 1) {
                            ix1 = ix2;
                            iy1 = iy2;
                        }
                        if (j != 0 || size == 1) {
                            this.fillArea(g, ix1, iy1, ix2, iy2, iy3);
                            this.drawLine(g, ix1, iy1, ix2, iy2);
                        }
                        x1 = x2;
                        y1 = y2;
                        ++j;
                    }
                }
                int halfMarkerSize = this.opts.markerSize / 2;
                int halfDiagMarkerSize = this.getDiagMarkerSize() / 2;
                g.setStroke(new BasicStroke(2.0f));
                if (this.opts.marker != Marker.NONE) {
                    int j = 0;
                    while (j < size) {
                        double x2 = Plot.x2x(this.data.x(j), this.opts.xAxis.opts.range, Plot.this.plotArea.xPlotRange);
                        double y2 = Plot.y2y(this.data.y(j), this.opts.yAxis.opts.range, Plot.this.plotArea.yPlotRange);
                        this.drawMarker(g, halfMarkerSize, halfDiagMarkerSize, x2, y2, ((PlotArea)((Plot)Plot.this).plotArea).plotRect.x, ((PlotArea)((Plot)Plot.this).plotArea).plotRect.y + ((PlotArea)((Plot)Plot.this).plotArea).plotRect.height);
                        ++j;
                    }
                }
            }
        }

        private int getDiagMarkerSize() {
            return (int)Math.round(Math.sqrt(2 * this.opts.markerSize * this.opts.markerSize));
        }

        private void fillArea(Graphics2D g, int ix1, int iy1, int ix2, int iy2, int iy3) {
            if (this.opts.areaColor != null) {
                g.setColor(this.opts.areaColor);
                g.fill(new Polygon(new int[]{ix1, ix2, ix2, ix1}, new int[]{iy1, iy2, iy3, iy3}, 4));
                g.setColor(this.opts.seriesColor);
            }
        }

        private void drawLine(Graphics2D g, int ix1, int iy1, int ix2, int iy2) {
            if (this.opts.line != Line.NONE) {
                g.setColor(this.opts.seriesColor);
                this.setStroke(g);
                g.drawLine(ix1, iy1, ix2, iy2);
            }
        }

        private void setStroke(Graphics2D g) {
            switch (this.opts.line) {
                case SOLID: {
                    g.setStroke(new BasicStroke(this.opts.lineWidth));
                    break;
                }
                case DASHED: {
                    g.setStroke(new BasicStroke(this.opts.lineWidth, 1, 1, 10.0f, this.opts.lineDash, 0.0f));
                }
            }
        }

        private void drawMarker(Graphics2D g, int x2, int y2, int x3, int y3) {
            int halfMarkerSize = this.opts.markerSize / 2;
            int halfDiagMarkerSize = this.getDiagMarkerSize() / 2;
            g.setStroke(new BasicStroke(2.0f));
            this.drawMarker(g, halfMarkerSize, halfDiagMarkerSize, x2, y2, x3, y3);
        }

        private void drawMarker(Graphics2D g, int halfMarkerSize, int halfDiagMarkerSize, double x2, double y2, double x3, double y3) {
            switch (this.opts.marker) {
                case CIRCLE: {
                    g.setColor(this.opts.markerColor);
                    g.fillOval(Plot.toInt(x2 - (double)halfMarkerSize), Plot.toInt(y2 - (double)halfMarkerSize), this.opts.markerSize, this.opts.markerSize);
                    g.setColor(this.opts.seriesColor);
                    g.drawOval(Plot.toInt(x2 - (double)halfMarkerSize), Plot.toInt(y2 - (double)halfMarkerSize), this.opts.markerSize, this.opts.markerSize);
                    break;
                }
                case SQUARE: {
                    g.setColor(this.opts.markerColor);
                    g.fillRect(Plot.toInt(x2 - (double)halfMarkerSize), Plot.toInt(y2 - (double)halfMarkerSize), this.opts.markerSize, this.opts.markerSize);
                    g.setColor(this.opts.seriesColor);
                    g.drawRect(Plot.toInt(x2 - (double)halfMarkerSize), Plot.toInt(y2 - (double)halfMarkerSize), this.opts.markerSize, this.opts.markerSize);
                    break;
                }
                case DIAMOND: {
                    int[] xpts = new int[]{Plot.toInt(x2), Plot.toInt(x2 + (double)halfDiagMarkerSize), Plot.toInt(x2), Plot.toInt(x2 - (double)halfDiagMarkerSize)};
                    int[] ypts = new int[]{Plot.toInt(y2 - (double)halfDiagMarkerSize), Plot.toInt(y2), Plot.toInt(y2 + (double)halfDiagMarkerSize), Plot.toInt(y2)};
                    g.setColor(this.opts.markerColor);
                    g.fillPolygon(xpts, ypts, 4);
                    g.setColor(this.opts.seriesColor);
                    g.drawPolygon(xpts, ypts, 4);
                    break;
                }
                case COLUMN: {
                    g.setColor(this.opts.markerColor);
                    g.fillRect(Plot.toInt(x2), Plot.toInt(y2), this.opts.markerSize, Plot.toInt(y3 - y2));
                    g.setColor(this.opts.seriesColor);
                    g.drawRect(Plot.toInt(x2), Plot.toInt(y2), this.opts.markerSize, Plot.toInt(y3 - y2));
                    break;
                }
                case BAR: {
                    g.setColor(this.opts.markerColor);
                    g.fillRect(Plot.toInt(x3), Plot.toInt(y2), Plot.toInt(x2 - x3), this.opts.markerSize);
                    g.setColor(this.opts.seriesColor);
                    g.drawRect(Plot.toInt(x3), Plot.toInt(y2), Plot.toInt(x2 - x3), this.opts.markerSize);
                }
            }
        }
    }

    public static class DataSeriesOptions {
        private Color seriesColor = Color.BLUE;
        private Line line = Line.SOLID;
        private int lineWidth = 2;
        private float[] lineDash = new float[]{3.0f, 3.0f};
        private Marker marker = Marker.NONE;
        private int markerSize = 10;
        private Color markerColor = Color.WHITE;
        private Color areaColor = null;
        private String xAxisName;
        private String yAxisName;
        private Axis xAxis;
        private Axis yAxis;

        public DataSeriesOptions color(Color seriesColor) {
            this.seriesColor = seriesColor;
            return this;
        }

        public DataSeriesOptions line(Line line) {
            this.line = line;
            return this;
        }

        public DataSeriesOptions lineWidth(int width) {
            this.lineWidth = width;
            return this;
        }

        public DataSeriesOptions lineDash(float[] dash) {
            this.lineDash = dash;
            return this;
        }

        public DataSeriesOptions marker(Marker marker) {
            this.marker = marker;
            return this;
        }

        public DataSeriesOptions markerSize(int markerSize) {
            this.markerSize = markerSize;
            return this;
        }

        public DataSeriesOptions markerColor(Color color) {
            this.markerColor = color;
            return this;
        }

        public DataSeriesOptions areaColor(Color color) {
            this.areaColor = color;
            return this;
        }

        public DataSeriesOptions xAxis(String name) {
            this.xAxisName = name;
            return this;
        }

        public DataSeriesOptions yAxis(String name) {
            this.yAxisName = name;
            return this;
        }

        private void setPlot(Plot plot) {
            if (plot != null) {
                this.xAxis = (Axis)plot.xAxes.get(this.xAxisName);
            }
            if (plot != null) {
                this.yAxis = (Axis)plot.yAxes.get(this.yAxisName);
            }
        }
    }

    private static enum HorizAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    private class Legend {
        Rectangle rect;
        Rectangle2D labelRect;
        public int entryWidth;
        public int entryWidthPadded;
        public int entryCount;
        public int xCount;
        public int yCount;

        private Legend() {
        }
    }

    public static enum LegendFormat {
        NONE,
        TOP,
        RIGHT,
        BOTTOM;

    }

    public static enum Line {
        NONE,
        SOLID,
        DASHED;

    }

    public static enum Marker {
        NONE,
        CIRCLE,
        SQUARE,
        DIAMOND,
        COLUMN,
        BAR;

    }

    private class PlotArea {
        private Rectangle plotBorderRect = new Rectangle();
        private Rectangle plotRect = new Rectangle();
        private Rectangle plotClipRect = new Rectangle();
        private Legend legend;
        private Range xPlotRange;
        private Range yPlotRange;

        public PlotArea() {
            this.legend = new Legend();
            this.xPlotRange = new Range(0.0, 0.0);
            this.yPlotRange = new Range(0.0, 0.0);
            this.clear();
        }

        private void clear() {
            this.plotBorderRect.setBounds(Plot.this.boundRect);
            this.plotRectChanged();
        }

        private void offset(int dx, int dy, int dw, int dh) {
            this.plotBorderRect.translate(dx, dy);
            this.plotBorderRect.setSize(this.plotBorderRect.width - dx - dw, this.plotBorderRect.height - dy - dh);
            this.plotRectChanged();
        }

        private void plotRectChanged() {
            this.plotRect.setBounds(this.plotBorderRect.x + Plot.this.opts.plotPadding, this.plotBorderRect.y + Plot.this.opts.plotPadding, this.plotBorderRect.width - Plot.this.opts.plotPadding * 2, this.plotBorderRect.height - Plot.this.opts.plotPadding * 2);
            this.xPlotRange.setMin(this.plotRect.getX());
            this.xPlotRange.setMax(this.plotRect.getX() + this.plotRect.getWidth());
            this.yPlotRange.setMin(this.plotRect.getY());
            this.yPlotRange.setMax(this.plotRect.getY() + this.plotRect.getHeight());
            this.plotClipRect.setBounds(this.plotBorderRect.x + 1, this.plotBorderRect.y + 1, this.plotBorderRect.width - 1, this.plotBorderRect.height - 1);
        }

        private void calc(Graphics2D g) {
            this.calcAxes(g);
            this.calcRange(true);
            this.calcRange(false);
            this.calcAxisLabels(g, true);
            this.calcAxisLabels(g, false);
            g.setFont(Plot.this.opts.titleFont);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D titleRect = fm.getStringBounds(Plot.this.opts.title, g);
            g.setFont(Plot.this.opts.labelFont);
            fm = g.getFontMetrics();
            int xAxesHeight = 0;
            int xAxesHalfWidth = 0;
            for (Map.Entry entry : Plot.this.xAxes.entrySet()) {
                Axis xAxis = (Axis)entry.getValue();
                xAxesHeight += Plot.toInt(xAxis.labelRect.getHeight()) + Plot.this.opts.labelPadding * 2;
                if (!(xAxis.labelRect.getWidth() > (double)xAxesHalfWidth)) continue;
                xAxesHalfWidth = Plot.toInt(xAxis.labelRect.getWidth());
            }
            int yAxesWidth = 0;
            for (Map.Entry entry : Plot.this.yAxes.entrySet()) {
                yAxesWidth += Plot.toInt(((Axis)entry.getValue()).labelRect.getWidth()) + Plot.this.opts.labelPadding * 2;
            }
            int n = Plot.this.opts.padding + yAxesWidth;
            int dy = Plot.this.opts.padding + Plot.toInt(titleRect.getHeight() + (double)Plot.this.opts.labelPadding);
            int dw = Plot.this.opts.padding;
            if (Plot.this.opts.legend != LegendFormat.RIGHT) {
                dw += xAxesHalfWidth;
            }
            int dh = Plot.this.opts.padding + xAxesHeight;
            Rectangle temp = new Rectangle(this.plotBorderRect);
            this.offset(n, dy, dw, dh);
            this.calcLegend(g);
            this.plotBorderRect.setBounds(temp);
            switch (Plot.this.opts.legend) {
                case TOP: {
                    dy += this.legend.rect.height + Plot.this.opts.labelPadding;
                    break;
                }
                case RIGHT: {
                    dw += this.legend.rect.width + Plot.this.opts.labelPadding;
                    break;
                }
                case BOTTOM: {
                    dh += this.legend.rect.height;
                }
            }
            this.offset(n, dy, dw, dh);
        }

        private void draw(Graphics2D g) {
            this.drawPlotArea(g);
            this.drawGrid(g);
            this.drawAxes(g);
            this.drawLegend(g);
        }

        private void drawPlotArea(Graphics2D g) {
            g.setColor(Plot.this.opts.foregroundColor);
            g.drawRect(this.plotBorderRect.x, this.plotBorderRect.y, this.plotBorderRect.width, this.plotBorderRect.height);
            g.setFont(Plot.this.opts.titleFont);
            Plot.drawLabel(g, Plot.this.opts.title, this.plotBorderRect.x + Plot.toInt(this.plotBorderRect.getWidth() / 2.0), Plot.this.opts.padding, HorizAlign.CENTER, VertAlign.TOP);
        }

        private void drawGrid(Graphics2D g) {
            Stroke stroke = g.getStroke();
            g.setStroke(Plot.this.opts.gridStroke);
            g.setColor(Plot.this.opts.gridColor);
            int leftX = this.plotBorderRect.x + 1;
            int rightX = this.plotBorderRect.x + this.plotBorderRect.width - 1;
            int topY = this.plotBorderRect.y + 1;
            int bottomY = this.plotBorderRect.y + this.plotBorderRect.height - 1;
            int i = 0;
            while (i < ((PlotOptions)((Plot)Plot.this).opts).grids.x + 1) {
                int x = Plot.toInt((double)this.plotRect.x + this.plotRect.getWidth() / (double)((PlotOptions)((Plot)Plot.this).opts).grids.x * (double)i);
                g.drawLine(x, topY, x, bottomY);
                ++i;
            }
            i = 0;
            while (i < ((PlotOptions)((Plot)Plot.this).opts).grids.y + 1) {
                int y = Plot.toInt((double)this.plotRect.y + this.plotRect.getHeight() / (double)((PlotOptions)((Plot)Plot.this).opts).grids.y * (double)i);
                g.drawLine(leftX, y, rightX, y);
                ++i;
            }
            g.setStroke(stroke);
        }

        private void calcAxes(Graphics2D g) {
            Axis xAxis = Plot.this.xAxes.isEmpty() ? new Axis("", null) : (Axis)Plot.this.xAxes.values().iterator().next();
            Axis yAxis = Plot.this.yAxes.isEmpty() ? new Axis("", null) : (Axis)Plot.this.yAxes.values().iterator().next();
            int xCount = 0;
            int yCount = 0;
            for (DataSeries series : Plot.this.dataSeriesMap.values()) {
                if (series.opts.xAxis == null) {
                    series.opts.xAxis = xAxis;
                    ++xCount;
                }
                if (series.opts.yAxis == null) {
                    series.opts.yAxis = yAxis;
                    ++yCount;
                }
                series.addAxesToName();
            }
            if (Plot.this.xAxes.isEmpty() && xCount > 0) {
                Plot.this.xAxes.put("x", xAxis);
            }
            if (Plot.this.yAxes.isEmpty() && yCount > 0) {
                Plot.this.yAxes.put("y", yAxis);
            }
        }

        private void calcAxisLabels(Graphics2D g, boolean isX) {
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = null;
            double w = 0.0;
            double h = 0.0;
            Map axes = isX ? Plot.this.xAxes : Plot.this.yAxes;
            int grids = isX ? ((PlotOptions)((Plot)Plot.this).opts).grids.x : ((PlotOptions)((Plot)Plot.this).opts).grids.y;
            for (Map.Entry entry : axes.entrySet()) {
                Axis axis = (Axis)entry.getValue();
                axis.labels = new String[grids + 1];
                axis.labelRect = fm.getStringBounds("", g);
                double xStep = axis.opts.range.diff / (double)grids;
                int j = 0;
                while (j < grids + 1) {
                    ((Axis)axis).labels[j] = Plot.formatDouble(axis.opts.range.min + xStep * (double)j, axis.opts.format);
                    rect = fm.getStringBounds(axis.labels[j], g);
                    if (rect.getWidth() > w) {
                        w = rect.getWidth();
                    }
                    if (rect.getHeight() > h) {
                        h = rect.getHeight();
                    }
                    ++j;
                }
                axis.labelRect.setRect(0.0, 0.0, w, h);
            }
        }

        private void calcRange(boolean isX) {
            Axis axis;
            for (DataSeries series : Plot.this.dataSeriesMap.values()) {
                Range range;
                Axis axis2 = axis = isX ? series.opts.xAxis : series.opts.yAxis;
                if (!axis.opts.dynamicRange) continue;
                Range range2 = range = isX ? series.xRange() : series.yRange();
                if (axis.opts.range == null) {
                    axis.opts.range = range;
                    continue;
                }
                if (range.max > axis.opts.range.max) {
                    axis.opts.range.setMax(range.max);
                }
                if (!(range.min < axis.opts.range.min)) continue;
                axis.opts.range.setMin(range.min);
            }
            Map axes = isX ? Plot.this.xAxes : Plot.this.yAxes;
            Iterator it = axes.values().iterator();
            while (it.hasNext()) {
                axis = (Axis)it.next();
                if (axis.opts.range != null) continue;
                it.remove();
            }
        }

        private void drawAxes(Graphics2D g) {
            int j;
            Axis axis;
            g.setFont(Plot.this.opts.labelFont);
            g.setColor(Plot.this.opts.foregroundColor);
            int leftXPadded = this.plotBorderRect.x - Plot.this.opts.labelPadding;
            int rightX = this.plotBorderRect.x + this.plotBorderRect.width;
            int bottomY = this.plotBorderRect.y + this.plotBorderRect.height;
            int bottomYPadded = bottomY + Plot.this.opts.labelPadding;
            int axisOffset = 0;
            for (Map.Entry entry : Plot.this.xAxes.entrySet()) {
                axis = (Axis)entry.getValue();
                double xStep = axis.opts.range.diff / (double)((PlotOptions)((Plot)Plot.this).opts).grids.x;
                Plot.drawLabel(g, axis.name, rightX + Plot.this.opts.labelPadding, bottomY + axisOffset, HorizAlign.LEFT, VertAlign.CENTER);
                g.drawLine(this.plotRect.x, bottomY + axisOffset, this.plotRect.x + this.plotRect.width, bottomY + axisOffset);
                j = 0;
                while (j < ((PlotOptions)((Plot)Plot.this).opts).grids.x + 1) {
                    int x = Plot.toInt((double)this.plotRect.x + this.plotRect.getWidth() / (double)((PlotOptions)((Plot)Plot.this).opts).grids.x * (double)j);
                    Plot.drawLabel(g, Plot.formatDouble(axis.opts.range.min + xStep * (double)j, axis.opts.format), x, bottomYPadded + axisOffset, HorizAlign.CENTER, VertAlign.TOP);
                    g.drawLine(x, bottomY + axisOffset, x, bottomY + Plot.this.opts.tickSize + axisOffset);
                    ++j;
                }
                axisOffset += Plot.toInt(axis.labelRect.getHeight() + (double)(Plot.this.opts.labelPadding * 2));
            }
            axisOffset = 0;
            for (Map.Entry entry : Plot.this.yAxes.entrySet()) {
                axis = (Axis)entry.getValue();
                double yStep = axis.opts.range.diff / (double)((PlotOptions)((Plot)Plot.this).opts).grids.y;
                Plot.drawLabel(g, axis.name, leftXPadded - axisOffset, this.plotBorderRect.y - Plot.toInt(axis.labelRect.getHeight() + (double)Plot.this.opts.labelPadding), HorizAlign.RIGHT, VertAlign.CENTER);
                g.drawLine(this.plotBorderRect.x - axisOffset, this.plotRect.y + this.plotRect.height, this.plotBorderRect.x - axisOffset, this.plotRect.y);
                j = 0;
                while (j < ((PlotOptions)((Plot)Plot.this).opts).grids.y + 1) {
                    int y = Plot.toInt((double)this.plotRect.y + this.plotRect.getHeight() / (double)((PlotOptions)((Plot)Plot.this).opts).grids.y * (double)j);
                    Plot.drawLabel(g, Plot.formatDouble(axis.opts.range.max - yStep * (double)j, axis.opts.format), leftXPadded - axisOffset, y, HorizAlign.RIGHT, VertAlign.CENTER);
                    g.drawLine(this.plotBorderRect.x - axisOffset, y, this.plotBorderRect.x - Plot.this.opts.tickSize - axisOffset, y);
                    ++j;
                }
                axisOffset += Plot.toInt(axis.labelRect.getWidth() + (double)(Plot.this.opts.labelPadding * 2));
            }
        }

        private void calcLegend(Graphics2D g) {
            this.legend.rect = new Rectangle(0, 0);
            if (Plot.this.opts.legend == LegendFormat.NONE) {
                return;
            }
            int size = Plot.this.dataSeriesMap.size();
            if (size == 0) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            Iterator it = Plot.this.dataSeriesMap.values().iterator();
            this.legend.labelRect = fm.getStringBounds(((DataSeries)it.next()).nameWithAxes, g);
            int legendSignSize = Plot.this.opts.defaultLegendSignSize;
            while (it.hasNext()) {
                DataSeries series = (DataSeries)it.next();
                Rectangle2D rect = fm.getStringBounds(series.nameWithAxes, g);
                if (rect.getWidth() > this.legend.labelRect.getWidth()) {
                    this.legend.labelRect.setRect(0.0, 0.0, rect.getWidth(), this.legend.labelRect.getHeight());
                }
                if (rect.getHeight() > this.legend.labelRect.getHeight()) {
                    this.legend.labelRect.setRect(0.0, 0.0, this.legend.labelRect.getWidth(), rect.getHeight());
                }
                switch (series.opts.marker) {
                    case CIRCLE: 
                    case SQUARE: {
                        if (series.opts.markerSize + Plot.this.opts.defaultLegendSignSize <= legendSignSize) break;
                        legendSignSize = series.opts.markerSize + Plot.this.opts.defaultLegendSignSize;
                        break;
                    }
                    case DIAMOND: {
                        if (series.getDiagMarkerSize() + Plot.this.opts.defaultLegendSignSize <= legendSignSize) break;
                        legendSignSize = series.getDiagMarkerSize() + Plot.this.opts.defaultLegendSignSize;
                    }
                }
            }
            Plot.this.opts.legendSignSize = legendSignSize;
            this.legend.entryWidth = legendSignSize + Plot.this.opts.labelPadding + Plot.toInt(this.legend.labelRect.getWidth());
            this.legend.entryWidthPadded = this.legend.entryWidth + Plot.this.opts.labelPadding;
            switch (Plot.this.opts.legend) {
                case TOP: 
                case BOTTOM: {
                    this.legend.entryCount = (int)Math.floor((double)(this.plotBorderRect.width - Plot.this.opts.labelPadding) / (double)this.legend.entryWidthPadded);
                    this.legend.xCount = size <= this.legend.entryCount ? size : this.legend.entryCount;
                    this.legend.yCount = size <= this.legend.entryCount ? 1 : (int)Math.ceil((double)size / (double)this.legend.entryCount);
                    this.legend.rect.width = Plot.this.opts.labelPadding + this.legend.xCount * this.legend.entryWidthPadded;
                    this.legend.rect.height = Plot.this.opts.labelPadding + Plot.toInt((double)this.legend.yCount * ((double)Plot.this.opts.labelPadding + this.legend.labelRect.getHeight()));
                    this.legend.rect.x = this.plotBorderRect.x + (this.plotBorderRect.width - this.legend.rect.width) / 2;
                    if (Plot.this.opts.legend == LegendFormat.TOP) {
                        this.legend.rect.y = this.plotBorderRect.y;
                        break;
                    }
                    this.legend.rect.y = ((Plot)Plot.this).boundRect.height - this.legend.rect.height - Plot.this.opts.padding;
                    break;
                }
                case RIGHT: {
                    this.legend.rect.width = Plot.this.opts.labelPadding * 3 + legendSignSize + Plot.toInt(this.legend.labelRect.getWidth());
                    this.legend.rect.height = Plot.this.opts.labelPadding * (size + 1) + Plot.toInt(this.legend.labelRect.getHeight() * (double)size);
                    this.legend.rect.x = ((Plot)Plot.this).boundRect.width - this.legend.rect.width - Plot.this.opts.padding;
                    this.legend.rect.y = this.plotBorderRect.y + this.plotBorderRect.height / 2 - this.legend.rect.height / 2;
                }
            }
        }

        private void drawLegend(Graphics2D g) {
            if (Plot.this.opts.legend == LegendFormat.NONE) {
                return;
            }
            g.drawRect(this.legend.rect.x, this.legend.rect.y, this.legend.rect.width, this.legend.rect.height);
            int labelHeight = Plot.toInt(this.legend.labelRect.getHeight());
            int x = this.legend.rect.x + Plot.this.opts.labelPadding;
            int y = this.legend.rect.y + Plot.this.opts.labelPadding + labelHeight / 2;
            switch (Plot.this.opts.legend) {
                case TOP: 
                case BOTTOM: {
                    int i = 0;
                    for (DataSeries series : Plot.this.dataSeriesMap.values()) {
                        this.drawLegendEntry(g, series, x, y);
                        x += this.legend.entryWidthPadded;
                        if ((i + 1) % this.legend.xCount == 0) {
                            x = this.legend.rect.x + Plot.this.opts.labelPadding;
                            y += Plot.this.opts.labelPadding + labelHeight;
                        }
                        ++i;
                    }
                    break;
                }
                case RIGHT: {
                    for (DataSeries series : Plot.this.dataSeriesMap.values()) {
                        this.drawLegendEntry(g, series, x, y);
                        y += Plot.this.opts.labelPadding + labelHeight;
                    }
                    break;
                }
            }
        }

        private void drawLegendEntry(Graphics2D g, DataSeries series, int x, int y) {
            series.fillArea(g, x, y, x + Plot.this.opts.legendSignSize, y, y + Plot.this.opts.legendSignSize / 2);
            series.drawLine(g, x, y, x + Plot.this.opts.legendSignSize, y);
            series.drawMarker(g, x + Plot.this.opts.legendSignSize / 2, y, x, y + Plot.this.opts.legendSignSize / 2);
            g.setColor(Plot.this.opts.foregroundColor);
            Plot.drawLabel(g, series.nameWithAxes, x + Plot.this.opts.legendSignSize + Plot.this.opts.labelPadding, y, HorizAlign.LEFT, VertAlign.CENTER);
        }
    }

    public static class PlotOptions {
        private String title = "";
        private int width = 800;
        private int height = 600;
        private Color backgroundColor = Color.WHITE;
        private Color foregroundColor = Color.BLACK;
        private Font titleFont = new Font("Arial", 1, 16);
        private int padding = 10;
        private int plotPadding = 0;
        private int labelPadding = 10;
        private int defaultLegendSignSize = 10;
        private int legendSignSize = 10;
        private Point grids = new Point(10, 10);
        private Color gridColor = Color.GRAY;
        private Stroke gridStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f);
        private int tickSize = 5;
        private Font labelFont = new Font("Arial", 0, 12);
        private LegendFormat legend = LegendFormat.NONE;

        private PlotOptions() {
        }

        public PlotOptions title(String title) {
            this.title = title;
            return this;
        }

        public PlotOptions width(int width) {
            this.width = width;
            return this;
        }

        public PlotOptions height(int height) {
            this.height = height;
            return this;
        }

        public PlotOptions bgColor(Color color) {
            this.backgroundColor = color;
            return this;
        }

        public PlotOptions fgColor(Color color) {
            this.foregroundColor = color;
            return this;
        }

        public PlotOptions titleFont(Font font) {
            this.titleFont = font;
            return this;
        }

        public PlotOptions padding(int padding) {
            this.padding = padding;
            return this;
        }

        public PlotOptions plotPadding(int padding) {
            this.plotPadding = padding;
            return this;
        }

        public PlotOptions labelPadding(int padding) {
            this.labelPadding = padding;
            return this;
        }

        public PlotOptions labelFont(Font font) {
            this.labelFont = font;
            return this;
        }

        public PlotOptions grids(int byX, int byY) {
            this.grids = new Point(byX, byY);
            return this;
        }

        public PlotOptions gridColor(Color color) {
            this.gridColor = color;
            return this;
        }

        public PlotOptions gridStroke(Stroke stroke) {
            this.gridStroke = stroke;
            return this;
        }

        public PlotOptions tickSize(int value) {
            this.tickSize = value;
            return this;
        }

        public PlotOptions legend(LegendFormat legend) {
            this.legend = legend;
            return this;
        }
    }

    public static class Range {
        private double min;
        private double max;
        private double diff;

        public Range(double min, double max) {
            this.min = min;
            this.max = max;
            this.diff = max - min;
        }

        public Range(Range range) {
            this.min = range.min;
            this.max = range.max;
            this.diff = this.max - this.min;
        }

        public void setMin(double min) {
            this.min = min;
            this.diff = this.max - min;
        }

        public void setMax(double max) {
            this.max = max;
            this.diff = max - this.min;
        }

        public String toString() {
            return "Range [min=" + this.min + ", max=" + this.max + "]";
        }
    }

    private static enum VertAlign {
        TOP,
        CENTER,
        BOTTOM;

    }
}

