/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.timeseries.timeseriesviewer;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.timeseriesviewer.TimeSeriesViewerPanel;
import ca.pfv.spmf.algorithms.timeseries.timeseriesviewer.TimeSeriesViewerPanelListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class TimeSeriesViewer
extends JFrame
implements TimeSeriesViewerPanelListener {
    String title = "SPFM Time Series Viewer 2.05";
    private static final long serialVersionUID = 1L;
    TimeSeriesViewerPanel panel = null;
    private JLabel labelX;
    private JLabel labelY;

    public TimeSeriesViewer(List<TimeSeries> timeSeries) {
        this.setTitle(this.title);
        this.setSize(909, 505);
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        final TimeSeriesViewerPanel panelChart = new TimeSeriesViewerPanel(timeSeries);
        panelChart.setBounds(1, 1, 800, 500);
        panelChart.setForeground(Color.WHITE);
        panelChart.addListener(this);
        this.getContentPane().add(panelChart);
        JScrollPane scrollPane = new JScrollPane(panelChart);
        scrollPane.setBounds(10, 6, 878, 416);
        scrollPane.setForeground(Color.BLACK);
        scrollPane.setAutoscrolls(true);
        this.getContentPane().add(scrollPane);
        JButton buttonZoomIn = new JButton("");
        buttonZoomIn.setIcon(new ImageIcon(TimeSeriesViewer.class.getResource("/ca/pfv/spmf/algorithms/timeseries/timeseriesviewer/zoomin.gif")));
        buttonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panelChart.increaseZoom();
            }
        });
        buttonZoomIn.setBounds(302, 432, 50, 29);
        this.getContentPane().add(buttonZoomIn);
        JButton buttonZoomOut = new JButton("");
        buttonZoomOut.setIcon(new ImageIcon(TimeSeriesViewer.class.getResource("/ca/pfv/spmf/algorithms/timeseries/timeseriesviewer/zoomout.gif")));
        buttonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panelChart.decreaseZoom();
            }
        });
        buttonZoomOut.setBounds(355, 432, 50, 29);
        this.getContentPane().add(buttonZoomOut);
        JButton buttonSaveAsPng = new JButton("Save as PNG");
        buttonSaveAsPng.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panelChart.export();
            }
        });
        buttonSaveAsPng.setIcon(new ImageIcon(TimeSeriesViewer.class.getResource("/ca/pfv/spmf/algorithms/timeseries/timeseriesviewer/save.gif")));
        buttonSaveAsPng.setBounds(414, 432, 163, 29);
        this.getContentPane().add(buttonSaveAsPng);
        JButton buttonPrint = new JButton("Print");
        buttonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panelChart.doPrint();
            }
        });
        buttonPrint.setIcon(new ImageIcon(TimeSeriesViewer.class.getResource("/ca/pfv/spmf/algorithms/timeseries/timeseriesviewer/print.gif")));
        buttonPrint.setBounds(580, 432, 163, 29);
        this.getContentPane().add(buttonPrint);
        this.labelX = new JLabel("x = ");
        this.labelX.setBounds(20, 432, 98, 27);
        this.getContentPane().add(this.labelX);
        this.labelY = new JLabel("y = ");
        this.labelY.setBounds(125, 432, 98, 27);
        this.getContentPane().add(this.labelY);
    }

    @Override
    public void notifyOfNewMousePosition(double x, double y) {
        DecimalFormat df = new DecimalFormat("0.00");
        df.setMaximumFractionDigits(2);
        String stringX = df.format(x);
        String stringY = df.format(y);
        this.labelX.setText("x = " + stringX);
        this.labelY.setText("y = " + stringY);
    }

    @Override
    public void notifyMouseOutOfChart() {
        this.labelX.setText("x = ");
        this.labelY.setText("y = ");
    }
}

